/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import com.tydic.osworkflow.engine.runtime.Task;
import com.tydic.osworkflow.engine.runtime.TaskService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskReqBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskRspBO;
import com.tydic.uac.atom.task.UacCreateTaskAtomService;
import com.tydic.uac.bo.common.ApprovalObjInfoMQBO;
import com.tydic.uac.bo.common.UacNoInstanceAuditInfo;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.busi.UacNoTaskAuditOrderAuditBusiService;
import com.tydic.uac.config.ProperticeVo;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.ApprovalLogExtMapMapper;
import com.tydic.uac.dao.ApprovalLogMapper;
import com.tydic.uac.dao.ApprovalObjMapper;
import com.tydic.uac.dao.ApprovalOrderMapper;
import com.tydic.uac.dao.ApprovalStepTempDateMapper;
import com.tydic.uac.dao.task.UacOrdTaskMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.ApprovalLogExtMapPO;
import com.tydic.uac.po.ApprovalLogPO;
import com.tydic.uac.po.ApprovalObjPO;
import com.tydic.uac.po.ApprovalOrderPO;
import com.tydic.uac.po.ApprovalStepTempDataPO;
import com.tydic.uac.po.task.OrdTaskPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="uacNoTaskAuditOrderAuditBusiService")
public class UacNoTaskAuditOrderAuditBusiServiceImpl
implements UacNoTaskAuditOrderAuditBusiService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private ApprovalOrderMapper approvalOrderMapper;
    @Autowired
    private ApprovalLogMapper approvalLogMapper;
    @Autowired
    private ApprovalObjMapper approvalObjMapper;
    @Autowired
    private ApprovalLogExtMapMapper approvalLogExtMapMapper;
    private static final String DOWNLOAD = "download";
    @Resource(name="approvalObjInfoMQ")
    private ProxyMessageProducer approvalObjInfoMQ;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String sysCode;
    @Autowired
    private ProperticeVo properticeVo;
    @Autowired
    private ApprovalStepTempDateMapper approvalStepTempDateMapper;
    @Autowired
    private UacOrdTaskMapper uacOrdTaskMapper;
    @Autowired
    private UacCreateTaskAtomService uacCreateTaskAtomService;
    private Logger logger = LoggerFactory.getLogger(UacNoTaskAuditOrderAuditBusiService.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UacNoTaskAuditOrderAuditBusiServiceImpl.class);

    @Transactional
    public UacNoTaskAuditOrderAuditRspBO dealObjectAudit(UacNoTaskAuditOrderAuditReqBO reqBO) {
        List ids;
        this.val(reqBO);
        reqBO.setSysCode(this.sysCode);
        boolean flag = true;
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderId())) {
            ids = reqBO.getOrderId();
        } else {
            ids = reqBO.getObjId();
            flag = false;
        }
        if (reqBO.getProcDefId() == null && reqBO.getProcDefKey() == null) {
            ApprovalOrderPO approvalOrderPO = this.getApproval((Long)ids.get(0), reqBO, flag);
            if (approvalOrderPO == null) {
                throw new BusinessException("6001", "\u6ca1\u6709\u627e\u5230\u8be5\u5ba1\u6279\u5355");
            }
            OrdTaskPO ordTaskPO = new OrdTaskPO();
            ordTaskPO.setOrderId(approvalOrderPO.getOrderId());
            ordTaskPO.setObjId(approvalOrderPO.getAuditOrderId());
            ordTaskPO.setObjType(UacCommConstant.ORDER_TYPE.AUDIT_NO_TASK);
            ordTaskPO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
            try {
                ordTaskPO = this.uacOrdTaskMapper.getModelBy(ordTaskPO);
            }
            catch (Exception e) {
                this.logger.debug("\u67e5\u8be2\u73af\u8282\u5b9e\u4f8b\u5931\u8d25" + e.getMessage());
                throw new BusinessException("6001", "\u67e5\u8be2\u73af\u8282\u5b9e\u4f8b\u5931\u8d25");
            }
            if (ordTaskPO == null) {
                throw new BusinessException("6001", "\u672a\u67e5\u8be2\u5230\u73af\u8282\u5b9e\u4f8b");
            }
            String isProcId = this.properticeVo.getIsProcKey();
            if ("true".equals(isProcId)) {
                reqBO.setProcDefKey(ordTaskPO.getBusiCode());
            } else {
                reqBO.setProcDefId(ordTaskPO.getProcInstId());
            }
        }
        if (reqBO.getVariables() == null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>(1);
            map.put("approvalResult", reqBO.getAuditResult());
            reqBO.setVariables(map);
        } else if (reqBO.getVariables().size() > 0) {
            reqBO.getVariables().computeIfAbsent("approvalResult", k -> reqBO.getAuditResult());
        } else {
            reqBO.getVariables().put("approvalResult", reqBO.getAuditResult());
        }
        return this.dealAudit(reqBO, ids, flag);
    }

    private UacNoTaskAuditOrderAuditRspBO dealAudit(UacNoTaskAuditOrderAuditReqBO reqBO, List<Long> ids, boolean flag) {
        StepWithOutInstance stepInstance = this.proc(reqBO);
        Sequence sequence = Sequence.getInstance();
        ArrayList<ApprovalLogPO> logPOS = new ArrayList<ApprovalLogPO>();
        ArrayList<ApprovalLogExtMapPO> extMapPOS = new ArrayList<ApprovalLogExtMapPO>();
        ArrayList<UacNoInstanceAuditInfo> auditInfos = new ArrayList<UacNoInstanceAuditInfo>();
        for (Long orderId : ids) {
            ApprovalOrderPO approvalOrderPO = this.updateApproval(orderId, reqBO, stepInstance, flag);
            ApprovalLogPO logPO = this.logParam(approvalOrderPO, stepInstance, reqBO, sequence);
            logPOS.add(logPO);
            if (reqBO.getExt() != null && reqBO.getExt().size() > 0) {
                Set keys = reqBO.getExt().keySet();
                for (String k : keys) {
                    extMapPOS.add(this.logExtMap(logPO, k, (String)reqBO.getExt().get(k), sequence));
                }
            }
            if (reqBO.getDownload() != null) {
                extMapPOS.add(this.logExtMap(logPO, DOWNLOAD, reqBO.getDownload(), sequence));
            }
            auditInfos.add(this.auditInfo(approvalOrderPO));
        }
        UacNoneInstanceBO noneInstanceBO = new UacNoneInstanceBO();
        BeanUtils.copyProperties((Object)stepInstance, (Object)noneInstanceBO);
        noneInstanceBO.setAuditAdvice(reqBO.getAuditAdvice());
        noneInstanceBO.setAuditResult(String.valueOf(reqBO.getAuditResult()));
        noneInstanceBO.setOperId(reqBO.getOperId());
        noneInstanceBO.setAuditInfos(auditInfos);
        noneInstanceBO.setFinish(stepInstance.getIsFinish());
        if (reqBO.getMsgFlag() != null && UacCommConstant.MSG_GLAG.YES.equals(reqBO.getMsgFlag())) {
            ApprovalObjInfoMQBO approvalObjInfoMQBO = new ApprovalObjInfoMQBO();
            approvalObjInfoMQBO.setNoneInstance(noneInstanceBO);
            try {
                this.approvalObjInfoMQ.send(new ProxyMessage(this.properticeVo.getUacNotifyTopic(), this.properticeVo.getUacNotifyTag(), JSONObject.toJSONString((Object)approvalObjInfoMQBO)));
            }
            catch (Exception e) {
                throw new BusinessException("6001", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u53d1\u9001\u6d88\u606f\u961f\u5217MQ\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            }
        }
        this.saveLog(logPOS, extMapPOS);
        UacNoTaskAuditOrderAuditRspBO rspBO = new UacNoTaskAuditOrderAuditRspBO();
        rspBO.setNoneInstanceBO(noneInstanceBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UacNoInstanceAuditInfo auditInfo(ApprovalOrderPO approvalOrderPO) {
        ApprovalObjPO approvalObjPO = new ApprovalObjPO();
        approvalObjPO.setOrderId(approvalObjPO.getOrderId());
        approvalObjPO.setAuditOrderId(approvalOrderPO.getAuditOrderId());
        List<ApprovalObjPO> list = this.approvalObjMapper.getList(approvalObjPO);
        ArrayList<String> ids = new ArrayList<String>();
        UacNoInstanceAuditInfo auditInfo = new UacNoInstanceAuditInfo();
        BeanUtils.copyProperties((Object)approvalOrderPO, (Object)auditInfo);
        if (list.isEmpty()) {
            return auditInfo;
        }
        for (ApprovalObjPO objPO : list) {
            ids.add(objPO.getObjId());
        }
        auditInfo.setObjIdList(ids);
        return auditInfo;
    }

    private void saveLog(List<ApprovalLogPO> logPOS, List<ApprovalLogExtMapPO> extMapPOS) {
        if (logPOS.isEmpty()) {
            return;
        }
        try {
            this.approvalLogMapper.insertBatch(logPOS);
            if (!extMapPOS.isEmpty()) {
                this.approvalLogExtMapMapper.insertBatch(extMapPOS);
            }
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u5ba1\u6279\u8bb0\u5f55\u65e5\u5fd7,\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    private ApprovalLogPO logParam(ApprovalOrderPO approvalOrderPO, StepWithOutInstance stepInstance, UacNoTaskAuditOrderAuditReqBO reqBO, Sequence sequence) {
        List candidates;
        ApprovalLogPO logPO = new ApprovalLogPO();
        BeanUtils.copyProperties((Object)approvalOrderPO, (Object)logPO);
        logPO.setId(sequence.nextId());
        logPO.setOrderId(approvalOrderPO.getOrderId());
        logPO.setPreOperId(approvalOrderPO.getPreOperId());
        logPO.setOperid(reqBO.getOperId());
        logPO.setOperName(reqBO.getUsername());
        logPO.setOperDept(reqBO.getOperDept());
        logPO.setAuditResult(reqBO.getAuditResult());
        logPO.setAuditOrderId(approvalOrderPO.getAuditOrderId());
        logPO.setAuditAdvice(reqBO.getAuditAdvice());
        if (stepInstance.getIsFinish().booleanValue()) {
            logPO.setNextStepName("\u6d41\u7a0b\u7ed3\u675f\u8282\u70b9");
            logPO.setNextStepDesc("\u6d41\u7a0b\u7ed3\u675f\u8282\u70b9");
        } else {
            logPO.setNextStepName(stepInstance.getStepName());
            logPO.setNextStepDesc(stepInstance.getStepDesc());
        }
        logPO.setNextStepId(stepInstance.getStepId());
        logPO.setFinish(stepInstance.getIsFinish() != false ? 1 : 0);
        logPO.setDealTime(new Date());
        OrdTaskPO ordTaskPO = this.dealTask(approvalOrderPO, stepInstance, reqBO.getAuditResult(), reqBO);
        this.dealTempDate(approvalOrderPO, stepInstance, logPO, ordTaskPO);
        if (stepInstance.getCustomAttributes() != null && !stepInstance.getCustomAttributes().isEmpty()) {
            int i = 0;
            StringBuilder id = new StringBuilder();
            StringBuilder name = new StringBuilder();
            for (String key : stepInstance.getCustomAttributes().keySet()) {
                id.append(",").append(key);
                name.append(",").append(stepInstance.getCustomAttributes().get(key));
                if (++i != 50) continue;
                break;
            }
            logPO.setNextStationName(name.substring(name.indexOf(",") + 1));
            logPO.setNextStationId(id.substring(id.indexOf(",") + 1));
        }
        if (stepInstance.getTaskList() != null && !stepInstance.getTaskList().isEmpty() && (candidates = ((Task)stepInstance.getTaskList().get(0)).getCandidates()) != null && candidates.size() > 0) {
            int i = 0;
            StringBuilder id = new StringBuilder();
            StringBuilder name = new StringBuilder();
            for (String str : candidates) {
                JSONObject jsonObject = JSONObject.parseObject((String)str);
                name.append(",").append(jsonObject.getString("userName"));
                id.append(",").append(jsonObject.getString("userId"));
                if (++i == 50) break;
                logPO.setNextOperId(id.substring(id.indexOf(",") + 1));
                logPO.setNextOperName(name.substring(name.indexOf(",") + 1));
            }
        }
        return logPO;
    }

    private OrdTaskPO dealTask(ApprovalOrderPO approvalOrderPO, StepWithOutInstance stepInstance, Integer aduit, UacNoTaskAuditOrderAuditReqBO reqBO) {
        OrdTaskPO ordTaskPO = new OrdTaskPO();
        ordTaskPO.setOrderId(approvalOrderPO.getOrderId());
        ordTaskPO.setObjType(UacCommConstant.ORDER_TYPE.AUDIT_NO_TASK);
        ordTaskPO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
        ordTaskPO.setObjId(approvalOrderPO.getAuditOrderId());
        try {
            ordTaskPO = this.uacOrdTaskMapper.getModelBy(ordTaskPO);
        }
        catch (Exception e) {
            this.logger.debug("\u67e5\u8be2\u73af\u8282\u5b9e\u4f8b\u5931\u8d25" + e.getMessage());
            throw new BusinessException("6001", "\u67e5\u8be2\u73af\u8282\u5b9e\u4f8b\u5931\u8d25");
        }
        OrdTaskPO updateTaskPO = new OrdTaskPO();
        updateTaskPO.setTaskId(ordTaskPO.getTaskId());
        updateTaskPO.setOrderId(approvalOrderPO.getOrderId());
        updateTaskPO.setFinishTime(new Date());
        updateTaskPO.setTaskState(UacCommConstant.TASK_STATE.PROCESSED);
        updateTaskPO.setAuditResult(aduit);
        updateTaskPO.setOwnOperId(reqBO.getOperId());
        updateTaskPO.setOwnOperName(reqBO.getUsername());
        try {
            this.uacOrdTaskMapper.updateById(updateTaskPO);
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u4fee\u6539\u73af\u8282\u5b9e\u4f8b\u5931\u8d25");
        }
        if (!stepInstance.getIsFinish().booleanValue()) {
            this.createTask(approvalOrderPO.getOrderId(), approvalOrderPO.getAuditOrderId(), stepInstance, reqBO);
        }
        return ordTaskPO;
    }

    private void createTask(Long orderId, Long auditOrderId, StepWithOutInstance instance, UacNoTaskAuditOrderAuditReqBO reqBO) {
        UacCreateTaskReqBO uacCreateTaskReqBO = new UacCreateTaskReqBO();
        uacCreateTaskReqBO.setInstance(instance);
        uacCreateTaskReqBO.setAuditOrderId(auditOrderId);
        uacCreateTaskReqBO.setOrderId(orderId);
        uacCreateTaskReqBO.setCandidates(reqBO.getCandidates());
        UacCreateTaskRspBO uacCreateTaskRspBO = this.uacCreateTaskAtomService.createTask(uacCreateTaskReqBO);
        if (!"0000".equals(uacCreateTaskRspBO.getRespCode())) {
            throw new BusinessException("6001", "\u521b\u5efa\u73af\u8282\u5b9e\u4f8b\u5931\u8d25");
        }
    }

    private void dealTempDate(ApprovalOrderPO approvalOrderPO, StepWithOutInstance stepInstance, ApprovalLogPO logPO, OrdTaskPO ordTaskPO) {
        ApprovalStepTempDataPO tempDataPO = new ApprovalStepTempDataPO();
        tempDataPO.setOrderId(approvalOrderPO.getOrderId());
        tempDataPO.setAuditOrderId(approvalOrderPO.getAuditOrderId());
        ApprovalStepTempDataPO dataPO = null;
        try {
            dataPO = this.approvalStepTempDateMapper.getModel(tempDataPO);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6b65\u9aa4\u5931\u8d25" + e);
        }
        if (dataPO != null) {
            logPO.setStepId(dataPO.getStepId());
            logPO.setStepName(dataPO.getStepName());
            logPO.setStepDesc(dataPO.getStepDesc());
            if (!stepInstance.getIsFinish().booleanValue()) {
                ApprovalStepTempDataPO update = new ApprovalStepTempDataPO();
                update.setAuditOrderId(dataPO.getAuditOrderId());
                update.setOrderId(dataPO.getOrderId());
                update.setStepId(stepInstance.getStepId());
                update.setStepName(stepInstance.getStepName());
                update.setStepDesc(stepInstance.getStepDesc());
                try {
                    this.approvalStepTempDateMapper.update(update);
                }
                catch (Exception e) {
                    LOGGER.debug(e.getMessage());
                    throw new BusinessException("6001", "\u4fee\u6539\u6b65\u9aa4\u5931\u8d25");
                }
            }
        } else {
            logPO.setStepId(ordTaskPO.getTacheCode());
            logPO.setStepName(ordTaskPO.getTaskName());
            logPO.setStepDesc(ordTaskPO.getTaskName());
        }
    }

    private ApprovalLogExtMapPO logExtMap(ApprovalLogPO logPO, String key, String val, Sequence sequence) {
        ApprovalLogExtMapPO extMapPO = new ApprovalLogExtMapPO();
        extMapPO.setId(sequence.nextId());
        extMapPO.setLogId(logPO.getId());
        extMapPO.setFieldCode(key);
        extMapPO.setFieldValue(val);
        return extMapPO;
    }

    private ApprovalOrderPO updateApproval(Long orderId, UacNoTaskAuditOrderAuditReqBO reqBO, StepWithOutInstance stepInstance, boolean flag) {
        ApprovalOrderPO approvalOrderPO = this.getApproval(orderId, reqBO, flag);
        approvalOrderPO.setPreOperId(approvalOrderPO.getUpdateOperId());
        approvalOrderPO.setPreOperName(approvalOrderPO.getOperName());
        approvalOrderPO.setOperName(reqBO.getUsername());
        approvalOrderPO.setUpdateOperId(reqBO.getOperId());
        approvalOrderPO.setUpdateTime(new Date());
        approvalOrderPO.setStepId(stepInstance.getStepId());
        if (stepInstance.getStepId() == null) {
            approvalOrderPO.setStepId("  ");
        }
        if (stepInstance.getIsFinish().booleanValue()) {
            approvalOrderPO.setFinishTime(new Date());
            if ("0".equals(reqBO.getAuditResult().toString())) {
                approvalOrderPO.setStatus(UacCommConstant.STATUS.REVIEW_COMPLETED);
            } else if ("1".equals(reqBO.getAuditResult().toString())) {
                approvalOrderPO.setStatus(UacCommConstant.STATUS.APPROVAL_REJECTION);
            }
            approvalOrderPO.setFinishTime(new Date());
        }
        approvalOrderPO.setOldStepId(reqBO.getStepId());
        int count = this.approvalOrderMapper.updateById(approvalOrderPO);
        if (count < 1) {
            throw new BusinessException("6001", "\u5ba1\u6279\u5355\u72b6\u6001\u5bf9\u5e94\u4e0d\u4e0a\uff0c\u9884\u8ba1\u662f\u5df2\u88ab\u5176\u4ed6\u4eba\u5904\u7406");
        }
        return approvalOrderPO;
    }

    private ApprovalOrderPO getApproval(Long orderId, UacNoTaskAuditOrderAuditReqBO reqBO, boolean flag) {
        ApprovalOrderPO approvalOrderPO;
        if (!flag) {
            ApprovalObjPO objBO = new ApprovalObjPO();
            objBO.setObjType(reqBO.getObjType());
            objBO.setObjId(String.valueOf(orderId));
            List<ApprovalOrderPO> getByObjId = this.approvalOrderMapper.getByObjId(objBO);
            if (CollectionUtils.isEmpty(getByObjId)) {
                throw new BusinessException("6001", "orderId\u4e3a\uff1a" + orderId + "\u7684\u8ba2\u5355\u5ba1\u6279\u5355\u4e0d\u5b58\u5728");
            }
            approvalOrderPO = getByObjId.get(0);
        } else {
            approvalOrderPO = new ApprovalOrderPO();
            approvalOrderPO.setOrderId(orderId);
            approvalOrderPO = this.approvalOrderMapper.getModelBy(approvalOrderPO);
            if (approvalOrderPO == null) {
                throw new BusinessException("6001", "orderId\u4e3a\uff1a" + orderId + "\u7684\u8ba2\u5355\u5ba1\u6279\u5355\u4e0d\u5b58\u5728");
            }
        }
        return approvalOrderPO;
    }

    private StepWithOutInstance proc(UacNoTaskAuditOrderAuditReqBO reqBO) {
        return this.taskService.newTaskCompleteBuilder().procDefId(reqBO.getProcDefId()).procDefKey(reqBO.getProcDefKey()).sysCode(reqBO.getSysCode()).stepId(reqBO.getStepId()).variables(reqBO.getVariables()).completeWithOutInstance();
    }

    private void val(UacNoTaskAuditOrderAuditReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8000", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderId()) && CollectionUtils.isEmpty((Collection)reqBO.getObjId())) {
            throw new BusinessException("8000", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getStepId() == null) {
            throw new BusinessException("8000", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5165\u53c2stepId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperId() == null) {
            throw new BusinessException("8000", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5165\u53c2operId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAuditResult() == null) {
            throw new BusinessException("8000", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5165\u53c2auditResult\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

