/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.busi.impl.task;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.uac.atom.bo.task.UacQryTaskInstReqBO;
import com.tydic.uac.atom.bo.task.UacQryTaskInstRspBO;
import com.tydic.uac.atom.task.UacQryTaskInstAtomService;
import com.tydic.uac.bo.task.TaskInstBO;
import com.tydic.uac.busi.bo.task.UacToErrorTaskReqBO;
import com.tydic.uac.busi.bo.task.UacToErrorTaskRspBO;
import com.tydic.uac.busi.task.UacToErrorTaskBusiService;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.task.UacOrdTaskCandidateMapper;
import com.tydic.uac.dao.task.UacOrdTaskMapper;
import com.tydic.uac.dao.task.UacOrdTaskRecordMapper;
import com.tydic.uac.dao.task.UacOrderMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.task.OrdTaskCandidatePO;
import com.tydic.uac.po.task.OrdTaskPO;
import com.tydic.uac.po.task.OrdTaskRecordPO;
import com.tydic.uac.po.task.OrderPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="uacToErrorTaskBusiService")
public class UacToErrorTaskBusiServiceImpl
implements UacToErrorTaskBusiService {
    private static final Logger logger = LoggerFactory.getLogger(UacToErrorTaskBusiServiceImpl.class);
    private UacQryTaskInstAtomService qryTaskInstAtomService;
    private UacOrdTaskMapper ordTaskMapper;
    private UacOrderMapper orderMapper;
    private UacOrdTaskCandidateMapper ordTaskCandidateMapper;
    private UacOrdTaskRecordMapper ordTaskRecordMapper;

    @Autowired
    public UacToErrorTaskBusiServiceImpl(UacQryTaskInstAtomService qryTaskInstAtomService, UacOrdTaskMapper ordTaskMapper, UacOrderMapper orderMapper, UacOrdTaskCandidateMapper ordTaskCandidateMapper, UacOrdTaskRecordMapper ordTaskRecordMapper) {
        this.qryTaskInstAtomService = qryTaskInstAtomService;
        this.ordTaskMapper = ordTaskMapper;
        this.orderMapper = orderMapper;
        this.ordTaskCandidateMapper = ordTaskCandidateMapper;
        this.ordTaskRecordMapper = ordTaskRecordMapper;
    }

    @Transactional
    public UacToErrorTaskRspBO dealCoreToErrorTask(UacToErrorTaskReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new BusinessException("8000", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = reqBO.getOrderId();
        UacToErrorTaskRspBO rspBO = new UacToErrorTaskRspBO();
        UacQryTaskInstReqBO qryTaskInstAtomReqBO = new UacQryTaskInstReqBO();
        qryTaskInstAtomReqBO.setOrderId(orderId);
        qryTaskInstAtomReqBO.setTacheCode(reqBO.getTacheCode());
        qryTaskInstAtomReqBO.setTaskId(reqBO.getTaskId());
        qryTaskInstAtomReqBO.setCurState(reqBO.getOrderState());
        UacQryTaskInstRspBO qryTaskInstAtomRspBO = this.qryTaskInstAtomService.qryTaskInst(qryTaskInstAtomReqBO);
        if ("0000".equals(qryTaskInstAtomRspBO.getRespCode())) {
            TaskInstBO taskInstBO = qryTaskInstAtomRspBO.getTaskInstBO();
            OrdTaskPO ordTaskPO = new OrdTaskPO();
            ordTaskPO.setOrderId(orderId);
            ordTaskPO.setTaskId(taskInstBO.getTaskId());
            ordTaskPO.setTaskProperty(UacCommConstant.TASK_PROPERTY.ERROR_TASK);
            try {
                this.ordTaskMapper.updateById(ordTaskPO);
                OrdTaskRecordPO ordTaskRecordPO = new OrdTaskRecordPO();
                Sequence sequence = Sequence.getInstance();
                ordTaskRecordPO.setId(sequence.nextId());
                ordTaskRecordPO.setOrderId(orderId);
                ordTaskRecordPO.setTaskId(taskInstBO.getTaskId());
                ordTaskRecordPO.setDealDesc(reqBO.getDealDesc());
                ordTaskRecordPO.setDealOperId(reqBO.getDealOper());
                ordTaskRecordPO.setDealCode("ERROR");
                this.ordTaskRecordMapper.insert(ordTaskRecordPO);
                OrderPO orderPO = this.orderMapper.getModelById(orderId);
                OrdTaskCandidatePO candidatePO = new OrdTaskCandidatePO();
                Sequence sequence1 = Sequence.getInstance();
                candidatePO.setId(sequence1.nextId());
                candidatePO.setOrderId(orderId);
                candidatePO.setOperId(orderPO.getCreateOperId());
                candidatePO.setTaskId(qryTaskInstAtomRspBO.getTaskInstBO().getTaskId());
                this.ordTaskCandidateMapper.insert(candidatePO);
            }
            catch (Exception e) {
                logger.error("\u4fee\u6539\u4efb\u52a1\u5c5e\u6027\u5f02\u5e38", (Throwable)e);
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u4fee\u6539\u4efb\u52a1\u5c5e\u6027\u5f02\u5e38");
                return rspBO;
            }
        } else {
            rspBO.setRespCode(qryTaskInstAtomRspBO.getRespCode());
            rspBO.setRespDesc(qryTaskInstAtomRspBO.getRespDesc());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fee\u6539\u4efb\u52a1\u5c5e\u6027\u6210\u529f");
        return rspBO;
    }
}

