/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ubc.impl.busi;

import com.tydic.ubc.api.base.bo.UbcBusinessException;
import com.tydic.ubc.api.busi.UbcQryProductRuleShowDetailBusiService;
import com.tydic.ubc.api.busi.bo.UbcQryProductRuleShowDetailBusiReqBO;
import com.tydic.ubc.api.busi.bo.UbcQryProductRuleShowDetailBusiRspBO;
import com.tydic.ubc.impl.dao.UbcProductRuleMapper;
import com.tydic.ubc.impl.dao.UbcProductRuleShowMapper;
import com.tydic.ubc.impl.dao.po.UbcProductRulePO;
import com.tydic.ubc.impl.dao.po.UbcProductRulePOExample;
import com.tydic.ubc.impl.dao.po.UbcProductRuleShowPO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UbcQryProductRuleShowDetailBusiServiceImpl
implements UbcQryProductRuleShowDetailBusiService {
    @Autowired
    private UbcProductRuleShowMapper ubcProductRuleShowMapper;
    @Autowired
    private UbcProductRuleMapper ubcProductRuleMapper;

    public UbcQryProductRuleShowDetailBusiRspBO qryProductRuleShowDetail(UbcQryProductRuleShowDetailBusiReqBO busiReqBO) {
        UbcQryProductRuleShowDetailBusiRspBO busiRspBO = new UbcQryProductRuleShowDetailBusiRspBO();
        Long productRuleId = busiReqBO.getProductRuleId();
        String productId = busiReqBO.getProductId();
        if (productRuleId == null) {
            UbcProductRulePOExample example = new UbcProductRulePOExample();
            example.or().andProductIdEqualTo(productId).andBillUnitStatusEqualTo(1);
            List<UbcProductRulePO> ubcProductRulePOS = this.ubcProductRuleMapper.selectByExample(example);
            if (ubcProductRulePOS.size() == 0) {
                throw new UbcBusinessException("24003", "\u8be5\u4ea7\u54c1\u8ba1\u8d39\u89c4\u5219\u4e0d\u5b58\u5728");
            }
            productRuleId = ubcProductRulePOS.get(0).getProductRuleId();
        } else {
            UbcProductRulePO productRulePO = this.ubcProductRuleMapper.selectByPrimaryKey(productRuleId);
            if (productRulePO == null) {
                throw new UbcBusinessException("24003", "\u8be5\u4ea7\u54c1\u8ba1\u8d39\u89c4\u5219\u4e0d\u5b58\u5728");
            }
            if (productRulePO.getBillUnitStatus() == null || productRulePO.getBillUnitStatus() == 0) {
                throw new UbcBusinessException("24009", "\u8be5\u4ea7\u54c1\u8ba1\u8d39\u89c4\u5219\u5df2\u5931\u6548");
            }
        }
        List<UbcProductRuleShowPO> poList = this.ubcProductRuleShowMapper.selectByProductRuleId(productRuleId);
        Map poListMap = poList.stream().sorted(new Comparator<UbcProductRuleShowPO>(){

            @Override
            public int compare(UbcProductRuleShowPO o1, UbcProductRuleShowPO o2) {
                return o1.getRolIndex() - o2.getRolIndex();
            }
        }).collect(Collectors.groupingBy(UbcProductRuleShowPO::getRowIndex, Collectors.mapping(UbcProductRuleShowPO::getRowValue, Collectors.toList())));
        ArrayList result = new ArrayList(poListMap.values());
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        busiRspBO.setProductRuleShowInfo(result);
        return busiRspBO;
    }
}

