/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ubc.impl.busi;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.ubc.api.busi.UbcQryProductRuleShowDetailBusiService;
import com.tydic.ubc.api.busi.bo.UbcQryProductRuleShowDetailBusiReqBO;
import com.tydic.ubc.api.busi.bo.UbcQryProductRuleShowDetailBusiRspBO;
import com.tydic.ubc.api.common.bo.UbcColumnInfoBO;
import com.tydic.ubc.impl.dao.UbcBillRuleAttrMapper;
import com.tydic.ubc.impl.dao.UbcBillRuleMapper;
import com.tydic.ubc.impl.dao.UbcProductRuleAttrMapper;
import com.tydic.ubc.impl.dao.UbcProductRuleMapper;
import com.tydic.ubc.impl.dao.po.UbcBillRuleAttrPO;
import com.tydic.ubc.impl.dao.po.UbcBillRulePO;
import com.tydic.ubc.impl.dao.po.UbcProductRuleAttrPO;
import com.tydic.ubc.impl.dao.po.UbcProductRuleAttrPOExample;
import com.tydic.ubc.impl.dao.po.UbcProductRulePO;
import com.tydic.ubc.impl.dao.po.UbcProductRulePOExample;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="service", serviceInterface=UbcQryProductRuleShowDetailBusiService.class)
public class UbcQryProductRuleShowDetailBusiServiceImpl
implements UbcQryProductRuleShowDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(UbcQryProductRuleShowDetailBusiServiceImpl.class);
    @Autowired
    private UbcProductRuleMapper ubcProductRuleMapper;
    @Autowired
    private UbcProductRuleAttrMapper ubcProductRuleAttrMapper;
    @Autowired
    private UbcBillRuleMapper ubcBillRuleMapper;
    @Autowired
    private UbcBillRuleAttrMapper ubcBillRuleAttrMapper;

    public UbcQryProductRuleShowDetailBusiRspBO qryProductRuleShowDetail(UbcQryProductRuleShowDetailBusiReqBO reqBO) {
        UbcQryProductRuleShowDetailBusiRspBO rspBO = new UbcQryProductRuleShowDetailBusiRspBO();
        String productId = reqBO.getProductId();
        UbcProductRulePOExample example = new UbcProductRulePOExample();
        example.or().andProductIdEqualTo(productId).andBillUnitStatusEqualTo(1);
        List<UbcProductRulePO> productRulePOS = this.ubcProductRuleMapper.selectByExample(example);
        if (productRulePOS.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        UbcProductRulePO productRulePO = productRulePOS.get(0);
        Long productRuleId = productRulePO.getProductRuleId();
        UbcProductRuleAttrPOExample productRuleAttrPOExample = new UbcProductRuleAttrPOExample();
        productRuleAttrPOExample.or().andProductRuleIdEqualTo(productRuleId);
        List<UbcProductRuleAttrPO> productRuleAttrPOS = this.ubcProductRuleAttrMapper.selectByExample(productRuleAttrPOExample);
        if (productRuleAttrPOS.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        String billRuleCode = productRulePO.getBillRuleCode();
        UbcBillRulePO billRulePO = this.ubcBillRuleMapper.selectByPrimaryKey(billRuleCode);
        if (billRulePO == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List<UbcBillRuleAttrPO> billRuleAttrPOS = this.ubcBillRuleAttrMapper.selectByPrimaryKey(billRuleCode);
        if (billRuleAttrPOS.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList columns = new ArrayList(10);
        billRuleAttrPOS.forEach(billRuleAttrPO -> {
            UbcColumnInfoBO columnInfoBO = new UbcColumnInfoBO();
            columnInfoBO.setTitle(billRuleAttrPO.getAttrName());
            columnInfoBO.setKey(billRuleAttrPO.getAttrCode());
            columns.add(columnInfoBO);
        });
        ArrayList data = new ArrayList(10);
        Map<String, List<UbcProductRuleAttrPO>> productRuleAttrPOMap = productRuleAttrPOS.stream().sorted(new Comparator<UbcProductRuleAttrPO>(){

            @Override
            public int compare(UbcProductRuleAttrPO o1, UbcProductRuleAttrPO o2) {
                return o1.compareTo(o2);
            }
        }).collect(Collectors.groupingBy(UbcProductRuleAttrPO::getProductRuleAttrGroupCode));
        productRuleAttrPOMap.forEach((k, v) -> {
            HashMap item = new HashMap(8);
            v.forEach(productRuleAttrPO -> item.put(productRuleAttrPO.getProductRuleAttrCode(), this.generateRuleDesc(productRuleAttrPO.getProductRuleAttrCode(), productRuleAttrPO.getProductRuleAttrValue())));
            data.add(item);
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setBillMod(billRulePO.getBillMod());
        rspBO.setColumns(columns);
        rspBO.setData(data);
        log.info("rspBO=" + rspBO.toString());
        return rspBO;
    }

    private String generateRuleDesc(String attrCode, String attrValue) {
        String result;
        switch (attrCode) {
            case "ladder": {
                if (StringUtils.isEmpty((Object)attrValue)) {
                    result = "\u65e0\u8981\u6c42";
                    break;
                }
                result = "\u6708\u8c03\u7528\u6210\u529f\u6b21\u6570 > " + attrValue + "\u6b21";
                break;
            }
            case "price": {
                result = attrValue + "\u5143/\u6b21";
                break;
            }
            case "discount": {
                result = attrValue + "\u6298";
                break;
            }
            default: {
                result = attrValue;
            }
        }
        return result;
    }
}

