/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ubc.impl.busi;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.ubc.api.ability.bo.UbcNlptLogBO;
import com.tydic.ubc.api.base.bo.UbcRspBaseBO;
import com.tydic.ubc.api.busi.UbcQryUserBillListBusiService;
import com.tydic.ubc.api.busi.bo.UbcQryUserBillListBusiReqBO;
import com.tydic.ubc.api.busi.bo.UbcQryUserBillListBusiRspBO;
import com.tydic.ubc.api.common.bo.UbcUserBillBO;
import com.tydic.ubc.impl.dao.UbcProductRuleAttrMapper;
import com.tydic.ubc.impl.dao.UbcProductRuleMapper;
import com.tydic.ubc.impl.dao.UbcUserBillMapper;
import com.tydic.ubc.impl.dao.po.UbcProductRuleAttrPO;
import com.tydic.ubc.impl.dao.po.UbcProductRuleAttrPOExample;
import com.tydic.ubc.impl.dao.po.UbcProductRulePO;
import com.tydic.ubc.impl.dao.po.UbcUserBillPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UbcQryUserBillListBusiServiceImpl
implements UbcQryUserBillListBusiService {
    private Sequence ucsUccCapacitySequence = Sequence.getInstance();
    @Autowired
    private UbcUserBillMapper ubcUserBillMapper;
    @Autowired
    private UbcProductRuleMapper ubcProductRuleMapper;
    @Autowired
    private UbcProductRuleAttrMapper ubcProductRuleAttrMapper;

    public UbcQryUserBillListBusiRspBO qryUserBillList(UbcQryUserBillListBusiReqBO busiReqBO) {
        UbcUserBillPO ubcUserBillPO = new UbcUserBillPO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)ubcUserBillPO);
        Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
        List<UbcUserBillBO> rows = this.ubcUserBillMapper.selectByPage((Page<UbcUserBillBO>)page, ubcUserBillPO);
        UbcQryUserBillListBusiRspBO busiRspBO = new UbcQryUserBillListBusiRspBO();
        busiRspBO.setPageNo(busiReqBO.getPageNo());
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    public UbcRspBaseBO insertDate(List<UbcNlptLogBO> ubcNlptLogBOs) throws Exception {
        UbcRspBaseBO busiRspBO = new UbcRspBaseBO();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMM");
        HashMap<String, Long> mapList = new HashMap<String, Long>();
        for (UbcNlptLogBO ubcNlptLogBO2 : ubcNlptLogBOs) {
            String userId = ubcNlptLogBO2.getUseId();
            String abilityName = ubcNlptLogBO2.getAbilityName();
            String version = ubcNlptLogBO2.getAbilityVersion();
            Date dealDate = simpleDateFormat.parse(ubcNlptLogBO2.getDealTime());
            String accountPeriod = sdf2.format(dealDate);
            Long cumulativeUsage = 0L;
            if (mapList.containsKey(userId + "-" + abilityName + "-" + version + "-" + accountPeriod)) continue;
            for (UbcNlptLogBO ubcNlptLogBO : ubcNlptLogBOs) {
                Date dealDate2 = simpleDateFormat.parse(ubcNlptLogBO.getDealTime());
                String accountPeriod2 = sdf2.format(dealDate2);
                if (!userId.equals(ubcNlptLogBO.getUseId()) || !abilityName.equals(ubcNlptLogBO.getAbilityName()) || !version.equals(ubcNlptLogBO.getAbilityVersion()) || !accountPeriod.equals(accountPeriod2)) continue;
                cumulativeUsage = cumulativeUsage + ubcNlptLogBO.getSuccessCount();
            }
            mapList.put(userId + "-" + abilityName + "-" + version + "-" + accountPeriod, cumulativeUsage);
            UbcUserBillPO record = new UbcUserBillPO();
            record.setAbilityName(abilityName);
            record.setAbilityVersion(version);
            record.setUserId(userId);
            record.setAccountPeriod(accountPeriod);
            List<UbcUserBillPO> result = this.ubcUserBillMapper.selectByContent(record);
            if (result == null || result.size() == 0) {
                record.setBillId(this.ucsUccCapacitySequence.nextId());
                record.setAccumulatedSettlementFee("0");
                record.setAccumulatedSstandardFee("0");
                record.setCumulativeDiscount("0");
                this.ubcUserBillMapper.insertSelective(record);
                continue;
            }
            cumulativeUsage = cumulativeUsage + result.get(0).getCumulativeUsage();
            result.get(0).setCumulativeUsage(cumulativeUsage);
            this.ubcUserBillMapper.updateByPrimaryKeySelective(result.get(0));
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    public UbcRspBaseBO account(UbcNlptLogBO ubcNlptLogBO) {
        UbcRspBaseBO busiRspBO = new UbcRspBaseBO();
        UbcUserBillPO record = new UbcUserBillPO();
        BeanUtils.copyProperties((Object)ubcNlptLogBO, (Object)record);
        List<UbcUserBillPO> result = this.ubcUserBillMapper.selectByContent(record);
        for (UbcUserBillPO ubcUserBillPO : result) {
            String productId = ubcUserBillPO.getProductId();
            String userId = ubcUserBillPO.getUserId();
            Long cumulativeUsage = ubcUserBillPO.getCumulativeUsage();
            Object list = null;
            Long productRuleId = 468785216607510528L;
            UbcProductRulePO ubcProductRulePO = this.ubcProductRuleMapper.selectByPrimaryKey(productRuleId);
            if ("8".equals(ubcProductRulePO.getBillRuleCode())) {
                UbcProductRuleAttrPOExample example = new UbcProductRuleAttrPOExample();
                example.or().andProductRuleIdEqualTo(ubcProductRulePO.getProductRuleId());
                example.setOrderByClause("product_rule_attr_code,product_rule_attr_value");
                List<UbcProductRuleAttrPO> ubcProductRuleAttrPOS = this.ubcProductRuleAttrMapper.selectByExample(example);
                HashMap map = new HashMap();
                String flag = "";
                for (UbcProductRuleAttrPO ubcProductRuleAttrPO : ubcProductRuleAttrPOS) {
                    String productRuleAttrProupCode = ubcProductRuleAttrPO.getProductRuleAttrGroupCode();
                    if (map.containsKey(productRuleAttrProupCode)) continue;
                    ArrayList<UbcProductRuleAttrPO> UbcProductRuleAttrPOList = new ArrayList<UbcProductRuleAttrPO>();
                    for (UbcProductRuleAttrPO ubcProductRuleAttrPO2 : ubcProductRuleAttrPOS) {
                        if (!productRuleAttrProupCode.equals(ubcProductRuleAttrPO2.getProductRuleAttrGroupCode())) continue;
                        if ("ladder".equals(ubcProductRuleAttrPO2.getProductRuleAttrCode())) {
                            Long ladder = Long.parseLong(ubcProductRuleAttrPO2.getProductRuleAttrValue());
                            if (cumulativeUsage <= ladder) {
                                flag = ubcProductRuleAttrPO2.getProductRuleAttrGroupCode();
                            }
                        }
                        UbcProductRuleAttrPOList.add(ubcProductRuleAttrPO2);
                    }
                    map.put(productRuleAttrProupCode, UbcProductRuleAttrPOList);
                }
                List list2 = (List)map.get(flag);
                Double price = 0.0;
                Double discount = 0.0;
                Long ladder = 0L;
                for (UbcProductRuleAttrPO ubcProductRuleAttrPO : list2) {
                    if ("price".equals(ubcProductRuleAttrPO.getProductRuleAttrCode())) {
                        price = Double.parseDouble(ubcProductRuleAttrPO.getProductRuleAttrValue());
                    }
                    if ("discount".equals(ubcProductRuleAttrPO.getProductRuleAttrCode())) {
                        discount = Double.parseDouble(ubcProductRuleAttrPO.getProductRuleAttrValue()) * 0.1;
                    }
                    if (!"ladder".equals(ubcProductRuleAttrPO.getProductRuleAttrCode())) continue;
                    ladder = Long.parseLong(ubcProductRuleAttrPO.getProductRuleAttrValue());
                }
                Double accumulatedSstandardFee = (double)cumulativeUsage.longValue() * price;
                Double cumulativeDiscount = (double)cumulativeUsage.longValue() * price * discount;
                Double accumulatedSettlementFee = accumulatedSstandardFee - cumulativeDiscount;
                ubcUserBillPO.setAccumulatedSstandardFee(String.format("%.4f", accumulatedSstandardFee));
                ubcUserBillPO.setAccumulatedSettlementFee(String.format("%.4f", accumulatedSettlementFee));
                ubcUserBillPO.setCumulativeDiscount(String.format("%.4f", cumulativeDiscount));
            }
            if ("7".equals(ubcProductRulePO.getBillRuleCode())) {
                Double accumulatedSstandardFee = 0.0;
                Double accumulatedSettlementFee = 0.0;
                Double cumulativeDiscount = 0.0;
                ubcUserBillPO.setAccumulatedSstandardFee(String.format("%.4f", accumulatedSstandardFee));
                ubcUserBillPO.setAccumulatedSettlementFee(String.format("%.4f", accumulatedSettlementFee));
                ubcUserBillPO.setCumulativeDiscount(String.format("%.4f", cumulativeDiscount));
            }
            this.ubcUserBillMapper.updateByPrimaryKeySelective(ubcUserBillPO);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }
}

