/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ubc.impl.util;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;

public class BeanCopyUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanCopyUtil.class);

    private BeanCopyUtil() {
    }

    public static <E, T> List<T> copyList(List<E> elements, Class<T> cls) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (elements == null || elements.isEmpty()) {
            return resultList;
        }
        BeanCopier copier = BeanCopier.create(elements.get(0).getClass(), cls, (boolean)false);
        for (E element : elements) {
            Object obj = null;
            try {
                obj = cls.newInstance();
                copier.copy(element, obj, null);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            resultList.add(obj);
        }
        return resultList;
    }

    public static <E, T> T copyObject(E element, Class<T> cls) {
        if (element == null) {
            return null;
        }
        BeanCopier copier = BeanCopier.create(element.getClass(), cls, (boolean)false);
        try {
            T obj = cls.newInstance();
            copier.copy(element, obj, null);
            return obj;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

