/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.ability.api.SearchCommodityManageAbilityService;
import com.tydic.commodity.bo.ability.SearchCommodityManageAbilityReqBo;
import com.tydic.commodity.bo.ability.SearchCommodityManageAbilityRspBo;
import com.tydic.commodity.bo.ability.SearchCommodityManageBo;
import com.tydic.commodity.bo.ability.UccSourceTypeBo;
import com.tydic.commodity.dao.ApprovalLevelMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.po.ApprovalLevelPO;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPutCirPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.SkuSourceEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.util.DateUtils;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.uccext.bo.CnncElcSkuListQueryAbilityReqBo;
import com.tydic.uccext.bo.CnncElcSkuListQueryAbilityRspBo;
import com.tydic.uccext.bo.CnncUccQryCommodityForEclBO;
import com.tydic.uccext.constant.FuzzyFieldsEnum;
import com.tydic.uccext.service.CnncElcSkuListQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.CnncElcSkuListQueryAbilityService"})
public class CnncElcSkuListQueryAbilityServiceImpl
implements CnncElcSkuListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CnncElcSkuListQueryAbilityServiceImpl.class);
    @Autowired
    private SearchCommodityManageAbilityService searchCommodityManageAbilityService;
    @Autowired
    private ApprovalLevelMapper approvalLevelMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UacQryAuditLogAbilityService uocAuditQryLogAbilityService;

    @PostMapping(value={"getList"})
    public CnncElcSkuListQueryAbilityRspBo getList(@RequestBody CnncElcSkuListQueryAbilityReqBo reqBo) {
        CnncElcSkuListQueryAbilityRspBo rspBo = new CnncElcSkuListQueryAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setRows(new ArrayList());
        SearchCommodityManageAbilityReqBo searchCommodityManageAbilityReqBo = new SearchCommodityManageAbilityReqBo();
        if (reqBo.getSkuId() != null) {
            if (reqBo.getSkuIds() != null) {
                reqBo.getSkuIds().add(reqBo.getSkuId());
            } else {
                reqBo.setSkuIds((List)Lists.newArrayList((Object[])new Long[]{reqBo.getSkuId()}));
            }
        }
        List<Object> commodityTypeIds = new ArrayList();
        if (reqBo.getApprovalLevel() != null) {
            ApprovalLevelPO approvalLevelPO = new ApprovalLevelPO();
            approvalLevelPO.setApprovalLevel(reqBo.getApprovalLevel());
            List approvalLevelPOS = this.approvalLevelMapper.queryAuditLevelListPage(approvalLevelPO, new Page(-1, 10000));
            if (!CollectionUtils.isEmpty((Collection)approvalLevelPOS)) {
                List catalogIds = approvalLevelPOS.stream().map(ApprovalLevelPO::getCatalogId).collect(Collectors.toList());
                if (reqBo.getGuideCatalogId() != null && !catalogIds.contains(reqBo.getGuideCatalogId())) {
                    return rspBo;
                }
                commodityTypeIds = approvalLevelPOS.stream().map(ApprovalLevelPO::getCommodityTypeId).collect(Collectors.toList());
            } else {
                return rspBo;
            }
        }
        searchCommodityManageAbilityReqBo.setFuzzyFields(FuzzyFieldsEnum.getAllField());
        searchCommodityManageAbilityReqBo.setSkuList(reqBo.getSkuIds());
        searchCommodityManageAbilityReqBo.setExtSkuId(reqBo.getExtSkuId());
        searchCommodityManageAbilityReqBo.setSkuName(reqBo.getCommodityName());
        searchCommodityManageAbilityReqBo.setMaterialCatalogId(reqBo.getGuideCatalogId());
        searchCommodityManageAbilityReqBo.setBrandName(reqBo.getBrandName());
        searchCommodityManageAbilityReqBo.setSupplierShopId(reqBo.getSupplierShopId());
        searchCommodityManageAbilityReqBo.setMinMarketPrice(reqBo.getMinMarketPrice());
        searchCommodityManageAbilityReqBo.setMaxMarketPrice(reqBo.getMaxMarketPrice());
        searchCommodityManageAbilityReqBo.setMinDiscounts(reqBo.getMinDiscountRate());
        searchCommodityManageAbilityReqBo.setMaxDiscounts(reqBo.getMaxDiscountRate());
        ArrayList uccSourceTypeBos = new ArrayList();
        UccSourceTypeBo uccSourceTypeBo = new UccSourceTypeBo();
        uccSourceTypeBo.setSkuSource(SkuSourceEnum.ELECTRONIC_SUPERMARKET_SOURCE.getSource());
        uccSourceTypeBo.setType(commodityTypeIds);
        searchCommodityManageAbilityReqBo.setSearchTypeList(uccSourceTypeBos);
        if (reqBo.getCommodityStatus() != null) {
            searchCommodityManageAbilityReqBo.setSkuStatus((List)Lists.newArrayList((Object[])new Integer[]{reqBo.getCommodityStatus()}));
        }
        searchCommodityManageAbilityReqBo.setSkuSource(SkuSourceEnum.ELECTRONIC_SUPERMARKET_SOURCE.getSource());
        ArrayList<CnncUccQryCommodityForEclBO> cnncUccQryCommodityForEclBOS = new ArrayList<CnncUccQryCommodityForEclBO>();
        try {
            SearchCommodityManageAbilityRspBo searchCommodityManageAbilityRspBo = this.searchCommodityManageAbilityService.searchCommodity(searchCommodityManageAbilityReqBo);
            if ("0000".equals(searchCommodityManageAbilityRspBo.getRespCode())) {
                rspBo.setPageNo(reqBo.getPageNo());
                rspBo.setRecordsTotal(searchCommodityManageAbilityRspBo.getRecordsTotal());
                rspBo.setTotal(searchCommodityManageAbilityRspBo.getTotal());
                List searchCommodityManageBos = searchCommodityManageAbilityRspBo.getResult();
                if (!CollectionUtils.isEmpty((Collection)searchCommodityManageBos)) {
                    for (SearchCommodityManageBo searchCommodityManageBo : searchCommodityManageBos) {
                        CnncUccQryCommodityForEclBO cnncUccQryCommodityForEclBO = new CnncUccQryCommodityForEclBO();
                        BeanUtils.copyProperties((Object)searchCommodityManageBo, (Object)cnncUccQryCommodityForEclBO);
                        cnncUccQryCommodityForEclBO.setAgreementPrice(searchCommodityManageBo.getAgreementPrice());
                        cnncUccQryCommodityForEclBO.setCommodityStatus(searchCommodityManageBo.getSkuStatus());
                        if (searchCommodityManageBo.getSkuStatus() != null) {
                            cnncUccQryCommodityForEclBO.setCommodityStatusDesc(SkuStatusEnum.getStatusDesc((Integer)searchCommodityManageBo.getSkuStatus()).getStatusDesc());
                        }
                        cnncUccQryCommodityForEclBO.setCommodityTypeId(searchCommodityManageBo.getCommodityTypeId());
                        if (!StringUtils.isEmpty((Object)searchCommodityManageBo.getDiscountRate())) {
                            cnncUccQryCommodityForEclBO.setDiscountRate(new BigDecimal(searchCommodityManageBo.getDiscountRate()).multiply(new BigDecimal(100)).toString());
                        }
                        cnncUccQryCommodityForEclBO.setExtSkuId(searchCommodityManageBo.getExtSkuId());
                        cnncUccQryCommodityForEclBO.setCommodityName(searchCommodityManageBo.getSkuName());
                        cnncUccQryCommodityForEclBO.setSupplierSource(searchCommodityManageBo.getSupplierName());
                        cnncUccQryCommodityForEclBO.setMarketPrice(searchCommodityManageBo.getMartketPrice());
                        cnncUccQryCommodityForEclBO.setGuideCatalogId(searchCommodityManageBo.getMaterialCatalogId());
                        cnncUccQryCommodityForEclBO.setClassificationStr(searchCommodityManageBo.getMaterialCatalogName());
                        cnncUccQryCommodityForEclBOS.add(cnncUccQryCommodityForEclBO);
                    }
                }
            } else {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc(searchCommodityManageAbilityRspBo.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2\u5931\u8d25");
        }
        this.getInfo(cnncUccQryCommodityForEclBOS, reqBo);
        rspBo.setRows(cnncUccQryCommodityForEclBOS);
        return rspBo;
    }

    private void getInfo(List<CnncUccQryCommodityForEclBO> bos, CnncElcSkuListQueryAbilityReqBo reqBo) {
        if (!CollectionUtils.isEmpty(bos)) {
            List uccSkuPos;
            List skuIds = bos.stream().map(CnncUccQryCommodityForEclBO::getSkuId).collect(Collectors.toList());
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setState(Integer.valueOf(1));
            List uccSkuPutCirPos = this.uccSkuPutCirMapper.batchQryById(skuIds, uccSkuPutCirPo);
            if (!CollectionUtils.isEmpty((Collection)uccSkuPutCirPos)) {
                for (CnncUccQryCommodityForEclBO cnncUccQryCommodityForEclBO : bos) {
                    for (UccSkuPutCirPo uccSkuPutCirPo1 : uccSkuPutCirPos) {
                        if (!uccSkuPutCirPo1.getSkuId().equals(cnncUccQryCommodityForEclBO.getSkuId())) continue;
                        if (cnncUccQryCommodityForEclBO.getCommodityStatus() == 3) {
                            cnncUccQryCommodityForEclBO.setUpShelfTime(DateUtils.dateToStr((Date)uccSkuPutCirPo1.getRealUpTime()));
                            continue;
                        }
                        if (cnncUccQryCommodityForEclBO.getCommodityStatus() != 5) continue;
                        cnncUccQryCommodityForEclBO.setDownShelfTime(DateUtils.dateToStr((Date)uccSkuPutCirPo1.getRealDownTime()));
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.batchQrySku(skuIds, null)))) {
                for (CnncUccQryCommodityForEclBO cnncUccQryCommodityForEclBO : bos) {
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (!uccSkuPo.getSkuId().equals(cnncUccQryCommodityForEclBO.getSkuId())) continue;
                        cnncUccQryCommodityForEclBO.setPublicTime(DateUtils.dateToStr((Date)uccSkuPo.getCreateTime()));
                    }
                }
            }
        }
        if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(reqBo.getCommodityStatus()) || SkuStatusEnum.ON_SHELVES_STATUS.getStatus().equals(reqBo.getCommodityStatus())) {
            for (CnncUccQryCommodityForEclBO cnncUccQryCommodityForEclBO : bos) {
                UacQryAuditLogReqBO uocAuditQryLogAbilityReqBO = new UacQryAuditLogReqBO();
                uocAuditQryLogAbilityReqBO.setObjType(Integer.valueOf(2));
                uocAuditQryLogAbilityReqBO.setObjId(String.valueOf(cnncUccQryCommodityForEclBO.getCommodityId()));
                uocAuditQryLogAbilityReqBO.setStepName(ApprovalTypeEnum.APPROVAL_DOWN_SHELF.code());
                UacQryAuditLogRspBO uocAuditQryLogAbilityRspBO = this.uocAuditQryLogAbilityService.qryLog(uocAuditQryLogAbilityReqBO);
                List list = uocAuditQryLogAbilityRspBO.getRows();
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                cnncUccQryCommodityForEclBO.setRejectReason(((ApprovalLogBO)list.get(0)).getAuditAdvice());
                cnncUccQryCommodityForEclBO.setDealTime(((ApprovalLogBO)list.get(0)).getDealTime());
                cnncUccQryCommodityForEclBO.setOperName(((ApprovalLogBO)list.get(0)).getOperName());
            }
        }
    }
}

