/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.bo.UmcStationWebBO;
import com.tydic.commodity.bo.ability.CommodityPackBO;
import com.tydic.commodity.bo.ability.CommodityRecordBO;
import com.tydic.commodity.bo.ability.LadderPriceBo;
import com.tydic.commodity.bo.ability.UccAgrGoodListQueryAbilityReqBO;
import com.tydic.commodity.bo.ability.UccAgrGoodListQueryAbilityRspBO;
import com.tydic.commodity.bo.busi.CommodityPicBo;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.CommodityRecordPO;
import com.tydic.commodity.dao.po.CommodityRecordVO;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.enumType.YesNoEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.uccext.dao.UccExamineEditInfoMapper;
import com.tydic.uccext.service.UccAgrGoodListQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccAgrGoodListQueryAbilityService"})
public class UccAgrGoodListQueryAbilityServiceImpl
implements UccAgrGoodListQueryAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private UccExamineEditInfoMapper uccExamineEditInfoMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    private static final String DateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAgrGoodListQueryAbilityServiceImpl.class);

    @PostMapping(value={"getUccAgrGoodListQuery"})
    public UccAgrGoodListQueryAbilityRspBO getUccAgrGoodListQuery(@RequestBody UccAgrGoodListQueryAbilityReqBO reqBO) {
        List<Object> commodityRecordPOS;
        Page page;
        UccAgrGoodListQueryAbilityRspBO rspBO;
        block44: {
            rspBO = new UccAgrGoodListQueryAbilityRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            if (!StringUtils.isEmpty((Object)reqBO.getSkuCode())) {
                reqBO.setSkuId(Long.valueOf(Long.parseLong(reqBO.getSkuCode())));
            }
            page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            CommodityRecordVO commodityRecordVO = this.dealReq(reqBO);
            if (null == commodityRecordVO) {
                rspBO.setRows(new ArrayList());
                rspBO.setPageNo(reqBO.getPageNo());
                rspBO.setTotal(0);
                rspBO.setRecordsTotal(0);
                return rspBO;
            }
            commodityRecordPOS = new ArrayList();
            if (!StringUtils.isEmpty((Object)reqBO.getUccOperCode())) {
                if ("uadCode".equals(reqBO.getUccOperCode())) {
                    commodityRecordVO.setExtField1((List)Lists.newArrayList((Object[])new String[]{"upCode", "downCode"}));
                } else {
                    commodityRecordVO.setExtField1((List)Lists.newArrayList((Object[])new String[]{reqBO.getUccOperCode()}));
                }
            }
            try {
                if (reqBO.getType() == 0) {
                    commodityRecordPOS = this.uccSkuMapper.qryBaseCommdList(page, commodityRecordVO);
                    break block44;
                }
                if (reqBO.getType() == 1) {
                    commodityRecordVO.setUpDownType(reqBO.getUpDownType());
                    if (reqBO.getUpDownType() != null && reqBO.getUpDownType() == 1) {
                        commodityRecordVO.setPutCirRemark("\u6062\u590d\u4e0a\u67b6");
                    }
                    commodityRecordPOS = this.uccSkuMapper.qryCommdUpDownRecordList(page, commodityRecordVO);
                    break block44;
                }
                if (reqBO.getType() == 2) {
                    commodityRecordPOS = this.uccExamineEditInfoMapper.selectRecordPO(page, commodityRecordVO);
                    break block44;
                }
                if (reqBO.getType() == 3) {
                    Collection umcStationWebBOS = null;
                    if (CollectionUtils.isNotEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
                        try {
                            umcStationWebBOS = JSONObject.parseArray((String)JSON.toJSONString((Object)reqBO.getUmcStationsListWebExt()), UmcStationWebBO.class);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (CollectionUtils.isNotEmpty(umcStationWebBOS)) {
                        List stationIds = umcStationWebBOS.stream().map(UmcStationWebBO::getStationId).collect(Collectors.toList());
                        commodityRecordVO.setOperIds(stationIds);
                    }
                    commodityRecordVO.setAuditType(reqBO.getAuditType());
                    if (ApprovalTypeEnum.APPROVAL_EDIT.getStep().equals(reqBO.getAuditType().toString())) {
                        commodityRecordPOS = this.uccExamineEditInfoMapper.qryEditAuditCommdList(page, commodityRecordVO);
                        if (CollectionUtils.isNotEmpty(commodityRecordPOS)) {
                            for (CommodityRecordPO commodityRecordPO : commodityRecordPOS) {
                                List commodityPicBos;
                                String skuPic = commodityRecordPO.getSkuPicUrl();
                                if (StringUtils.isEmpty((Object)skuPic) || !CollectionUtils.isNotEmpty((Collection)(commodityPicBos = JSONObject.parseArray((String)skuPic, CommodityPicBo.class)))) continue;
                                for (CommodityPicBo commodityPicBo : commodityPicBos) {
                                    if (commodityPicBo.getCommodityPicType() != 1) continue;
                                    commodityRecordPO.setSkuPicUrl(commodityPicBo.getCommodityPicUrl());
                                }
                            }
                        }
                    } else {
                        commodityRecordPOS = this.uccSkuMapper.qryAuditList(page, commodityRecordVO);
                    }
                    break block44;
                }
                if (reqBO.getType() == 4) {
                    commodityRecordPOS = this.uccSkuMapper.qryOtherCommdList(page, commodityRecordVO);
                    break block44;
                }
                if (reqBO.getType() == 5) {
                    commodityRecordPOS = this.uccSkuMapper.qryNoPicCommdList(page, commodityRecordVO);
                    break block44;
                }
                throw new BusinessException("8888", "\u6ca1\u6709\u8be5\u67e5\u8be2\u7c7b\u578b");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25");
            }
        }
        if (CollectionUtils.isEmpty(commodityRecordPOS)) {
            return rspBO;
        }
        ArrayList<CommodityRecordBO> commodityRecordBOS = new ArrayList<CommodityRecordBO>();
        List skuIds = commodityRecordPOS.stream().map(CommodityRecordPO::getSkuId).collect(Collectors.toList());
        List list = this.uccLadderPriceMapper.selectBySkuIds(skuIds);
        List commodityTypeIds = commodityRecordPOS.stream().map(CommodityRecordPO::getCommodityTypeId).collect(Collectors.toList());
        List uccCommodityTypePos = this.uccCommodityTypeMapper.queryPoByCommodityTypeIds(commodityTypeIds);
        for (CommodityRecordPO commodityRecordPO : commodityRecordPOS) {
            CommodityRecordBO commodityRecordBO = new CommodityRecordBO();
            commodityRecordBOS.add(commodityRecordBO);
            commodityRecordBO.setSalesUnitName(commodityRecordPO.getSalesUnitName());
            commodityRecordBO.setSalesUnitRate(commodityRecordPO.getSalesUnitRate());
            commodityRecordBO.setPackageSpec(commodityRecordPO.getPackageSpec());
            commodityRecordBO.setSettlementUnit(commodityRecordPO.getSettlementUnit());
            commodityRecordBO.setUpdateTime(commodityRecordPO.getUpdateTime());
            commodityRecordBO.setSkuId(commodityRecordPO.getSkuId());
            commodityRecordBO.setSkuCode(commodityRecordPO.getSkuCode());
            commodityRecordBO.setSkuStatus(commodityRecordPO.getSkuStatus());
            if (commodityRecordPO.getSkuStatus() != null) {
                commodityRecordBO.setSkuStatusDesc(SkuStatusEnum.getStatusDesc((Integer)commodityRecordPO.getSkuStatus()).getStatusDesc());
            }
            commodityRecordBO.setCatalogName(commodityRecordPO.getCatalogName());
            commodityRecordBO.setSkuPicUrl(commodityRecordPO.getSkuPicUrl());
            commodityRecordBO.setSkuName(commodityRecordPO.getSkuName());
            commodityRecordBO.setBrandName(commodityRecordPO.getBrandName());
            commodityRecordBO.setSupplierName(commodityRecordPO.getSupplierName());
            commodityRecordBO.setSupplierId(commodityRecordPO.getSupplierId());
            commodityRecordBO.setMiniOrderNum(commodityRecordPO.getMiniOrderNum());
            commodityRecordBO.setReleaseTime(commodityRecordPO.getCreateTime());
            commodityRecordBO.setSkuDesc(commodityRecordPO.getSkuDesc());
            commodityRecordBO.setSupplierShopName(commodityRecordPO.getShopName());
            commodityRecordBO.setDownReason(commodityRecordPO.getDownReason());
            commodityRecordBO.setDownTime(commodityRecordPO.getDownTime());
            commodityRecordBO.setRestoreUpTime(commodityRecordPO.getRestoreUpTime());
            commodityRecordBO.setMeasure(commodityRecordPO.getMeasure());
            commodityRecordBO.setOrgName(commodityRecordPO.getOrgName());
            commodityRecordBO.setDeliveryCycle(commodityRecordPO.getDeliveryCycle());
            commodityRecordBO.setGuaranteePeriod(commodityRecordPO.getGuaranteePeriod());
            commodityRecordBO.setAuditType(commodityRecordPO.getAuditType());
            commodityRecordBO.setMaterialCode(commodityRecordPO.getMaterialCode());
            if (commodityRecordPO.getAuditType() != null) {
                commodityRecordBO.setAuditTypeDesc(ApprovalTypeEnum.findByStep((String)commodityRecordPO.getAuditType().toString()).getMessage());
            }
            commodityRecordBO.setDealResult(commodityRecordPO.getDealResult());
            if (commodityRecordPO.getDealResult() != null) {
                commodityRecordBO.setDealResultDesc(AuditResultStatusEnum.getByStatus((Integer)commodityRecordPO.getDealResult()).getMessage());
            }
            commodityRecordBO.setDealName(commodityRecordPO.getDealName());
            commodityRecordBO.setAuditTime(commodityRecordPO.getAuditTime());
            commodityRecordBO.setSpec(commodityRecordPO.getSpec());
            commodityRecordBO.setModel(commodityRecordPO.getModel());
            commodityRecordBO.setFigure(commodityRecordPO.getFigure());
            commodityRecordBO.setTexture(commodityRecordPO.getTexture());
            commodityRecordBO.setSupplierShopId(commodityRecordPO.getSupplierShopId());
            commodityRecordBO.setShowPack(commodityRecordPO.getShowPack());
            commodityRecordBO.setMaterialName(commodityRecordPO.getMeterialName());
            if (commodityRecordPO.getShowPack() != null) {
                commodityRecordBO.setShowPackDesc(YesNoEnum.getTypeDesc((Integer)commodityRecordPO.getShowPack()));
            }
            commodityRecordBO.setCreateTime(commodityRecordPO.getCreateTime());
            if (commodityRecordPO.getSalePrice() != null) {
                commodityRecordBO.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)commodityRecordPO.getSalePrice()));
            }
            if (commodityRecordPO.getMarketPrice() != null) {
                commodityRecordBO.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)commodityRecordPO.getMarketPrice()));
            }
            commodityRecordBO.setTaxCategoryCode(commodityRecordPO.getTaxCategoryCode());
            commodityRecordBO.setBelongCategory(commodityRecordPO.getBelongCategory());
            commodityRecordBO.setAgreementDetailsId(commodityRecordPO.getAgreementDetailsId());
            commodityRecordBO.setVendorName(commodityRecordPO.getVendorName());
            commodityRecordBO.setVendorId(commodityRecordPO.getVendorId());
            commodityRecordBO.setManufacturer(commodityRecordPO.getManufacturer());
            CommodityPackBO commodityPackBO = new CommodityPackBO();
            ArrayList<CommodityPackBO> commodityPackBOS = new ArrayList<CommodityPackBO>();
            commodityPackBOS.add(commodityPackBO);
            commodityPackBO.setCommodityId(commodityRecordPO.getCommodityId());
            commodityPackBO.setWeight(commodityRecordPO.getWeight());
            commodityPackBO.setHeight(commodityRecordPO.getHeight());
            commodityPackBO.setLength(commodityRecordPO.getLength());
            commodityPackBO.setWidth(commodityRecordPO.getWidth());
            commodityPackBO.setList(commodityRecordPO.getList());
            commodityRecordBO.setCommodityPackInfo(commodityPackBOS);
            List<LadderPriceBo> ladderPriceBOS = new ArrayList();
            if (reqBO.getAuditType() != null && ApprovalTypeEnum.APPROVAL_EDIT.getStep().equals(reqBO.getAuditType().toString())) {
                String ladderPrice = commodityRecordPO.getLadderPrice();
                if (!StringUtils.isEmpty((Object)ladderPrice)) {
                    ladderPriceBOS = JSONObject.parseArray((String)ladderPrice, LadderPriceBo.class);
                }
            } else {
                try {
                    List uccLadderPricePOS;
                    if (!CollectionUtils.isEmpty((Collection)list) && CollectionUtils.isNotEmpty(uccLadderPricePOS = list.stream().filter(s -> s.getSkuId().equals(commodityRecordBO.getSkuId())).collect(Collectors.toList()))) {
                        for (UccLadderPricePO uccLadderPricePO : uccLadderPricePOS) {
                            LadderPriceBo ladderPriceBO = new LadderPriceBo();
                            if (uccLadderPricePO.getStart() != null) {
                                ladderPriceBO.setStartPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getStart()));
                            }
                            if (uccLadderPricePO.getStop() != null) {
                                ladderPriceBO.setStopPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getStop()));
                            }
                            if (uccLadderPricePO.getPrice() != null) {
                                ladderPriceBO.setPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getPrice()));
                            }
                            ladderPriceBOS.add(ladderPriceBO);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new BusinessException("8888", "\u67e5\u8be2\u9636\u68af\u4ef7\u683c\u5931\u8d25");
                }
            }
            if (reqBO.getExportType() != null && reqBO.getExportType() != 1 && reqBO.getType() == 0) {
                List approvalObjInfoMQBO;
                UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
                uacQryAuditLogReqBO.setObjId(commodityRecordPO.getCommodityId().toString());
                uacQryAuditLogReqBO.setObjType(Integer.valueOf(Integer.parseInt(ApprovalTypeEnum.APPROVAL_UP_SHELF.getStep())));
                UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
                if ("0000".equals(uacQryAuditLogRspBO.getRespCode()) && CollectionUtils.isNotEmpty((Collection)(approvalObjInfoMQBO = uacQryAuditLogRspBO.getRows()))) {
                    commodityRecordBO.setAuditMsg(((ApprovalLogBO)approvalObjInfoMQBO.get(0)).getAuditAdvice());
                }
            }
            commodityRecordBO.setLadderPrice(ladderPriceBOS);
            Long catalogId = null;
            if (CollectionUtils.isEmpty((Collection)uccCommodityTypePos)) continue;
            List catalogIds = uccCommodityTypePos.stream().filter(s -> s.getCommodityTypeId().equals(commodityRecordPO.getCommodityTypeId())).collect(Collectors.toList());
            if (catalogIds != null && catalogIds.size() > 0) {
                UccCommodityTypePo uccCommodityTypePo = (UccCommodityTypePo)catalogIds.get(0);
                catalogId = uccCommodityTypePo.getCatalogId();
            }
            commodityRecordBO.setCatalogId(catalogId);
        }
        this.getComPic(commodityRecordBOS);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(commodityRecordBOS);
        return rspBO;
    }

    private List<Long> getCommodityTypeIds(Long catalogId) {
        List uccCatalogDealPOS;
        if (catalogId == null) {
            return null;
        }
        List<Long> catalogIds = new ArrayList<Long>();
        catalogIds.add(catalogId);
        while (!CollectionUtils.isEmpty((Collection)(uccCatalogDealPOS = this.uccCatalogDealMapper.selectByUpperCatIds(catalogIds)))) {
            catalogIds = uccCatalogDealPOS.stream().map(UccCatalogDealPO::getGuideCatalogId).collect(Collectors.toList());
            if (((UccCatalogDealPO)uccCatalogDealPOS.get(0)).getCatalogLevel() != 3) continue;
            break;
        }
        List commodityTypeIds = this.uccCatRCommdTypeMapper.queryTypeByGuideCatalogIds(catalogIds);
        return commodityTypeIds;
    }

    private Long getCatalogId(Long commodityTypeId) {
        UccCommodityTypePo uccCommodityTypePo;
        Long catalogId = null;
        if (commodityTypeId != null && (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(commodityTypeId)) != null) {
            catalogId = uccCommodityTypePo.getCatalogId();
        }
        return catalogId;
    }

    private CommodityRecordVO dealReq(UccAgrGoodListQueryAbilityReqBO reqBO) {
        List<Long> commodityTypeIds = this.getCommodityTypeIds(reqBO.getCatalogId());
        if (reqBO.getCatalogId() != null && CollectionUtils.isEmpty(commodityTypeIds)) {
            return null;
        }
        CommodityRecordVO commodityRecordVO = new CommodityRecordVO();
        if (reqBO.getAgreementId() != null) {
            commodityRecordVO.setAgreementId(String.valueOf(reqBO.getAgreementId()));
        }
        commodityRecordVO.setSkuName(reqBO.getSkuName());
        commodityRecordVO.setSkuCode(reqBO.getSkuCode());
        commodityRecordVO.setBrandName(reqBO.getBrandName());
        commodityRecordVO.setSkuStatus(reqBO.getSkuStatus());
        commodityRecordVO.setSkuId(reqBO.getSkuId());
        commodityRecordVO.setShowPack(reqBO.getShowPack());
        commodityRecordVO.setModel(reqBO.getModel());
        commodityRecordVO.setSpec(reqBO.getSpec());
        commodityRecordVO.setFigure(reqBO.getFigure());
        commodityRecordVO.setManufacturer(reqBO.getManufacturer());
        commodityRecordVO.setMaterialCode(reqBO.getMaterialCode());
        commodityRecordVO.setCommodityTypeIds(commodityTypeIds);
        if (reqBO.getBeginIssueTime() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getBeginIssueTime(), (String)DateFormat));
            } else {
                commodityRecordVO.setBeginIssueTime(DateUtils.strToDateAsFormat((String)reqBO.getBeginIssueTime(), (String)DateFormat));
            }
        }
        if (reqBO.getEndIssueTime() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getEndIssueTime(), (String)DateFormat));
            } else {
                commodityRecordVO.setEndIssueTime(DateUtils.strToDateAsFormat((String)reqBO.getEndIssueTime(), (String)DateFormat));
            }
        }
        if (reqBO.getUpdateTimeBegin() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getUpdateTimeBegin(), (String)DateFormat));
            } else {
                commodityRecordVO.setUpdateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getUpdateTimeBegin(), (String)DateFormat));
            }
        }
        if (reqBO.getUpdateTimeEnd() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getUpdateTimeEnd(), (String)DateFormat));
            } else {
                commodityRecordVO.setUpdateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getUpdateTimeEnd(), (String)DateFormat));
            }
        }
        if (reqBO.getDownTimeBegin() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getDownTimeBegin(), (String)DateFormat));
            } else {
                commodityRecordVO.setDownTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getDownTimeBegin(), (String)DateFormat));
            }
        }
        if (reqBO.getDownTimeEnd() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getDownTimeEnd(), (String)DateFormat));
            } else {
                commodityRecordVO.setDownTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getDownTimeEnd(), (String)DateFormat));
            }
        }
        if (reqBO.getRestoreUpTimeBegin() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getRestoreUpTimeBegin(), (String)DateFormat));
            } else {
                commodityRecordVO.setRestoreUpTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getRestoreUpTimeBegin(), (String)DateFormat));
            }
        }
        if (reqBO.getRestoreUpTimeEnd() != null) {
            if (reqBO.getType() == 3) {
                commodityRecordVO.setCreateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getRestoreUpTimeEnd(), (String)DateFormat));
            } else {
                commodityRecordVO.setRestoreUpTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getRestoreUpTimeEnd(), (String)DateFormat));
            }
        }
        if (reqBO.getCreateTimeBegin() != null) {
            commodityRecordVO.setCreateTimeBegin(DateUtils.strToDateAsFormat((String)reqBO.getCreateTimeBegin(), (String)DateFormat));
        }
        if (reqBO.getCreateTimeEnd() != null) {
            commodityRecordVO.setCreateTimeEnd(DateUtils.strToDateAsFormat((String)reqBO.getCreateTimeEnd(), (String)DateFormat));
        }
        return commodityRecordVO;
    }

    private void getComPic(List<CommodityRecordBO> bos) {
        List commodityIds;
        List uccCommodityPicPos;
        if (!CollectionUtils.isEmpty(bos) && !CollectionUtils.isEmpty((Collection)(uccCommodityPicPos = this.uccCommodityPicMapper.queryBatchByCommdId(commodityIds = bos.stream().map(CommodityRecordBO::getCommodityId).collect(Collectors.toList()), null)))) {
            for (CommodityRecordBO bo : bos) {
                for (UccCommodityPicPo uccCommodityPicPo : uccCommodityPicPos) {
                    if (!bo.getCommodityId().equals(uccCommodityPicPo.getCommodityId()) || uccCommodityPicPo.getCommodityPicType() != 1) continue;
                    bo.setSkuPicUrl(uccCommodityPicPo.getCommodityPicUrl());
                }
            }
        }
    }
}

