/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.uccext.bo.UccBatchQuerySkuStatusAbilityReqBO;
import com.tydic.uccext.bo.UccBatchQuerySkuStatusAbilityRspBO;
import com.tydic.uccext.bo.UccSkuStusBo;
import com.tydic.uccext.service.UccBatchQuerySkuStatusAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccBatchQuerySkuStatusAbilityService"})
public class UccBatchQuerySkuStatusAbilityServiceImpl
implements UccBatchQuerySkuStatusAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccBatchQuerySkuStatusAbilityServiceImpl.class);

    @PostMapping(value={"qrySkuStatus"})
    public UccBatchQuerySkuStatusAbilityRspBO qrySkuStatus(@RequestBody UccBatchQuerySkuStatusAbilityReqBO reqBO) {
        UccBatchQuerySkuStatusAbilityRspBO rspBO = new UccBatchQuerySkuStatusAbilityRspBO();
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u6237ID");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u54c1ID");
            return rspBO;
        }
        List supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isNotEmpty((Collection)supplierShopPos)) {
            reqBO.setSupplierShopId(((SupplierShopPo)supplierShopPos.get(0)).getSupplierShopId());
        }
        List uccSkuPos = this.uccSkuMapper.batchQrySku(reqBO.getSkuIds(), reqBO.getSupplierShopId());
        ArrayList<UccSkuStusBo> uccSkuStusBos = new ArrayList<UccSkuStusBo>();
        if (CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                UccCommodityPo uccCommodityPo;
                UccSkuStusBo uccSkuStusBo = new UccSkuStusBo();
                uccSkuStusBo.setSkuId(uccSkuPo.getSkuId());
                uccSkuStusBo.setCommodityId(uccSkuPo.getCommodityId());
                uccSkuStusBo.setSkuStatus(uccSkuPo.getSkuStatus());
                if (uccSkuPo.getSkuStatus() != null) {
                    uccSkuStusBo.setSkuStatusDesc(SkuStatusEnum.getStatusDesc((Integer)uccSkuPo.getSkuStatus()).getStatusDesc());
                }
                if (null != (uccCommodityPo = this.uccCommodityMapper.qryCommdByCommdId(uccSkuPo.getCommodityId(), uccSkuPo.getSupplierShopId()))) {
                    uccSkuStusBo.setCommodityStatus(uccCommodityPo.getCommodityStatus());
                }
                if (uccSkuStusBo.getCommodityStatus() != null) {
                    uccSkuStusBo.setCommodityStatusDesc(CommodityStatusEnum.getStatusDesc((Integer)uccSkuStusBo.getCommodityStatus()).getStatusDesc());
                }
                uccSkuStusBos.add(uccSkuStusBo);
            }
        }
        rspBO.setRows(uccSkuStusBos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

