/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccCheckCanSaleBo;
import com.tydic.uccext.bo.UccCheckCanSaleReqBo;
import com.tydic.uccext.bo.UccCheckCanSaleRspBo;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccOrgGuideCatalogSalesRestrictionMapper;
import com.tydic.uccext.dao.UccOrgSkuSalesRestrictionMapper;
import com.tydic.uccext.service.UccCheckCanSaleService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccCheckCanSaleService"})
public class UccCheckCanSaleServiceImpl
implements UccCheckCanSaleService {
    private static final Logger log = LoggerFactory.getLogger(UccCheckCanSaleServiceImpl.class);
    @Autowired
    private UccOrgSkuSalesRestrictionMapper uccOrgSkuSalesRestrictionMapper;
    @Autowired
    private UccOrgGuideCatalogSalesRestrictionMapper uccOrgGuideCatalogSalesRestrictionMapper;

    @PostMapping(value={"checkInfo"})
    public UccCheckCanSaleRspBo checkInfo(@RequestBody UccCheckCanSaleReqBo reqBo) {
        UccCheckCanSaleRspBo rspBo = new UccCheckCanSaleRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getCheckInfo())) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u6821\u9a8c\u4fe1\u606f");
        }
        if (reqBo.getOrgPath() == null) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u673a\u6784\u8def\u5f84");
        }
        if (reqBo.getUserId() == null) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u7528\u6237ID");
        }
        List<Long> orgIds = Arrays.stream(reqBo.getOrgPath().split("-")).map(Long::new).collect(Collectors.toList());
        List<Long> skuIds = reqBo.getCheckInfo().stream().map(UccCheckCanSaleBo::getSkuId).collect(Collectors.toList());
        List<Long> skuLimitIds = this.uccOrgSkuSalesRestrictionMapper.getListByOrgIdsAndSkuIds(orgIds, skuIds, UccConstants.Status.VALID);
        List<Long> catalogLimitIds = this.uccOrgGuideCatalogSalesRestrictionMapper.getIdListByOrgIdList(orgIds, UccConstants.CatalogSaleRestrictionAuthType.ORG_SALE_RESTRICTION_CATALOG.getAuthType(), UccConstants.Status.VALID, skuIds);
        int checkResult = this.uccOrgGuideCatalogSalesRestrictionMapper.getCheckByUserAndStatus(reqBo.getUserId(), UccConstants.Status.INVALID, UccConstants.Status.VALID);
        for (UccCheckCanSaleBo uccCheckCanSaleBo : reqBo.getCheckInfo()) {
            if (!CollectionUtils.isEmpty(skuLimitIds) && skuLimitIds.contains(uccCheckCanSaleBo.getSkuId()) || !CollectionUtils.isEmpty(catalogLimitIds) && catalogLimitIds.contains(uccCheckCanSaleBo.getSkuId())) {
                uccCheckCanSaleBo.setCansale(UccConstants.Cansale.NO_PURCHASE);
                continue;
            }
            if (checkResult == 0) {
                uccCheckCanSaleBo.setCansale(UccConstants.Cansale.CAN_PURCHASE);
                continue;
            }
            List<Long> catalogCanBuyList = this.uccOrgGuideCatalogSalesRestrictionMapper.getIdListByOrgIdList(Arrays.asList(reqBo.getUserId()), UccConstants.CatalogSaleRestrictionAuthType.USER_CAN_PURCHASE_CATALOG.getAuthType(), UccConstants.Status.VALID, skuIds);
            if (!CollectionUtils.isEmpty(catalogCanBuyList) && catalogCanBuyList.contains(uccCheckCanSaleBo.getSkuId())) {
                uccCheckCanSaleBo.setCansale(UccConstants.Cansale.CAN_PURCHASE);
                continue;
            }
            uccCheckCanSaleBo.setCansale(UccConstants.Cansale.NO_PURCHASE);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setCheckResult(reqBo.getCheckInfo());
        return rspBo;
    }
}

