/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.util.ListUtils;
import com.tydic.uccext.bo.UccComdWithChannelAbilityBo;
import com.tydic.uccext.bo.UccComdWithChannelAbilityReqBo;
import com.tydic.uccext.bo.UccComdWithChannelAbilityRspBo;
import com.tydic.uccext.bo.UccComdWithChannelRequstBo;
import com.tydic.uccext.dao.CnncUccEMdmCatalogMapper;
import com.tydic.uccext.dao.UccBrandExtMapper;
import com.tydic.uccext.dao.po.CnncQrySkuChannelForMroPo;
import com.tydic.uccext.service.UccComdWithChannelAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccComdWithChannelAbilityService"})
public class UccComdWithChannelAbilityServiceImpl
implements UccComdWithChannelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccComdWithChannelAbilityServiceImpl.class);
    private static final String channel_code = "MRO_CHANNEL";
    private static final Long channel_Id_first = 1001L;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private CnncUccEMdmCatalogMapper cnncUccEMdmCatalogMapper;

    @PostMapping(value={"qryChannel"})
    public UccComdWithChannelAbilityRspBo qryChannel(@RequestBody UccComdWithChannelAbilityReqBo reqBo) {
        UccComdWithChannelAbilityRspBo rspBo = new UccComdWithChannelAbilityRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getQryInfo())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u8f93\u5165\u5fc5\u8981\u53c2\u6570");
            return rspBo;
        }
        ArrayList<UccComdWithChannelAbilityBo> uccComdWithChannelAbilityBos = new ArrayList<UccComdWithChannelAbilityBo>();
        Map<Long, List<UccComdWithChannelRequstBo>> map = reqBo.getQryInfo().stream().collect(Collectors.groupingBy(UccComdWithChannelRequstBo::getSupplierShopId));
        for (Map.Entry<Long, List<UccComdWithChannelRequstBo>> each : map.entrySet()) {
            Long supplierShopId = each.getKey();
            List<Long> skuIds = each.getValue().stream().map(UccComdWithChannelRequstBo::getSkuId).collect(Collectors.toList());
            List<CnncQrySkuChannelForMroPo> cnncQrySkuChannelForMroPos = this.uccBrandExtMapper.qrySkuChannelForMro(skuIds, supplierShopId, null);
            if (CollectionUtils.isEmpty(cnncQrySkuChannelForMroPos)) continue;
            Map<Long, List<CnncQrySkuChannelForMroPo>> skuMap = cnncQrySkuChannelForMroPos.stream().collect(Collectors.groupingBy(CnncQrySkuChannelForMroPo::getSkuId));
            for (Map.Entry<Long, List<CnncQrySkuChannelForMroPo>> skuEach : skuMap.entrySet()) {
                Long skuId = skuEach.getKey();
                UccComdWithChannelAbilityBo uccComdWithChannelAbilityBo = new UccComdWithChannelAbilityBo();
                uccComdWithChannelAbilityBo.setSkuId(skuId);
                uccComdWithChannelAbilityBo.setSupplierShopId(supplierShopId);
                List channelIds = skuEach.getValue().stream().map(CnncQrySkuChannelForMroPo::getChannelId).collect(Collectors.toList());
                List newList = ListUtils.removeReapet(channelIds);
                ArrayList<Long> canList = new ArrayList<Long>();
                for (Long channelId : newList) {
                    if (channel_Id_first.equals(channelId)) continue;
                    canList.add(channelId);
                }
                uccComdWithChannelAbilityBo.setChannels(canList);
                List shopCatalogTypes = skuEach.getValue().stream().map(CnncQrySkuChannelForMroPo::getShopCatalogType).collect(Collectors.toList());
                if (shopCatalogTypes.contains(1)) {
                    uccComdWithChannelAbilityBo.setMro(true);
                } else {
                    uccComdWithChannelAbilityBo.setMro(false);
                }
                uccComdWithChannelAbilityBos.add(uccComdWithChannelAbilityBo);
            }
        }
        this.getFirstChannel(uccComdWithChannelAbilityBos);
        rspBo.setRows(uccComdWithChannelAbilityBos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void getFirstChannel(List<UccComdWithChannelAbilityBo> bos) {
        List<Long> skuIds;
        List<Long> havIds;
        if (!CollectionUtils.isEmpty(bos) && !CollectionUtils.isEmpty(havIds = this.cnncUccEMdmCatalogMapper.getFirstChannel(skuIds = bos.stream().map(UccComdWithChannelAbilityBo::getSkuId).collect(Collectors.toList())))) {
            for (UccComdWithChannelAbilityBo bo : bos) {
                if (havIds.contains(bo.getSkuId())) {
                    bo.setFirstChannel(Integer.valueOf(1));
                    continue;
                }
                bo.setFirstChannel(Integer.valueOf(0));
            }
        }
    }
}

