/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccCommodityPicSyncCheckAbilityReqBO;
import com.tydic.uccext.bo.UccCommodityPicSyncCheckAbilityRspBO;
import com.tydic.uccext.bo.UccFtpDirectoryFileBO;
import com.tydic.uccext.bo.UccQryFtpDirectoryAbilityReqBO;
import com.tydic.uccext.bo.UccQryFtpDirectoryAbilityRspBO;
import com.tydic.uccext.dao.UccCommodityExtMapper;
import com.tydic.uccext.service.UccCommodityPicSyncCheckAbilityService;
import com.tydic.uccext.service.UccQryFtpDirectoryAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccCommodityPicSyncCheckAbilityService"})
public class UccCommodityPicSyncCheckAbilityServiceImpl
implements UccCommodityPicSyncCheckAbilityService {
    @Autowired
    private UccQryFtpDirectoryAbilityService uccQryFtpDirectoryAbilityService;
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;
    private final Pattern pattern = Pattern.compile("^\\d{3}$");
    private final String emptyValue = "[]";

    @PostMapping(value={"dealCommodityPicSyncCheck"})
    public UccCommodityPicSyncCheckAbilityRspBO dealCommodityPicSyncCheck(@RequestBody UccCommodityPicSyncCheckAbilityReqBO reqBo) {
        UccCommodityPicSyncCheckAbilityRspBO rspBo = new UccCommodityPicSyncCheckAbilityRspBO();
        List<String> fileNameList = this.getFileNameList(reqBo.getFtpPath());
        Map<String, List<String>> commodityPicMap = this.groupFileNameList(fileNameList);
        String resultPrefixCheck = this.checkFilePrefix(commodityPicMap);
        String resultSuffixCheck = this.checkfileSuffix(commodityPicMap);
        rspBo.setCheckResult("\u6821\u9a8c\u5b8c\u6210</br>" + resultPrefixCheck + resultSuffixCheck);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<String> getFileNameList(String ftpPath) {
        UccQryFtpDirectoryAbilityReqBO uccQryFtpDirectoryAbilityReqBo = new UccQryFtpDirectoryAbilityReqBO();
        uccQryFtpDirectoryAbilityReqBo.setDirPath(ftpPath);
        UccQryFtpDirectoryAbilityRspBO uccQryFtpDirectoryAbilityRspBo = this.uccQryFtpDirectoryAbilityService.qryFtpDirectory(uccQryFtpDirectoryAbilityReqBo);
        if (!"0000".equals(uccQryFtpDirectoryAbilityRspBo.getRespCode()) || null == uccQryFtpDirectoryAbilityRspBo.getFtpDirectory() || CollectionUtils.isEmpty((Collection)uccQryFtpDirectoryAbilityRspBo.getFtpDirectory().getFileList())) {
            throw new BusinessException("8888", "\u83b7\u53d6\u56fe\u7247\u76ee\u5f55\u4fe1\u606f\u5931\u8d25");
        }
        List fileList = uccQryFtpDirectoryAbilityRspBo.getFtpDirectory().getFileList();
        List<String> fileNameList = fileList.stream().filter(isDir -> isDir.getIsDir() == false).map(UccFtpDirectoryFileBO::getFileName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fileNameList)) {
            throw new BusinessException("8888", "\u672a\u83b7\u53d6\u5230\u56fe\u7247\u4fe1\u606f");
        }
        return fileNameList;
    }

    private Map<String, List<String>> groupFileNameList(List<String> fileNameList) {
        HashMap<String, List<String>> commodityPicMap = new HashMap<String, List<String>>(16);
        fileNameList.forEach(fileName -> {
            String commodityCode = fileName.split("-")[0];
            if (commodityPicMap.containsKey(commodityCode)) {
                ((List)commodityPicMap.get(commodityCode)).add(fileName);
            } else {
                ArrayList<String> fileNames = new ArrayList<String>();
                fileNames.add((String)fileName);
                commodityPicMap.put(commodityCode, fileNames);
            }
        });
        return commodityPicMap;
    }

    private String checkFilePrefix(Map<String, List<String>> commodityPicMap) {
        Set<String> commodityCodes = commodityPicMap.keySet();
        String result = "";
        StringJoiner sj = new StringJoiner(",", "[", "]");
        List<UccCommodityPo> uccCommodityPos = this.uccCommodityExtMapper.checkSyncPicCommodity(new ArrayList<String>(commodityCodes));
        if (CollectionUtils.isEmpty(uccCommodityPos)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u4efb\u4f55\u56fe\u7247\u5bf9\u5e94\u7684\u5f85\u5904\u7406\u5546\u54c1\u4fe1\u606f");
        }
        List codeList = uccCommodityPos.stream().map(UccCommodityPo::getCommodityCode).collect(Collectors.toList());
        HashSet<String> removeCode = new HashSet<String>();
        for (String code : commodityCodes) {
            if (codeList.contains(code)) continue;
            sj.add(code);
            removeCode.add(code);
        }
        if (!CollectionUtils.isEmpty(removeCode)) {
            removeCode.forEach(commodityPicMap::remove);
        }
        if (!"[]".equals(sj.toString())) {
            result = sj.toString() + "\u4ee5\u4e0a\u7f16\u7801\u5bf9\u5e94\u5546\u54c1\u4e0d\u4e3a\u5f85\u540c\u6b65\u5546\u54c1\uff1b</br>";
        }
        return result;
    }

    private String checkfileSuffix(Map<String, List<String>> commodityPicMap) {
        String result = "";
        StringJoiner sjSuffixDigit = new StringJoiner(",", "[", "]");
        StringJoiner sjSuffix001 = new StringJoiner(",", "[", "]");
        commodityPicMap.forEach((code, fileNameList) -> {
            boolean pic001 = false;
            for (String fileName : fileNameList) {
                String nameSuffix = fileName.split("[.]")[0].split("[-]")[1];
                Matcher is3Digit = this.pattern.matcher(nameSuffix);
                if (!is3Digit.matches()) {
                    sjSuffixDigit.add(fileName);
                    continue;
                }
                if (!"001".equals(nameSuffix)) continue;
                pic001 = true;
            }
            if (!pic001) {
                sjSuffix001.add((CharSequence)code);
            }
        });
        if (!"[]".equals(sjSuffixDigit.toString())) {
            result = result + sjSuffixDigit.toString() + "\u4ee5\u4e0a\u56fe\u7247\u4e0d\u7b26\u54083\u4f4d\u6570\u5b57\u7f16\u7801\u7684\u540d\u79f0\u540e\u7f00\u683c\u5f0f\uff1b</br>";
        }
        if (!"[]".equals(sjSuffix001.toString())) {
            result = result + sjSuffix001.toString() + "\u4ee5\u4e0a\u7f16\u7801\u5bf9\u5e94\u5546\u54c1\u7f3a\u5c11\u540d\u79f0\u540e\u7f00\u4e3a001\u7684\u4e3b\u56fe\uff1b</br>";
        }
        return result;
    }
}

