/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuOperTypeEnum;
import com.tydic.commodity.enumType.SkuSourceEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.uccext.bo.UccCommodityPicBO;
import com.tydic.uccext.bo.UccCreateCommodityAbilityReqBO;
import com.tydic.uccext.bo.UccCreateCommodityAbilityRspBO;
import com.tydic.uccext.bo.UccCreateCommodityBO;
import com.tydic.uccext.bo.UccCreateCommodityBusiReqBO;
import com.tydic.uccext.bo.UccCreateCommodityBusiRspBO;
import com.tydic.uccext.bo.UccLadderPriceBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccCommodityExtMapper;
import com.tydic.uccext.service.UccCreateCommodityAbilityService;
import com.tydic.uccext.service.UccCreateCommodityBusiService;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccCreateCommodityAbilityService"})
public class UccCreateCommodityAbilityServiceImpl
implements UccCreateCommodityAbilityService {
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;
    @Autowired
    private UccCreateCommodityBusiService uccCreateCommodityBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    private final Pattern pattern = Pattern.compile("^\\d{7}$");
    @Value(value="${DEFAULT_MAIN_PIC_URL}")
    private String defaultMainPicUrl;

    @PostMapping(value={"createCommodity"})
    public UccCreateCommodityAbilityRspBO createCommodity(@RequestBody UccCreateCommodityAbilityReqBO reqBo) {
        UccCreateCommodityAbilityRspBO rspBo = new UccCreateCommodityAbilityRspBO();
        rspBo.setRespCode("8888");
        String rspDesc = this.validateArgs(reqBo);
        if (StringUtils.hasText((String)rspDesc)) {
            rspBo.setRespDesc(rspDesc);
            return rspBo;
        }
        UccCreateCommodityBusiReqBO busiReqBo = new UccCreateCommodityBusiReqBO();
        UccCreateCommodityBO createCommodityBo = new UccCreateCommodityBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)busiReqBo);
        BeanUtils.copyProperties((Object)reqBo, (Object)createCommodityBo);
        createCommodityBo.setCommoditySource(SkuSourceEnum.PROPRIETARY_SKU_SOURCE.getSource());
        createCommodityBo.setCommodityStatus(CommodityStatusEnum.EFFECTIVE_STATUS.getStatus());
        createCommodityBo.setSkuStatus(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
        busiReqBo.setCreateInfoList(Collections.singletonList(createCommodityBo));
        busiReqBo.setOperType(SkuOperTypeEnum.CREATE_SKU.getOperType());
        UccCreateCommodityBusiRspBO busiRspBo = this.uccCreateCommodityBusiService.createCommodity(busiReqBo);
        if ("0000".equals(busiRspBo.getRespCode())) {
            this.syncEs(busiRspBo.getCommodityList());
        }
        BeanUtils.copyProperties((Object)busiRspBo, (Object)rspBo);
        return rspBo;
    }

    private String validateArgs(UccCreateCommodityAbilityReqBO reqBo) {
        int repeat;
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getMoq() || 1 > reqBo.getMoq()) {
            reqBo.setMoq(Integer.valueOf(1));
        }
        if (null != reqBo.getMoq() && null != reqBo.getMaxoq() && reqBo.getMaxoq() <= reqBo.getMoq()) {
            return "\u6700\u5927\u8d77\u8ba2\u91cf\u5fc5\u987b\u5927\u4e8e\u6700\u5c0f\u8d77\u8ba2\u91cf";
        }
        if (!StringUtils.hasText((String)reqBo.getCommodityCode())) {
            return "\u5165\u53c2\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Matcher is7Digit = this.pattern.matcher(reqBo.getCommodityCode());
        if (!is7Digit.matches()) {
            return "\u5165\u53c2\u5546\u54c1\u7f16\u7801\u5fc5\u987b\u75317\u4f4d\u6570\u5b57\u6784\u6210";
        }
        if (!StringUtils.hasText((String)reqBo.getCommodityName())) {
            return "\u5165\u53c2\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getCommodityBanner())) {
            return "\u5165\u53c2\u5546\u54c1\u526f\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getCommodityTypeId()) {
            return "\u5165\u53c2\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getBrandId()) {
            return "\u5165\u53c2\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getBrandName())) {
            return "\u5165\u53c2\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getMeasureName())) {
            return "\u5165\u53c2\u57fa\u672c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getMaterialId()) {
            return "\u5165\u53c2\u7269\u8d44\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getSalePrice()) {
            return "\u5165\u53c2\u5546\u54c1\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (BigDecimal.ZERO.compareTo(reqBo.getSalePrice()) > 0) {
            return "\u5165\u53c2\u5546\u54c1\u552e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u96f6";
        }
        if (null == reqBo.getIsShowSaleUnit()) {
            return "\u5165\u53c2\u662f\u5426\u5c55\u793a\u5305\u88c5\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getSceneIds())) {
            return "\u5165\u53c2\u5173\u8054\u9152\u5e97\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommdImages())) {
            for (UccCommodityPicBO picBo : reqBo.getCommdImages()) {
                if (null == picBo.getPicType()) {
                    return "\u5165\u53c2\u56fe\u7247\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (!ModelRuleConstant.COMMD_IMG_MAIN.equals(picBo.getPicType()) && !ModelRuleConstant.COMMD_IMG_DETAIL.equals(picBo.getPicType())) {
                    return "\u5165\u53c2\u56fe\u7247\u7c7b\u578b\u4e0d\u6b63\u786e";
                }
                if (!StringUtils.hasText((String)picBo.getPicUrl())) {
                    return "\u5165\u53c2\u56fe\u7247\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null != picBo.getPicOrder()) continue;
                picBo.setPicOrder(Integer.valueOf(0));
            }
        } else {
            UccCommodityPicBO uccCommodityPicBo = new UccCommodityPicBO();
            uccCommodityPicBo.setPicType(ModelRuleConstant.COMMD_IMG_MAIN);
            uccCommodityPicBo.setPicUrl(this.defaultMainPicUrl);
            uccCommodityPicBo.setPicOrder(Integer.valueOf(0));
            uccCommodityPicBo.setRemark("\u9ed8\u8ba4\u4e3b\u56fe");
            reqBo.setCommdImages(Collections.singletonList(uccCommodityPicBo));
        }
        if (null != reqBo.getCommodityPackageSpec() && UccConstants.YesOrNo.YES.equals(reqBo.getIsShowSaleUnit())) {
            if (!StringUtils.hasText((String)reqBo.getCommodityPackageSpec().getSaleUnitName())) {
                return "\u5305\u88c5\u89c4\u683c\u4fe1\u606f\u4e2d\u5305\u88c5\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (!StringUtils.hasText((String)reqBo.getCommodityPackageSpec().getPackageSpec())) {
                return "\u5305\u88c5\u89c4\u683c\u4fe1\u606f\u4e2d\u5305\u88c5\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getCommodityPackageSpec().getUnitRate() || BigDecimal.ZERO.compareTo(reqBo.getCommodityPackageSpec().getUnitRate()) >= 0) {
                return "\u5305\u88c5\u89c4\u683c\u4fe1\u606f\u4e2d\u5355\u4f4d\u6362\u7b97\u503c\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e\u96f6";
            }
            reqBo.getCommodityPackageSpec().setAgreementPrice(reqBo.getSalePrice());
            reqBo.getCommodityPackageSpec().setSalePrice(reqBo.getSalePrice().multiply(reqBo.getCommodityPackageSpec().getUnitRate()).setScale(2, 4));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getLadderPrice())) {
            BigDecimal salePrice;
            List ladderPrice = reqBo.getLadderPrice();
            BigDecimal bigDecimal = salePrice = UccConstants.YesOrNo.YES.equals(reqBo.getIsShowSaleUnit()) ? reqBo.getCommodityPackageSpec().getSalePrice() : reqBo.getSalePrice();
            if (((UccLadderPriceBO)ladderPrice.get(0)).getPrice().compareTo(salePrice) != 0) {
                return "\u9636\u68af\u4ef7\u683c\u7b2c\u4e00\u9636\u6bb5\u7684\u4ef7\u683c\u5e94\u4e0e\u5b9e\u9645\u9500\u552e\u4ef7\u76f8\u540c";
            }
            for (int i = 0; i < ladderPrice.size(); ++i) {
                UccLadderPriceBO ladder = (UccLadderPriceBO)ladderPrice.get(i);
                if (i == 0 && 1L != ladder.getStart()) {
                    ladder.setStart(Long.valueOf(1L));
                }
                if (null == ladder.getStart()) {
                    return "\u9636\u68af\u4ef7\u683c\u8d77\u59cb\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (0L > ladder.getStart()) {
                    return "\u9636\u68af\u4ef7\u683c\u8d77\u59cb\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u96f6";
                }
                if ((null == ladder.getStop() || 0L >= ladder.getStop()) && i != ladderPrice.size() - 1) {
                    return "\u9636\u68af\u4ef7\u683c\u622a\u6b62\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e\u96f6";
                }
                if (null == ladder.getPrice()) {
                    return "\u9636\u68af\u4ef7\u683c\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (BigDecimal.ZERO.compareTo(ladder.getPrice()) > 0) {
                    return "\u9636\u68af\u4ef7\u683c\u552e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u96f6";
                }
                ladder.setPrice(ladder.getPrice().setScale(2, 4));
                if (i > 0 && i < ladderPrice.size()) {
                    Long start = ladder.getStart();
                    Long stop = ((UccLadderPriceBO)ladderPrice.get(i - 1)).getStop();
                    if (stop + 1L != start) {
                        return "\u9636\u68af\u4ef7\u683c\u6bcf\u4e00\u9636\u6bb5\u7684\u6570\u91cf\u5fc5\u987b\u5173\u8054\u8d77\u6765";
                    }
                }
                ladder.setDiscount(ladder.getPrice().divide(salePrice, 6, RoundingMode.HALF_UP).multiply(new BigDecimal("100")));
                if (i != ladderPrice.size() - 1 || null == ladder.getStop() || ladder.getStop() <= 0L) continue;
                return "\u9636\u68af\u4ef7\u683c\u5fc5\u987b\u4e3a\u95ed\u73af\uff0c\u6700\u540e\u4e00\u9636\u6bb5\u622a\u6b62\u6570\u91cf\u5fc5\u987b\u5230\u8fbe\u65e0\u7a77\u5927\u221e";
            }
        }
        if ((repeat = this.uccCommodityExtMapper.checkCodeRepeat(reqBo.getCommodityCode())) > 0) {
            return "\u5546\u54c1\u7f16\u7801\u91cd\u590d";
        }
        if (StringUtils.hasText((String)reqBo.getCommodityPcDetailChar())) {
            byte[] bytes = Base64Utils.decodeFromString((String)reqBo.getCommodityPcDetailChar());
            try {
                reqBo.setCommodityPcDetailChar(URLDecoder.decode(new String(bytes), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        reqBo.setSalePrice(reqBo.getSalePrice().setScale(2, 4));
        return null;
    }

    private void syncEs(Map<Long, List<Long>> commodityList) {
        if (!CollectionUtils.isEmpty(commodityList)) {
            commodityList.forEach((supplierShopId, commodityIdList) -> {
                if (null != supplierShopId && !CollectionUtils.isEmpty((Collection)commodityIdList)) {
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBo.setCommodityIds(commodityIdList);
                    syncSceneCommodityToEsReqBo.setSupplierId(supplierShopId);
                    syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                    syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                    syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
                }
            });
        }
    }
}

