/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccCreateGiftAbilityReqBO;
import com.tydic.uccext.bo.UccCreateGiftAbilityRspBO;
import com.tydic.uccext.bo.UccGiftPicBO;
import com.tydic.uccext.service.UccCreateGiftAbilityService;
import com.tydic.uccext.service.UccCreateGiftBusiService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccCreateGiftAbilityService"})
public class UccCreateGiftAbilityServiceImpl
implements UccCreateGiftAbilityService {
    @Autowired
    private UccCreateGiftBusiService uccCreateGiftBusiService;
    @Value(value="${DEFAULT_MAIN_PIC_URL}")
    private String defaultMainPicUrl;

    @PostMapping(value={"createGift"})
    public UccCreateGiftAbilityRspBO createGift(@RequestBody UccCreateGiftAbilityReqBO reqBo) {
        this.doCheckValidReq(reqBo);
        return this.uccCreateGiftBusiService.createGift(reqBo);
    }

    private void doCheckValidReq(UccCreateGiftAbilityReqBO reqBo) {
        if (reqBo == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBo.getGiftName())) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u8d60\u54c1\u540d\u79f0\uff01");
        }
        if (!StringUtils.hasText((String)reqBo.getGiftCode())) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u8d60\u54c1\u7f16\u7801\uff01");
        }
        if (!StringUtils.hasText((String)reqBo.getMeasureName())) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u57fa\u672c\u5355\u4f4d\uff01");
        }
        if (reqBo.getBrandId() == null) {
            throw new BusinessException("8888", "\u8bf7\u9009\u62e9\u54c1\u724c\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getGiftPics())) {
            UccGiftPicBO uccGiftPicBo = new UccGiftPicBO();
            uccGiftPicBo.setGiftPicType(ModelRuleConstant.COMMD_IMG_MAIN);
            uccGiftPicBo.setGiftPicUrl(this.defaultMainPicUrl);
            uccGiftPicBo.setGiftPicOrder(Integer.valueOf(0));
            uccGiftPicBo.setRemark("\u9ed8\u8ba4\u4e3b\u56fe");
            reqBo.setGiftPics(Collections.singletonList(uccGiftPicBo));
        } else {
            reqBo.getGiftPics().forEach(pic -> {
                if (!StringUtils.hasText((String)pic.getGiftPicUrl())) {
                    throw new BusinessException("8888", "\u56fe\u7247URL\u4e0d\u80fd\u7a7a\uff01");
                }
                if (null == pic.getGiftPicOrder()) {
                    pic.setGiftPicOrder(Integer.valueOf(0));
                }
            });
        }
        if (StringUtils.hasText((String)reqBo.getDetail())) {
            byte[] bytes = Base64Utils.decodeFromString((String)reqBo.getDetail());
            try {
                reqBo.setDetail(URLDecoder.decode(new String(bytes), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }
}

