/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import com.tydic.uccext.bo.UccCreateGiftAndSkuRelAbilityReqBO;
import com.tydic.uccext.bo.UccCreateGiftAndSkuRelAbilityRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccGiftsMapper;
import com.tydic.uccext.dao.UccRelSkuGiftsMapper;
import com.tydic.uccext.dao.po.UccGiftsPO;
import com.tydic.uccext.dao.po.UccRelSkuGiftsPO;
import com.tydic.uccext.service.UccCreateGiftAndSkuRelAbilityService;
import com.tydic.uccext.service.UccCreateGiftAndSkuRelBusiService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccCreateGiftAndSkuRelAbilityService"})
public class UccCreateGiftAndSkuRelAbilityServiceImpl
implements UccCreateGiftAndSkuRelAbilityService {
    @Autowired
    private UccCreateGiftAndSkuRelBusiService uccCreateGiftAndSkuRelBusiService;
    @Autowired
    private UccRelSkuGiftsMapper uccRelSkuGiftsMapper;
    @Autowired
    private UccGiftsMapper uccGiftsMapper;

    @PostMapping(value={"createGiftAndSkuRel"})
    public UccCreateGiftAndSkuRelAbilityRspBO createGiftAndSkuRel(@RequestBody UccCreateGiftAndSkuRelAbilityReqBO reqBo) {
        this.doCheckValidReq(reqBo);
        this.doCheckExistAndEff(reqBo.getGiftId());
        this.doCheckExistOnly(reqBo);
        return this.uccCreateGiftAndSkuRelBusiService.createGiftAndSkuRel(reqBo);
    }

    private void doCheckExistAndEff(Long giftId) {
        UccGiftsPO uccGiftsPo = new UccGiftsPO();
        uccGiftsPo.setGiftId(giftId);
        uccGiftsPo = this.uccGiftsMapper.getModelBy(uccGiftsPo);
        if (uccGiftsPo == null) {
            throw new BusinessException("8888", "\u8be5\u8d60\u54c1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\uff01");
        }
        if (!UccConstants.Status.VALID.equals(uccGiftsPo.getGiftStatus())) {
            throw new BusinessException("8888", "\u8be5\u8d60\u54c1\u5df2\u5931\u6548\uff01");
        }
    }

    private void doCheckExistOnly(UccCreateGiftAndSkuRelAbilityReqBO reqBo) {
        if (reqBo.getSkuId() != null) {
            this.qryOnlyExist(reqBo.getGiftId(), reqBo.getCommodityId(), reqBo.getSkuId());
        }
    }

    private void qryOnlyExist(Long giftId, Long commodityId, Long skuId) {
        UccRelSkuGiftsPO uccRelSkuGiftsPo = new UccRelSkuGiftsPO();
        uccRelSkuGiftsPo.setCommodityId(commodityId);
        uccRelSkuGiftsPo.setSkuId(skuId);
        List<UccRelSkuGiftsPO> uccRelSkuGiftsPoList = this.uccRelSkuGiftsMapper.getList(uccRelSkuGiftsPo);
        if (!CollectionUtils.isEmpty(uccRelSkuGiftsPoList)) {
            Date now = new Date();
            for (UccRelSkuGiftsPO relPo : uccRelSkuGiftsPoList) {
                if (!relPo.getExpTime().before(now) || relPo.getGiftId().equals(giftId)) continue;
                throw new BusinessException("8888", "\u8be5\u5546\u54c1\u5df2\u5b58\u5728\u6709\u6548\u5173\u8054\u8d60\u54c1\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u5173\u8054");
            }
        }
    }

    private void doCheckValidReq(UccCreateGiftAndSkuRelAbilityReqBO reqBo) {
        Date exp;
        if (reqBo == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBo.getGiftId() == null) {
            throw new BusinessException("8888", "\u3010\u8d60\u54c1id\u3011\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (reqBo.getCommodityId() == null) {
            throw new BusinessException("8888", "\u3010\u5546\u54c1ID\u3011\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (reqBo.getRuleBuyCount() == null) {
            throw new BusinessException("8888", "\u3010\u89c4\u5219-\u8d2d\u4e70\u6570\u91cf\u3011\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (0 >= reqBo.getRuleBuyCount()) {
            throw new BusinessException("8888", "\u3010\u89c4\u5219-\u8d2d\u4e70\u6570\u91cf\u3011\u5fc5\u987b\u5927\u4e8e\u96f6\uff01");
        }
        if (reqBo.getRulePresentCount() == null) {
            throw new BusinessException("8888", "\u3010\u89c4\u5219-\u8d60\u9001\u6570\u91cf\u3011\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (0 >= reqBo.getRulePresentCount()) {
            throw new BusinessException("8888", "\u3010\u89c4\u5219-\u8d60\u9001\u6570\u91cf\u3011\u5fc5\u987b\u5927\u4e8e\u96f6\uff01");
        }
        if (!StringUtils.hasText((String)reqBo.getEffTime())) {
            throw new BusinessException("8888", "\u3010\u751f\u6548\u65f6\u95f4\u3011\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBo.getExpTime())) {
            throw new BusinessException("8888", "\u3010\u5931\u6548\u65f6\u95f4\u3011\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Date eff = DateUtils.strToDate((String)reqBo.getEffTime());
        if (eff.after(exp = DateUtils.strToDate((String)reqBo.getExpTime()))) {
            throw new BusinessException("8888", "\u3010\u751f\u6548\u65f6\u95f4\u3011\u4e0d\u80fd\u665a\u4e8e\u3010\u5931\u6548\u65f6\u95f4\u3011\uff01");
        }
    }
}

