/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccExcelTemplateExportAbilityReqBO;
import com.tydic.uccext.bo.UccExcelTemplateExportAbilityRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccBrandExtMapper;
import com.tydic.uccext.dao.UccExtCommodityTypeMapper;
import com.tydic.uccext.dao.UccMaterialTypeMapper;
import com.tydic.uccext.dao.po.UccExtCommodityTypePo;
import com.tydic.uccext.dao.po.UccMaterialTypePO;
import com.tydic.uccext.service.UccExcelTemplateExportAbilityService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccExcelTemplateExportAbilityService"})
public class UccExcelTemplateExportAbilityServiceImpl
implements UccExcelTemplateExportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccExcelTemplateExportAbilityServiceImpl.class);
    @Autowired
    private UccExtCommodityTypeMapper uccExtCommodityTypeMapper;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccMaterialTypeMapper uccMaterialTypeMapper;
    @Autowired
    private FileClient fileClient;
    @Value(value="${fastdfs.downloadUrl:}")
    private String fastdfsDownloadUrl;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${TEMPLATE_DIR_PATH:}")
    private String templateDirPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealExcelTemplateExport"})
    public UccExcelTemplateExportAbilityRspBO dealExcelTemplateExport(@RequestBody UccExcelTemplateExportAbilityReqBO reqBo) {
        UccExcelTemplateExportAbilityRspBO rspBo = new UccExcelTemplateExportAbilityRspBO();
        String fileUrl = null;
        FileInputStream fileInputStream = null;
        File file = this.genTemplate();
        if (null != file) {
            try {
                fileInputStream = new FileInputStream(file);
                String path = this.fileClient.uploadFileByInputStream(this.templateDirPath, file.getName(), (InputStream)fileInputStream);
                if (FileType.isOss((String)this.fileType)) {
                    fileUrl = "https://" + this.ossFileUrl + path;
                } else if (FileType.isFastdfs((String)this.fileType)) {
                    fileUrl = this.fastdfsDownloadUrl + "/" + path.replace(",", "/");
                }
            }
            catch (FileNotFoundException e) {
                log.error("\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            }
            finally {
                try {
                    if (null != fileInputStream) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            boolean delete = file.delete();
            if (!delete) {
                log.warn("\u5546\u54c1\u6a21\u677f\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u5931\u8d25");
            }
        } else {
            throw new BusinessException("8888", "\u751f\u6210\u6a21\u677f\u6587\u4ef6\u5931\u8d25");
        }
        rspBo.setFileUrl(fileUrl);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private Workbook createWorkbook() {
        return new XSSFWorkbook();
    }

    private File genTemplate() {
        File file;
        FileOutputStream fileOutputStream = null;
        try {
            boolean newFile;
            Workbook workbook = this.createWorkbook();
            this.initialExcelStyle(workbook);
            file = new File("\u5546\u54c1\u6a21\u677f.xlsx");
            if (!file.exists() && !(newFile = file.createNewFile())) {
                throw new BusinessException("8888", "\u521b\u5efa\u6587\u4ef6\u5f02\u5e38");
            }
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.flush();
            workbook.write((OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u6a21\u677f\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("8888", "\u521b\u5efa\u6a21\u677f\u6587\u4ef6\u5f02\u5e38");
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u521b\u5efa\u6a21\u677f\u7684\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
        return file;
    }

    private void initialExcelStyle(Workbook workbook) {
        int headLength = UccConstants.COMMODITY_TEMPLATE_HEAD.size();
        CellStyle style = workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        DataFormat dataFormat = workbook.createDataFormat();
        style.setDataFormat(dataFormat.getFormat("@"));
        style.setWrapText(true);
        Sheet commoditySheet = workbook.getSheet("\u5546\u54c1\u4fe1\u606f");
        if (null == commoditySheet) {
            commoditySheet = workbook.createSheet("\u5546\u54c1\u4fe1\u606f");
            Row commentRow = commoditySheet.createRow(0);
            CellRangeAddress region = new CellRangeAddress(0, 0, 0, headLength - 1);
            commoditySheet.addMergedRegion(region);
            commentRow.setHeight((short)1800);
            Cell commentRowCell = commentRow.createCell(0, CellType.STRING);
            CellStyle commentCellStyle = workbook.createCellStyle();
            Font font = workbook.createFont();
            font.setColor((short)10);
            commentCellStyle.setFont(font);
            commentCellStyle.setWrapText(true);
            commentRowCell.setCellStyle(commentCellStyle);
            commentRowCell.setCellValue("1.\u5e26\u6709*\u7684\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\uff1b\r\n2.\u82e5\u6709\u591a\u4e2a\u9152\u5e97\u54c1\u724c\u8bf7\u8f93\u5165\u540d\u79f0\u5e76\u4ee5\u9017\u53f7\u5206\u9694\r\n3.\u9636\u68af\u4ef7\u4e3a\u201c\u8d77\u59cb\u6570\u91cf-\u622a\u6b62\u6570\u91cf-\u4ef7\u683c\u201d\u7684\u683c\u5f0f\uff0c\u591a\u6761\u8bf7\u4ee5\u9017\u53f7\u5206\u9694\uff0c\u6700\u540e\u4e00\u9636\u4e3a\u221e\uff08\u65e0\u7a77\u5927\uff09\u8bf7\u4ee5*\u4ee3\u66ff\uff0c\u7b2c\u4e00\u9636\u7684\u8d77\u59cb\u6570\u91cf\u5fc5\u987b\u4e3a1\u4e14\u4ef7\u683c\u5fc5\u987b\u4e0e\u5b9e\u9645\u9500\u552e\u4ef7\u76f8\u540c\uff1b\r\n4.\u5305\u88c5\u5355\u4f4d\u3001\u5305\u88c5\u89c4\u683c\u3001\u5355\u4f4d\u6362\u7b97\u503c\u4e09\u4e2a\u5b57\u6bb5\u5fc5\u987b\u540c\u65f6\u90fd\u6709\u503c\u624d\u751f\u6548\uff1b\r\n5.\u6700\u5927\u8d77\u8ba2\u91cf\u5fc5\u987b\u5927\u4e8e\u6700\u5c0f\u8d77\u8ba2\u91cf,\u4e0d\u586b\u5219\u4e3a\u65e0\u9650\u5236;\r\n6.\u5efa\u8bae\u5355\u6b21\u5bfc\u5165\u6570\u636e\u91cf\u4e0d\u8981\u8d85\u8fc71000\u6761");
            Row headRow = commoditySheet.createRow(1);
            for (int i = 0; i < headLength; ++i) {
                commoditySheet.setDefaultColumnStyle(i, style);
                commoditySheet.setColumnWidth(i, 5000);
                headRow.setRowStyle(style);
                Cell cell = headRow.createCell(i, CellType.STRING);
                cell.setCellStyle(style);
                cell.setCellValue(UccConstants.COMMODITY_TEMPLATE_HEAD.get(i));
            }
        }
        this.createDropDownBoxCommodityType(workbook, style, commoditySheet);
        this.createDropDownBoxMaterialType(workbook, style, commoditySheet);
        this.createDropDownBoxBrand(workbook, style, commoditySheet);
    }

    private void createDropDownBoxCommodityType(Workbook workbook, CellStyle style, Sheet commoditySheet) {
        String commodityTypeSheet = "\u5546\u54c1\u7c7b\u578b";
        Sheet sheet = this.getSheet(workbook, commodityTypeSheet);
        Name workbookName = this.getName(workbook, commodityTypeSheet);
        workbook.setSheetHidden(workbook.getSheetIndex(commodityTypeSheet), false);
        ArrayList<String> commodityType = new ArrayList<String>();
        List<UccExtCommodityTypePo> allCommodityType = this.uccExtCommodityTypeMapper.getAllCommodityType();
        if (!CollectionUtils.isEmpty(allCommodityType)) {
            commodityType.addAll(allCommodityType.stream().map(po -> po.getCommodityTypeName() + "-" + po.getCommodityTypeId()).collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty(commodityType)) {
            this.createDropDownSheetData(style, sheet, commodityType);
        }
        this.bindDropDownBox(commodityTypeSheet, commodityType.size(), commoditySheet, workbookName, UccConstants.COMMODITY_TEMPLATE_HEAD.indexOf("*\u5546\u54c1\u7c7b\u578b"));
    }

    private void createDropDownBoxMaterialType(Workbook workbook, CellStyle style, Sheet commoditySheet) {
        String materialTypeSheet = "\u7269\u8d44\u7c7b\u578b";
        Sheet sheet = this.getSheet(workbook, materialTypeSheet);
        Name workbookName = this.getName(workbook, materialTypeSheet);
        workbook.setSheetHidden(workbook.getSheetIndex(materialTypeSheet), false);
        ArrayList<String> materialType = new ArrayList<String>();
        UccMaterialTypePO uccMaterialTypePo = new UccMaterialTypePO();
        List<UccMaterialTypePO> materialTypeList = this.uccMaterialTypeMapper.getList(uccMaterialTypePo);
        if (!CollectionUtils.isEmpty(materialTypeList)) {
            materialType.addAll(materialTypeList.stream().map(po -> po.getMaterialType() + "-" + po.getTypeId()).collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty(materialType)) {
            this.createDropDownSheetData(style, sheet, materialType);
        }
        this.bindDropDownBox(materialTypeSheet, materialType.size(), commoditySheet, workbookName, UccConstants.COMMODITY_TEMPLATE_HEAD.indexOf("*\u7269\u8d44\u7c7b\u578b"));
    }

    private void createDropDownBoxBrand(Workbook workbook, CellStyle style, Sheet commoditySheet) {
        String brandSheet = "\u54c1\u724c";
        Sheet sheet = this.getSheet(workbook, brandSheet);
        Name workbookName = this.getName(workbook, brandSheet);
        workbook.setSheetHidden(workbook.getSheetIndex(brandSheet), false);
        ArrayList<String> brand = new ArrayList<String>();
        List<UccBrandDealPO> allBrand = this.uccBrandExtMapper.getAllBrand();
        if (!CollectionUtils.isEmpty(allBrand)) {
            brand.addAll(allBrand.stream().map(po -> po.getBrandName() + "-" + po.getBrandId()).collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty(brand)) {
            this.createDropDownSheetData(style, sheet, brand);
        }
        this.bindDropDownBox(brandSheet, brand.size(), commoditySheet, workbookName, UccConstants.COMMODITY_TEMPLATE_HEAD.indexOf("*\u54c1\u724c"));
    }

    private void createDropDownBoxScene(Workbook workbook, CellStyle style, Sheet commoditySheet) {
        String sceneSheet = "\u9152\u5e97\u54c1\u724c";
        Sheet sheet = this.getSheet(workbook, sceneSheet);
        Name workbookName = this.getName(workbook, sceneSheet);
        workbook.setSheetHidden(workbook.getSheetIndex(sceneSheet), true);
        List<String> scene = Arrays.asList("1-\u573a\u666f\u4e00", "2-\u573a\u666f\u4e8c", "3-\u573a\u666f\u4e09", "4-\u573a\u666f\u56db", "5-\u573a\u666f\u4e94", "6-\u573a\u666f\u516d");
        if (!CollectionUtils.isEmpty(scene)) {
            this.createDropDownSheetData(style, sheet, scene);
        }
        this.bindDropDownBox(sceneSheet, scene.size(), commoditySheet, workbookName, UccConstants.COMMODITY_TEMPLATE_HEAD.indexOf("*\u9152\u5e97\u54c1\u724c"));
    }

    private void createDropDownSheetData(CellStyle style, Sheet sheet, List<String> dataList) {
        for (int i = 0; i < dataList.size(); ++i) {
            String data = dataList.get(i);
            sheet.setDefaultColumnStyle(i, style);
            sheet.setColumnWidth(0, 20000);
            Row row = sheet.createRow(i);
            row.setRowStyle(style);
            Cell cell = row.createCell(0, CellType.STRING);
            cell.setCellStyle(style);
            cell.setCellValue(data);
        }
    }

    private void bindDropDownBox(String hiddenSheetName, int dataLength, Sheet commoditySheet, Name workbookName, int colIndex) {
        workbookName.setRefersToFormula(hiddenSheetName + "!$A$1:$A$" + dataLength);
        CellRangeAddressList addressList = new CellRangeAddressList(2, 65535, colIndex, colIndex);
        DataValidationHelper dataValidationHelper = commoditySheet.getDataValidationHelper();
        DataValidationConstraint constraint = dataValidationHelper.createFormulaListConstraint(hiddenSheetName);
        DataValidation validation = dataValidationHelper.createValidation(constraint, addressList);
        if (validation instanceof XSSFDataValidation) {
            validation.setSuppressDropDownArrow(true);
            validation.setShowErrorBox(true);
        } else {
            validation.setSuppressDropDownArrow(false);
        }
        commoditySheet.addValidationData(validation);
    }

    private Sheet getSheet(Workbook workbook, String sheetName) {
        Sheet sheet = workbook.getSheet(sheetName);
        if (null == sheet) {
            sheet = workbook.createSheet(sheetName);
        }
        return sheet;
    }

    private Name getName(Workbook workbook, String name) {
        Name workbookName = workbook.getName(name);
        if (null == workbookName) {
            workbookName = workbook.createName();
            workbookName.setNameName(name);
        }
        return workbookName;
    }
}

