/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuOperTypeEnum;
import com.tydic.commodity.enumType.SkuSourceEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.ListUtils;
import com.tydic.commodity.util.SyncSequenceUtil;
import com.tydic.uccext.bo.UccCommodityPackageSpecBO;
import com.tydic.uccext.bo.UccCommodityPicBO;
import com.tydic.uccext.bo.UccCreateCommodityBO;
import com.tydic.uccext.bo.UccCreateCommodityBusiReqBO;
import com.tydic.uccext.bo.UccCreateCommodityBusiRspBO;
import com.tydic.uccext.bo.UccExcelTemplateImportAbilityReqBO;
import com.tydic.uccext.bo.UccExcelTemplateImportAbilityRspBO;
import com.tydic.uccext.bo.UccLadderPriceBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccCommodityExtMapper;
import com.tydic.uccext.dao.UccSceneMapper;
import com.tydic.uccext.dao.po.UccScenePO;
import com.tydic.uccext.service.UccCreateCommodityBusiService;
import com.tydic.uccext.service.UccExcelTemplateImportAbilityService;
import com.tydic.uccext.utils.ExcelUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccExcelTemplateImportAbilityService"})
public class UccExcelTemplateImportAbilityServiceImpl
implements UccExcelTemplateImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccExcelTemplateImportAbilityServiceImpl.class);
    private final Pattern numPattern = Pattern.compile("^-?[1-9]\\d*$");
    private final Pattern doublePattern = Pattern.compile("^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$");
    @Value(value="${DEFAULT_MAIN_PIC_URL}")
    private String defaultMainPicUrl;
    @Value(value="${oss.accessUrl:}")
    private String ossAccessUrl;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;
    @Autowired
    private UccSceneMapper uccSceneMapper;
    @Autowired
    private UccCreateCommodityBusiService uccCreateCommodityBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private OrderSequence uccSkuCodeSequence;

    @PostMapping(value={"dealExcelTemplateImport"})
    public UccExcelTemplateImportAbilityRspBO dealExcelTemplateImport(@RequestBody UccExcelTemplateImportAbilityReqBO reqBo) {
        this.doCheckValidReq(reqBo);
        InputStream inputStream = this.downloadFile(reqBo.getFileUrl());
        UccCreateCommodityBusiReqBO busiReq = this.doParseFile(inputStream, reqBo);
        List<String> fileCodes = busiReq.getCreateInfoList().stream().map(UccCreateCommodityBO::getCommodityCode).filter(StringUtils::hasText).collect(Collectors.toList());
        Queue<String> codeList = this.getCommodityCodeBatch(busiReq.getCreateInfoList().stream().filter(info -> !StringUtils.hasText((String)info.getCommodityCode())).collect(Collectors.toList()).size(), fileCodes);
        this.doSetCode(busiReq.getCreateInfoList(), codeList);
        UccCreateCommodityBusiRspBO busiRspBo = this.uccCreateCommodityBusiService.createCommodity(busiReq);
        if ("0000".equals(busiRspBo.getRespCode())) {
            this.syncEs(busiRspBo.getCommodityList());
        }
        UccExcelTemplateImportAbilityRspBO rspBo = new UccExcelTemplateImportAbilityRspBO();
        BeanUtils.copyProperties((Object)busiRspBo, (Object)rspBo);
        return rspBo;
    }

    @PostMapping(value={"upload"})
    public String upload(@RequestBody String filePath) {
        File file = new File(filePath);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.fileClient.uploadFileByInputStream("ucc/commodityTemplates", file.getName(), (InputStream)fileInputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void syncEs(Map<Long, List<Long>> commodityList) {
        if (!CollectionUtils.isEmpty(commodityList)) {
            commodityList.forEach((supplierShopId, commodityIdList) -> {
                Map batchList;
                if (null != supplierShopId && !CollectionUtils.isEmpty((Collection)commodityIdList) && !CollectionUtils.isEmpty((Map)(batchList = ListUtils.batchList((List)commodityIdList, (int)200)))) {
                    batchList.forEach((index, list) -> {
                        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                        syncSceneCommodityToEsReqBo.setCommodityIds(list);
                        syncSceneCommodityToEsReqBo.setSupplierId(supplierShopId);
                        syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                        syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                        syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
                    });
                }
            });
        }
    }

    private void doSetCode(List<UccCreateCommodityBO> createInfoList, Queue<String> codeList) {
        if (!CollectionUtils.isEmpty(codeList)) {
            for (UccCreateCommodityBO createCommodityBo : createInfoList) {
                if (StringUtils.hasText((String)createCommodityBo.getCommodityCode())) continue;
                createCommodityBo.setCommodityCode(codeList.poll());
            }
        }
    }

    private Queue<String> getCommodityCodeBatch(int size, List<String> fileCodes) {
        LinkedList<String> codes = new LinkedList<String>();
        HashSet<String> checkRepeatCodeList = new HashSet<String>();
        while (size > 0) {
            checkRepeatCodeList.clear();
            checkRepeatCodeList.addAll(fileCodes);
            List ids = SyncSequenceUtil.getIds((OrderSequence)this.uccSkuCodeSequence, (int)size);
            List<String> codeListReq = ids.stream().map(id -> String.format("%07d", id)).collect(Collectors.toList());
            List<String> codeCheckList = this.uccCommodityExtMapper.checkRepeatCodeByCodes(codeListReq);
            if (!CollectionUtils.isEmpty(codeCheckList)) {
                checkRepeatCodeList.addAll(codeCheckList);
            }
            checkRepeatCodeList.forEach(codeListReq::remove);
            codes.addAll(codeListReq);
            size -= codeListReq.size();
        }
        return codes;
    }

    private Map<String, Long> getSceneMap() {
        UccScenePO uccScenePo = new UccScenePO();
        List<UccScenePO> sceneList = this.uccSceneMapper.getList(uccScenePo);
        if (CollectionUtils.isEmpty(sceneList)) {
            throw new BusinessException("8888", "\u83b7\u53d6\u9152\u5e97\u54c1\u724c\u65e0\u6570\u636e\uff01");
        }
        return sceneList.stream().collect(Collectors.toMap(UccScenePO::getSceneName, UccScenePO::getSceneId, (o1, o2) -> o1));
    }

    private UccCreateCommodityBusiReqBO doParseFile(InputStream inputStream, UccExcelTemplateImportAbilityReqBO reqBo) {
        Map<String, Long> sceneMap = this.getSceneMap();
        List<Row> rows = this.getRowsFromFile(inputStream, reqBo.getFileUrl());
        if (CollectionUtils.isEmpty(rows)) {
            throw new BusinessException("8888", "\u672a\u8bfb\u53d6\u5230\u4efb\u4f55\u6587\u4ef6\u5185\u5bb9");
        }
        int index = UccConstants.COMMODITY_TEMPLATE_HEAD.indexOf("\u5546\u54c1\u7f16\u7801");
        List<String> codes = rows.stream().map(row -> {
            if (index >= 0) {
                Cell cell = row.getCell(index);
                if (null == cell) {
                    return "";
                }
                cell.setCellType(CellType.STRING);
                String cellValue = cell.getStringCellValue();
                if (StringUtils.hasText((String)cellValue)) {
                    return cellValue.trim();
                }
            }
            return "";
        }).filter(StringUtils::hasText).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(codes)) {
            Map<String, List<String>> collectCode = codes.stream().collect(Collectors.groupingBy(String::trim));
            StringJoiner sj = new StringJoiner(",", "[", "]");
            int emptyLength = sj.toString().length();
            collectCode.forEach((key, value) -> {
                if (value.size() > 1) {
                    sj.add((CharSequence)key);
                }
            });
            if (sj.toString().length() > emptyLength) {
                throw new BusinessException("8888", "\u6587\u4ef6\u4e2d\u4ee5\u4e0b\u5546\u54c1\u7f16\u7801\u91cd\u590d\u5b58\u5728\u591a\u6761\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u65b0\u5bfc\u5165\uff1a" + sj.toString());
            }
            List<String> repeatCodeByCodes = this.uccCommodityExtMapper.checkRepeatCodeByCodes(codes);
            if (!CollectionUtils.isEmpty(repeatCodeByCodes)) {
                StringJoiner sj1 = new StringJoiner(",", "[", "]");
                repeatCodeByCodes.forEach(sj1::add);
                throw new BusinessException("8888", "\u4ee5\u4e0b\u5546\u54c1\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u65b0\u5bfc\u5165\uff1a" + sj.toString());
            }
        }
        UccCreateCommodityBusiReqBO busiReqBo = new UccCreateCommodityBusiReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)busiReqBo);
        ArrayList<UccCreateCommodityBO> createInfoList = new ArrayList<UccCreateCommodityBO>(rows.size());
        busiReqBo.setCreateInfoList(createInfoList);
        busiReqBo.setOperType(SkuOperTypeEnum.IMPORT_SKU.getOperType());
        for (Row row2 : rows) {
            UccCreateCommodityBO uccCreateCommodityBo = new UccCreateCommodityBO();
            uccCreateCommodityBo.setCommoditySource(SkuSourceEnum.PROPRIETARY_SKU_SOURCE.getSource());
            uccCreateCommodityBo.setCommodityStatus(CommodityStatusEnum.EFFECTIVE_STATUS.getStatus());
            uccCreateCommodityBo.setSkuStatus(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
            createInfoList.add(uccCreateCommodityBo);
            ArrayList<UccCommodityPicBO> uccCommodityPicBoList = new ArrayList<UccCommodityPicBO>();
            UccCommodityPicBO uccCommodityPicBo = new UccCommodityPicBO();
            uccCommodityPicBo.setPicType(ModelRuleConstant.COMMD_IMG_MAIN);
            uccCommodityPicBo.setPicUrl(this.defaultMainPicUrl);
            uccCommodityPicBo.setPicOrder(Integer.valueOf(0));
            uccCommodityPicBoList.add(uccCommodityPicBo);
            uccCreateCommodityBo.setCommdImages(uccCommodityPicBoList);
            boolean notDecimal = false;
            int colNum = 0;
            String commodityType = this.checkEmpty(this.getStrTrim(row2, colNum, notDecimal), row2.getRowNum() + 1, ++colNum);
            uccCreateCommodityBo.setCommodityTypeId(this.checkCommodityType(commodityType, row2.getRowNum() + 1));
            String materialType = this.checkEmpty(this.getStrTrim(row2, colNum, notDecimal), row2.getRowNum() + 1, ++colNum);
            uccCreateCommodityBo.setMaterialId(this.checkMaterialType(materialType, row2.getRowNum() + 1));
            uccCreateCommodityBo.setCommodityName(this.checkEmpty(this.getStrTrim(row2, colNum, notDecimal), row2.getRowNum() + 1, ++colNum));
            uccCreateCommodityBo.setCommodityBanner(this.checkEmpty(this.getStrTrim(row2, colNum, notDecimal), row2.getRowNum() + 1, ++colNum));
            BigDecimal salePrice = this.checkSalePrice(this.checkEmpty(this.getStrTrim(row2, colNum, notDecimal), row2.getRowNum() + 1, ++colNum), row2.getRowNum() + 1);
            uccCreateCommodityBo.setSalePrice(salePrice);
            uccCreateCommodityBo.setMoq(this.checkCount(this.getStrTrim(row2, colNum, notDecimal), row2.getRowNum() + 1, ++colNum));
            if (null == uccCreateCommodityBo.getMoq() || 1 > uccCreateCommodityBo.getMoq()) {
                uccCreateCommodityBo.setMoq(Integer.valueOf(1));
            }
            uccCreateCommodityBo.setMaxoq(this.checkCount(this.getStrTrim(row2, colNum, notDecimal), row2.getRowNum() + 1, ++colNum));
            if (null != uccCreateCommodityBo.getMoq() && null != uccCreateCommodityBo.getMaxoq() && uccCreateCommodityBo.getMaxoq() <= uccCreateCommodityBo.getMoq()) {
                throw new BusinessException("8888", "\u7b2c" + row2.getRowNum() + 1 + "\u884c\u6700\u5927\u8d77\u8ba2\u91cf\u5fc5\u987b\u5927\u4e8e\u6700\u5c0f\u8d77\u8ba2\u91cf");
            }
            uccCreateCommodityBo.setLimitCount(this.checkCount(this.getStrTrim(row2, colNum, notDecimal), row2.getRowNum() + 1, ++colNum));
            String[] brandArr = this.checkBrand(this.checkEmpty(this.getStrTrim(row2, colNum, notDecimal), row2.getRowNum() + 1, ++colNum), row2.getRowNum() + 1);
            uccCreateCommodityBo.setBrandId(Long.valueOf(brandArr[1]));
            uccCreateCommodityBo.setBrandName(brandArr[0]);
            uccCreateCommodityBo.setMeasureName(this.checkEmpty(this.getStrTrim(row2, colNum, notDecimal), row2.getRowNum() + 1, ++colNum));
            uccCreateCommodityBo.setSceneIds(this.checkScene(this.checkEmpty(this.getStrTrim(row2, colNum, notDecimal), row2.getRowNum() + 1, ++colNum), row2.getRowNum() + 1, sceneMap));
            String detail = this.getStrTrim(row2, colNum, notDecimal);
            if (StringUtils.hasText((String)detail) && !detail.startsWith("<")) {
                detail = "<p>" + detail + "</p>";
            }
            uccCreateCommodityBo.setCommodityPcDetailChar(detail);
            uccCreateCommodityBo.setPackParam(this.getStrTrim(row2, ++colNum, notDecimal));
            uccCreateCommodityBo.setAfterService(this.getStrTrim(row2, ++colNum, notDecimal));
            UccCommodityPackageSpecBO commodityPackageSpec = new UccCommodityPackageSpecBO();
            uccCreateCommodityBo.setCommodityPackageSpec(commodityPackageSpec);
            commodityPackageSpec.setSaleUnitName(this.getStrTrim(row2, ++colNum, notDecimal));
            commodityPackageSpec.setPackageSpec(this.getStrTrim(row2, ++colNum, notDecimal));
            commodityPackageSpec.setUnitRate(this.checkUnitRate(this.getStrTrim(row2, ++colNum, notDecimal), row2.getRowNum() + 1));
            commodityPackageSpec.setSettleUnit(this.getStrTrim(row2, ++colNum, notDecimal));
            uccCreateCommodityBo.setIsShowSaleUnit(this.checkIsShowSaleUnit(commodityPackageSpec));
            commodityPackageSpec.setAgreementPrice(salePrice);
            commodityPackageSpec.setSalePrice(null == commodityPackageSpec.getUnitRate() ? salePrice : salePrice.multiply(commodityPackageSpec.getUnitRate()));
            BigDecimal salePriceForLadder = UccConstants.YesOrNo.YES.equals(uccCreateCommodityBo.getIsShowSaleUnit()) ? commodityPackageSpec.getSalePrice() : salePrice;
            List<UccLadderPriceBO> ladderPrice = this.parseLadderPrice(this.getStrTrim(row2, ++colNum, notDecimal), row2.getRowNum() + 1, salePriceForLadder);
            uccCreateCommodityBo.setLadderPrice(ladderPrice);
            uccCreateCommodityBo.setExtSkuId(this.getStrTrim(row2, ++colNum, notDecimal));
            uccCreateCommodityBo.setCommodityCode(this.getStrTrim(row2, colNum, notDecimal));
            ++colNum;
        }
        return busiReqBo;
    }

    private List<UccLadderPriceBO> parseLadderPrice(String str, int rowNum, BigDecimal salePriceForLadder) {
        int i;
        if (!StringUtils.hasText((String)str)) {
            return new ArrayList<UccLadderPriceBO>(0);
        }
        String[] ladderPriceArr = str.split("[,|\uff0c]");
        if (ladderPriceArr.length < 1) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u9636\u68af\u4ef7\u586b\u5199\u683c\u5f0f\u6709\u8bef\uff0c\u6bcf\u9636\u5fc5\u987b\u4ee5\u9017\u53f7\u5206\u9694\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\uff01");
        }
        ArrayList<UccLadderPriceBO> ladderPrice = new ArrayList<UccLadderPriceBO>(ladderPriceArr.length);
        for (i = 0; i < ladderPriceArr.length; ++i) {
            if (!StringUtils.hasText((String)ladderPriceArr[i])) {
                throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u9636\u68af\u4ef7\u7b2c" + (i + 1) + "\u9636\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
            }
            String[] eachPrice = ladderPriceArr[i].split("-");
            if (eachPrice.length < 1) {
                throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u9636\u68af\u4ef7\u7b2c" + (i + 1) + "\u9636\u586b\u5199\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\uff01");
            }
            if (!this.isInt(eachPrice[0]).booleanValue() || !this.isInt(eachPrice[1]).booleanValue() && i != ladderPriceArr.length - 1) {
                throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u9636\u68af\u4ef7\u8d77\u59cb\u6570\u91cf\u6216\u8005\u622a\u6b62\u6570\u91cf\u683c\u5f0f\u6709\u8bef\uff0c\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
            }
            if (i == ladderPriceArr.length - 1 && !"*".equals(eachPrice[1])) {
                throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u9636\u68af\u4ef7\u6700\u540e\u4e00\u9636\u622a\u6b62\u6570\u91cf\u683c\u5f0f\u6709\u8bef\uff0c\u5fc5\u987b\u586b*\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
            }
            if (!this.isInt(eachPrice[2]).booleanValue() && !this.isDouble(eachPrice[2]).booleanValue()) {
                throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u9636\u68af\u4ef7\u3010\u4ef7\u683c\u3011\u683c\u5f0f\u6709\u8bef\uff0c\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
            }
            if (i == 0 && !"1".equals(eachPrice[0])) {
                throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u9636\u68af\u4ef7\u7b2c1\u9636\u586b\u5199\u683c\u5f0f\u6709\u8bef\uff0c1\u9636\u7684\u8d77\u59cb\u6570\u91cf\u5fc5\u987b\u662f1\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\uff01");
            }
            UccLadderPriceBO uccLadderPriceBo = new UccLadderPriceBO();
            ladderPrice.add(uccLadderPriceBo);
            uccLadderPriceBo.setStart(Long.valueOf(eachPrice[0]));
            uccLadderPriceBo.setStop("*".equals(eachPrice[1]) ? null : Long.valueOf(eachPrice[1]));
            uccLadderPriceBo.setPrice(new BigDecimal(eachPrice[2]));
            uccLadderPriceBo.setDiscount(uccLadderPriceBo.getPrice().divide(salePriceForLadder, 6, RoundingMode.HALF_UP).multiply(new BigDecimal("100")));
        }
        if (((UccLadderPriceBO)ladderPrice.get(0)).getPrice().compareTo(salePriceForLadder) != 0) {
            throw new BusinessException("8888", "\u9636\u68af\u4ef7\u683c\u7b2c\u4e00\u9636\u6bb5\u7684\u4ef7\u683c\u5e94\u4e0e\u5b9e\u9645\u9500\u552e\u4ef7\u76f8\u540c");
        }
        for (i = 0; i < ladderPrice.size() - 1; ++i) {
            UccLadderPriceBO ladder = (UccLadderPriceBO)ladderPrice.get(i);
            Long start = ladder.getStop();
            Long stop = ((UccLadderPriceBO)ladderPrice.get(i + 1)).getStart();
            if (stop == start + 1L) continue;
            throw new BusinessException("8888", "\u9636\u68af\u4ef7\u683c\u6bcf\u4e00\u9636\u6bb5\u7684\u6570\u91cf\u5fc5\u987b\u5173\u8054\u8d77\u6765");
        }
        return ladderPrice;
    }

    private Integer checkIsShowSaleUnit(UccCommodityPackageSpecBO commodityPackageSpec) {
        if (StringUtils.hasText((String)commodityPackageSpec.getSaleUnitName()) && StringUtils.hasText((String)commodityPackageSpec.getPackageSpec()) && commodityPackageSpec.getUnitRate() != null) {
            return UccConstants.YesOrNo.YES;
        }
        return UccConstants.YesOrNo.NO;
    }

    private BigDecimal checkUnitRate(String unitRate, int rowNum) {
        if (!StringUtils.hasText((String)unitRate)) {
            return null;
        }
        if (!this.isDouble(unitRate).booleanValue() && !this.isInt(unitRate).booleanValue()) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u5355\u4f4d\u6362\u7b97\u503c\u683c\u5f0f\u6709\u8bef\uff0c\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
        }
        return new BigDecimal(unitRate);
    }

    private List<Long> checkScene(String scene, int rowNum, Map<String, Long> sceneMap) {
        String[] sceneArr = scene.split("[,|\uff0c]");
        if (sceneArr.length < 1) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u9152\u5e97\u54c1\u724c\u586b\u5199\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\uff01");
        }
        ArrayList<Long> sceneIdList = new ArrayList<Long>(sceneArr.length);
        for (String s : sceneArr) {
            if (!StringUtils.hasText((String)s)) continue;
            if (!sceneMap.containsKey(s)) {
                throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u65e0\u6cd5\u5339\u914d\u8be5\u9152\u5e97\u54c1\u724c\u3010" + s + "\u3011\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\uff01");
            }
            sceneIdList.add(sceneMap.get(s));
        }
        if (CollectionUtils.isEmpty(sceneIdList)) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u54c1\u724c\u6ca1\u6709\u5b9e\u9645\u503c\uff0c\u8bf7\u6838\u5b9e\u540e\u91cd\u8bd5\uff01");
        }
        return sceneIdList;
    }

    private String[] checkBrand(String brand, int rowNum) {
        String[] brandArr = brand.split("-");
        if (brandArr.length != 2) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u54c1\u724c\u683c\u5f0f\u6709\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a\u54c1\u724c\u540d\u79f0-\u54c1\u724cid\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
        }
        if (!StringUtils.hasText((String)brandArr[0])) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!this.isInt(brandArr[1]).booleanValue()) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u54c1\u724cid\u683c\u5f0f\u6709\u8bef\uff0c\u5fc5\u987b\u662f\u6b63\u6574\u6570\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
        }
        return brandArr;
    }

    private Integer checkCount(String str, int rowNum, int colNum) {
        if (StringUtils.hasText((String)str)) {
            if (!this.isInt(str).booleanValue()) {
                throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u7b2c" + colNum + "\u5217\u683c\u5f0f\u6709\u8bef\uff0c\u5fc5\u987b\u662f\u6b63\u6574\u6570\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
            }
            return Integer.valueOf(str);
        }
        return null;
    }

    private BigDecimal checkSalePrice(String salePrice, int rowNum) {
        if (!this.isDouble(salePrice).booleanValue() && !this.isInt(salePrice).booleanValue()) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u5546\u54c1\u9500\u552e\u4ef7\u683c\u5f0f\u6709\u8bef\uff0c\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
        }
        return new BigDecimal(salePrice);
    }

    private Boolean isInt(String str) {
        return this.numPattern.matcher(str).find();
    }

    private Boolean isDouble(String str) {
        return this.doublePattern.matcher(str).find();
    }

    private Long checkMaterialType(String materialType, int rowNum) {
        String[] materialTypeArr = materialType.split("-");
        if (materialTypeArr.length != 2) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u7269\u8d44\u7c7b\u578b\u683c\u5f0f\u6709\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a\u7269\u8d44\u7c7b\u578b\u540d\u79f0-\u7269\u8d44\u7c7b\u578bid\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
        }
        if (!this.isInt(materialTypeArr[1]).booleanValue()) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u7269\u8d44\u7c7b\u578bid\u683c\u5f0f\u6709\u8bef\uff0c\u5fc5\u987b\u662f\u6b63\u6574\u6570\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
        }
        return Long.valueOf(materialTypeArr[1]);
    }

    private Long checkCommodityType(String commodityType, int rowNum) {
        String[] commodityTypeArr = commodityType.split("-");
        if (commodityTypeArr.length != 2) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u5546\u54c1\u7c7b\u578b\u683c\u5f0f\u6709\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a\u5546\u54c1\u7c7b\u578b\u540d\u79f0-\u5546\u54c1\u7c7b\u578bid\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
        }
        if (!this.numPattern.matcher(commodityTypeArr[1]).find()) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u5546\u54c1\u7c7b\u578bid\u683c\u5f0f\u6709\u8bef\uff0c\u5fc5\u987b\u662f\u6b63\u6574\u6570\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
        }
        return Long.valueOf(commodityTypeArr[1]);
    }

    private String checkEmpty(String str, int rowNum, int colNum) {
        if (!StringUtils.hasText((String)str)) {
            throw new BusinessException("8888", "\u7b2c" + rowNum + "\u884c\u7b2c" + colNum + "\u5217\u6709\u7a7a\u503c\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u540e\u91cd\u8bd5\uff01");
        }
        return str;
    }

    private String getStrTrim(Row row, int i, Boolean isDecimal) {
        String cellStr = ExcelUtils.cellToString(row.getCell(i), isDecimal);
        if (!StringUtils.hasText((String)cellStr)) {
            return "";
        }
        return cellStr.trim();
    }

    private List<Row> getRowsFromFile(InputStream inputStream, String fileUrl) {
        ArrayList<HSSFRow> rows;
        String suffix = ExcelUtils.getSuffix(fileUrl);
        if (!StringUtils.isEmpty((Object)suffix)) {
            suffix = suffix.toLowerCase();
        }
        if ("xls".equals(suffix)) {
            List<HSSFRow> hssfRows = ExcelUtils.readXls(inputStream, 0, 1, 2);
            rows = new ArrayList<HSSFRow>(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List<XSSFRow> xssfRows = ExcelUtils.readXlsx(inputStream, 0, 1, 2);
            rows = new ArrayList<XSSFRow>(xssfRows);
        } else {
            throw new BusinessException("8888", "\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9,\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f\uff01");
        }
        if (CollectionUtils.isEmpty(rows)) {
            throw new BusinessException("8888", "\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        if (rows.size() > 1000) {
            throw new BusinessException("8888", "\u8d85\u8fc71000\u6761\u5546\u54c1\u4fe1\u606f\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
        }
        return rows;
    }

    private void doCheckValidReq(UccExcelTemplateImportAbilityReqBO reqBo) {
        if (reqBo == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBo.getFileUrl())) {
            throw new BusinessException("8888", "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private InputStream downloadFile(String filePath) {
        InputStream inputStream;
        if (FileType.isOss((String)this.fileType)) {
            filePath = filePath.replace(this.ossAccessUrl, "").replace(this.ossFileUrl, "").replace("https://", "").replace("http://", "");
        }
        try {
            inputStream = this.fileClient.downLoadToInputStream(filePath);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8bfb\u53d6\u4e0d\u5230\u6587\u4ef6\u3010" + filePath + "\u3011\uff01");
        }
        if (inputStream == null) {
            throw new BusinessException("8888", "\u8bfb\u53d6\u4e0d\u5230\u6587\u4ef6\u3010" + filePath + "\u3011\uff01");
        }
        return inputStream;
    }
}

