/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.po.UccEMdmCatalogPO;
import com.tydic.uccext.bo.CnncMaterialDataInfoReqBo;
import com.tydic.uccext.bo.CnncMaterialDataInfosReqBo;
import com.tydic.uccext.bo.CnncMaterialEsbDataReqBo;
import com.tydic.uccext.bo.CnncMaterialEsbReqBO;
import com.tydic.uccext.bo.UccExtCnncSyncMaterialReqBO;
import com.tydic.uccext.bo.UccExtCnncSyncMaterialRspBO;
import com.tydic.uccext.dao.CnncUccEMdmMaterialMapper;
import com.tydic.uccext.dao.po.CnncUccEMdmMaterialPo;
import com.tydic.uccext.service.UccExtCnncSyncMaterialBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccExtCnncSyncMaterialBusiServiceImpl
implements UccExtCnncSyncMaterialBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccExtCnncSyncMaterialBusiServiceImpl.class);
    @Autowired
    private CnncUccEMdmMaterialMapper cnncUccEMdmMaterialMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    private Sequence uccBrandSequence = Sequence.getInstance();

    public UccExtCnncSyncMaterialRspBO syncMaterial(UccExtCnncSyncMaterialReqBO reqBO) {
        UccExtCnncSyncMaterialRspBO rspBO = new UccExtCnncSyncMaterialRspBO();
        CnncMaterialEsbReqBO cnncMaterialEsbReqBO = reqBO.getESB();
        CnncMaterialEsbDataReqBo cnncMaterialEsbDataReqBo = cnncMaterialEsbReqBO.getDATA();
        CnncMaterialDataInfosReqBo cnncMaterialDataInfosReqBo = cnncMaterialEsbDataReqBo.getDATAINFOS();
        List cnncMaterialDataInfoReqBos = cnncMaterialDataInfosReqBo.getDATAINFO();
        ArrayList<CnncUccEMdmMaterialPo> cnncUccEMdmMaterialPos = new ArrayList<CnncUccEMdmMaterialPo>();
        for (CnncMaterialDataInfoReqBo cnncMaterialDataInfoReqBo : cnncMaterialDataInfoReqBos) {
            List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.getListByCodes((List)Lists.newArrayList((Object[])new String[]{cnncMaterialDataInfoReqBo.getCATEGORYCODE()}));
            if (CollectionUtils.isEmpty((Collection)uccEMdmCatalogPOS)) continue;
            CnncUccEMdmMaterialPo cnncUccEMdmMaterialPo = new CnncUccEMdmMaterialPo();
            cnncUccEMdmMaterialPo.setCatalogId(((UccEMdmCatalogPO)uccEMdmCatalogPOS.get(0)).getCatalogId());
            cnncUccEMdmMaterialPo.setCatalogName(cnncMaterialDataInfoReqBo.getCATEGORYNAME());
            cnncUccEMdmMaterialPo.setMaterialCode(cnncMaterialDataInfoReqBo.getCODE());
            cnncUccEMdmMaterialPo.setMaterialName(cnncMaterialDataInfoReqBo.getDESC1());
            cnncUccEMdmMaterialPo.setMeasure(cnncMaterialDataInfoReqBo.getDESC10());
            cnncUccEMdmMaterialPo.setLongDesc(cnncMaterialDataInfoReqBo.getDESCLONG());
            cnncUccEMdmMaterialPo.setShortDesc(cnncMaterialDataInfoReqBo.getDESCSHORT());
            if ("\u6b63\u5e38".equals(cnncMaterialDataInfoReqBo.getDESC20())) {
                cnncUccEMdmMaterialPo.setFreezeFlag(0);
            } else {
                cnncUccEMdmMaterialPo.setFreezeFlag(1);
            }
            cnncUccEMdmMaterialPo.setUuid(cnncMaterialDataInfoReqBo.getUUID());
            cnncUccEMdmMaterialPos.add(cnncUccEMdmMaterialPo);
        }
        Map<Integer, List<CnncUccEMdmMaterialPo>> map = this.dealGroup(cnncUccEMdmMaterialPos);
        List<CnncUccEMdmMaterialPo> insertList = map.get(0);
        List<CnncUccEMdmMaterialPo> updateList = map.get(1);
        if (!CollectionUtils.isEmpty(insertList)) {
            for (CnncUccEMdmMaterialPo cnncUccEMdmMaterialPo : insertList) {
                Long id = this.uccBrandSequence.nextId();
                cnncUccEMdmMaterialPo.setMaterialId(id);
                cnncUccEMdmMaterialPo.setSysId(id);
            }
            this.cnncUccEMdmMaterialMapper.batchInsert(insertList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            for (CnncUccEMdmMaterialPo cnncUccEMdmMaterialPo : updateList) {
                this.cnncUccEMdmMaterialMapper.updateByCode(cnncUccEMdmMaterialPo);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<Integer, List<CnncUccEMdmMaterialPo>> dealGroup(List<CnncUccEMdmMaterialPo> pos) {
        HashMap<Integer, List<CnncUccEMdmMaterialPo>> map = new HashMap<Integer, List<CnncUccEMdmMaterialPo>>();
        if (!CollectionUtils.isEmpty(pos)) {
            List<String> catalogIds = pos.stream().map(CnncUccEMdmMaterialPo::getMaterialCode).collect(Collectors.toList());
            List<String> havaCodes = this.cnncUccEMdmMaterialMapper.getListByIds(catalogIds);
            for (CnncUccEMdmMaterialPo cnncUccEMdmMaterialPo : pos) {
                ArrayList<CnncUccEMdmMaterialPo> cnncUccEMdmMaterialPos;
                if (havaCodes.contains(cnncUccEMdmMaterialPo.getMaterialCode())) {
                    if (map.containsKey(1)) {
                        ((List)map.get(1)).add(cnncUccEMdmMaterialPo);
                        continue;
                    }
                    cnncUccEMdmMaterialPos = new ArrayList<CnncUccEMdmMaterialPo>();
                    cnncUccEMdmMaterialPos.add(cnncUccEMdmMaterialPo);
                    map.put(1, cnncUccEMdmMaterialPos);
                    continue;
                }
                if (map.containsKey(0)) {
                    ((List)map.get(0)).add(cnncUccEMdmMaterialPo);
                    continue;
                }
                cnncUccEMdmMaterialPos = new ArrayList();
                cnncUccEMdmMaterialPos.add(cnncUccEMdmMaterialPo);
                map.put(0, cnncUccEMdmMaterialPos);
            }
        }
        return map;
    }
}

