/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccCommodityUpReqBO;
import com.tydic.commodity.bo.busi.UccCommodityUpRspBO;
import com.tydic.commodity.busi.api.UccCommodityUpBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.uccext.bo.UccExtCommodityUpAbilityReqBO;
import com.tydic.uccext.bo.UccExtCommodityUpAbilityRspBO;
import com.tydic.uccext.dao.UccRelSkuSupskuMapper;
import com.tydic.uccext.dao.po.UccSkuSupplyInfoPO;
import com.tydic.uccext.service.UccExtCommodityUpAbilityService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccExtCommodityUpAbilityService"})
public class UccExtCommodityUpAbilityServiceImpl
implements UccExtCommodityUpAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccRelSkuSupskuMapper uccRelSkuSupskuMapper;
    @Autowired
    private UccCommodityUpBusiService uccCommodityUpBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealCommodityUp"})
    public UccExtCommodityUpAbilityRspBO dealCommodityUp(@RequestBody UccExtCommodityUpAbilityReqBO reqBo) {
        UccExtCommodityUpAbilityRspBO rspBo = new UccExtCommodityUpAbilityRspBO();
        if (null == reqBo || CollectionUtils.isEmpty((Collection)reqBo.getSkuIds()) || null == reqBo.getSupplierShopId()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5355\u54c1ID\u5217\u8868\u3001\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        int checkSkuStatus = this.uccSkuMapper.checkSkuStatus(reqBo.getSupplierShopId(), null, reqBo.getSkuIds(), Collections.singletonList(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus()));
        if (checkSkuStatus != new HashSet(reqBo.getSkuIds()).size()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u53ea\u5141\u8bb8\u4e0a\u67b6\u72b6\u6001\u4e3a[\u4e0b\u67b6\u4e2d]\u7684\u5546\u54c1");
            return rspBo;
        }
        HashSet skuIds = new HashSet();
        List<UccSkuSupplyInfoPO> supListBySku = this.uccRelSkuSupskuMapper.getSupListBySku(reqBo.getSkuIds());
        if (!CollectionUtils.isEmpty(supListBySku)) {
            skuIds.addAll(supListBySku.stream().map(UccSkuSupplyInfoPO::getSkuId).collect(Collectors.toSet()));
        }
        if (skuIds.size() != new HashSet(reqBo.getSkuIds()).size()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u53ea\u5141\u8bb8\u4e0a\u67b6\u5df2\u6709\u4f9b\u8d27\u7684\u5546\u54c1");
            return rspBo;
        }
        UccCommodityUpReqBO uccCommodityUpReqBo = new UccCommodityUpReqBO();
        uccCommodityUpReqBo.setPreUpTime(reqBo.getPreUpTime());
        uccCommodityUpReqBo.setUpType(reqBo.getUpType());
        uccCommodityUpReqBo.setPreDownTime(reqBo.getPreDownTime());
        uccCommodityUpReqBo.setSupplierShopId(reqBo.getSupplierShopId());
        uccCommodityUpReqBo.setCreateOperId(StringUtils.hasText((String)reqBo.getCreateOperId()) ? reqBo.getCreateOperId() : reqBo.getUsername());
        uccCommodityUpReqBo.setCreateTime(new Date());
        uccCommodityUpReqBo.setRemark(reqBo.getRemark());
        uccCommodityUpReqBo.setSkuIds(reqBo.getSkuIds());
        UccCommodityUpRspBO uccCommodityUpRspBo = this.uccCommodityUpBusiService.dealCommodityUp(uccCommodityUpReqBo);
        BeanUtils.copyProperties((Object)uccCommodityUpRspBo, (Object)rspBo);
        if ("0000".equals(rspBo.getRespCode())) {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBo.setSkuIds(reqBo.getSkuIds());
            syncSceneCommodityToEsReqBo.setSupplierId(reqBo.getSupplierShopId());
            syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
            syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
        }
        return rspBo;
    }
}

