/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.ability.api.SearchBarEsAbilityService;
import com.tydic.commodity.bo.ability.SearchBarEsReqBO;
import com.tydic.commodity.bo.ability.SearchBarEsRspBO;
import com.tydic.commodity.bo.ability.UccSourceTypeBo;
import com.tydic.commodity.bo.busi.OrderColumBo;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.uccext.bo.OrgCacheBo;
import com.tydic.uccext.bo.UccExtSearchBarEsReqBO;
import com.tydic.uccext.bo.UccExtSearchBarEsRspBO;
import com.tydic.uccext.bo.UccSearchOrderConfigBO;
import com.tydic.uccext.service.UccExtSearchBarEsAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccExtSearchBarEsAbilityService"})
public class UccExtSearchBarEsAbilityServiceImpl
implements UccExtSearchBarEsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccExtSearchBarEsAbilityServiceImpl.class);
    @Autowired
    private SearchBarEsAbilityService searchBarEsAbilityService;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"qryBySearchBar"})
    public UccExtSearchBarEsRspBO qryBySearchBar(@RequestBody UccExtSearchBarEsReqBO reqBO) {
        Object obj;
        UccExtSearchBarEsRspBO uccExtSearchBarEsRspBO = new UccExtSearchBarEsRspBO();
        String orgPath = reqBO.getOrgPath();
        if (StringUtils.isEmpty((Object)orgPath)) {
            log.error("orgId = " + reqBO.getOrgIdIn() + "\u5f53\u524d\u7528\u6237\u673a\u6784\u6811\u4e3a\u7a7a");
        }
        OrgCacheBo limitGui = null;
        if (!StringUtils.isEmpty((Object)reqBO.getOrgPath())) {
            limitGui = this.searchLimitGui(orgPath);
        }
        log.info("\u5546\u54c1\u641c\u7d22\u6392\u9664\u7684\u9650\u552e\u5546\u54c1\uff1a" + JSONObject.toJSONString((Object)limitGui));
        SearchBarEsReqBO searchBarEsReqBO = new SearchBarEsReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)searchBarEsReqBO);
        if (reqBO.getSkuStatus() == null || reqBO.getSkuStatus().size() == 0) {
            ArrayList<Integer> skuStatus = new ArrayList<Integer>();
            skuStatus.add(ModelRuleConstant.SKU_STATUS_ON_SHELF);
            reqBO.setSkuStatus(skuStatus);
        }
        SearchBarEsReqBO searchEsReqBO = new SearchBarEsReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)searchEsReqBO);
        if (reqBO.getTypeId() != null) {
            searchEsReqBO.setTypeId(reqBO.getTypeId());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTypeName())) {
            searchEsReqBO.setTypeName(reqBO.getTypeName());
        }
        if (limitGui != null) {
            if (!CollectionUtils.isEmpty((Collection)limitGui.getIgnoreList())) {
                searchEsReqBO.setIgnoreList(limitGui.getIgnoreList());
            }
            obj = this.cacheClient.get("UCC_COMMODITY_TYPE_ALL");
            List typeListCache = new ArrayList();
            if (obj != null) {
                typeListCache = JSONObject.parseArray((String)JSONObject.toJSONString((Object)obj), Long.class);
            }
            if (!CollectionUtils.isEmpty((Collection)limitGui.getIgSourceTypeBoList())) {
                ArrayList<UccSourceTypeBo> typeBoList = new ArrayList<UccSourceTypeBo>();
                for (UccSourceTypeBo uccSourceTypeBo : limitGui.getIgSourceTypeBoList()) {
                    UccSourceTypeBo uccSourceTypeBo2 = new UccSourceTypeBo();
                    typeBoList.add(uccSourceTypeBo2);
                    uccSourceTypeBo2.setSkuSource(uccSourceTypeBo.getSkuSource());
                    if (CollectionUtils.isEmpty(typeListCache) || CollectionUtils.isEmpty((Collection)uccSourceTypeBo.getType())) continue;
                    ArrayList allTpye = new ArrayList(typeListCache);
                    allTpye.removeAll(uccSourceTypeBo.getType());
                    uccSourceTypeBo2.setType(allTpye);
                }
                searchEsReqBO.setSearchTypeList(typeBoList);
            }
        }
        if ((obj = this.cacheClient.get("UCC_SKU_SEARCH_ORDER_CONFIG")) != null) {
            List<UccSearchOrderConfigBO> searchOrderConfigBoList = new ArrayList();
            try {
                searchOrderConfigBoList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)obj), UccSearchOrderConfigBO.class);
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38 \uff1a\u5546\u54c1\u6392\u5e8f\u8f6c\u6362\u5f02\u5e38" + JSONObject.toJSONString((Object)reqBO));
            }
            if (!CollectionUtils.isEmpty(searchOrderConfigBoList)) {
                searchOrderConfigBoList.sort(Comparator.comparing(UccSearchOrderConfigBO::getId));
                ArrayList<OrderColumBo> orderColum = new ArrayList<OrderColumBo>();
                for (UccSearchOrderConfigBO uccSearchOrderConfigBO : searchOrderConfigBoList) {
                    if (uccSearchOrderConfigBO.getStatus() != 1L) continue;
                    OrderColumBo bo = new OrderColumBo();
                    bo.setOrderByColumn(uccSearchOrderConfigBO.getColName());
                    bo.setOrderType(Integer.valueOf(uccSearchOrderConfigBO.getType().intValue()));
                    orderColum.add(bo);
                }
                searchEsReqBO.setOrderColum(orderColum);
            }
        }
        SearchBarEsRspBO searchBarEsRspBO = this.searchBarEsAbilityService.qryBySearchBar(searchEsReqBO);
        BeanUtils.copyProperties((Object)searchBarEsRspBO, (Object)uccExtSearchBarEsRspBO);
        return uccExtSearchBarEsRspBO;
    }

    public OrgCacheBo searchLimitGui(String orgPath) {
        OrgCacheBo resultBo = new OrgCacheBo();
        ArrayList igSkuList = new ArrayList();
        if (StringUtils.isEmpty((Object)orgPath)) {
            return null;
        }
        String[] orgPathList = orgPath.split("-");
        HashedMap igListMap = new HashedMap();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < orgPathList.length; ++i) {
            if (StringUtils.isEmpty((Object)sb.toString())) {
                sb.append("ORG_PATH_LIMIT_SALE_TYPE");
            }
            String sb1 = sb.append(orgPathList[i]).append("-").toString();
            Object object = this.cacheClient.get(sb1);
            log.info("\u83b7\u53d6\u5230\u7f13\u5b58:\u7f13\u5b58\u540d\uff1a" + sb1 + "\u5185\u5bb9\uff1a" + JSONObject.toJSONString((Object)object));
            if (object == null) continue;
            OrgCacheBo bo = (OrgCacheBo)JSONObject.toJavaObject((JSON)JSON.parseObject((String)JSONObject.toJSONString((Object)object)), OrgCacheBo.class);
            if (!CollectionUtils.isEmpty((Collection)bo.getIgnoreList())) {
                igSkuList.addAll(bo.getIgnoreList());
            }
            if (CollectionUtils.isEmpty((Collection)bo.getIgSourceTypeBoList())) continue;
            for (UccSourceTypeBo each : bo.getIgSourceTypeBoList()) {
                if (!igListMap.containsKey(each.getSkuSource())) {
                    List getType = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)each.getType())) {
                        getType = each.getType();
                    }
                    igListMap.put(each.getSkuSource(), getType);
                    continue;
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)igListMap.get(each.getSkuSource())))) {
                    ((List)igListMap.get(each.getSkuSource())).addAll(each.getType());
                    continue;
                }
                igListMap.put(each.getSkuSource(), each.getType());
            }
        }
        resultBo.setIgnoreList(igSkuList);
        Iterator entries = igListMap.entrySet().iterator();
        ArrayList<UccSourceTypeBo> uccSourceTypeBoList = new ArrayList<UccSourceTypeBo>();
        while (entries.hasNext()) {
            UccSourceTypeBo uccSourceTypeBo = new UccSourceTypeBo();
            Map.Entry entry = entries.next();
            uccSourceTypeBo.setType((List)entry.getValue());
            uccSourceTypeBo.setSkuSource((Integer)entry.getKey());
            uccSourceTypeBoList.add(uccSourceTypeBo);
        }
        resultBo.setIgSourceTypeBoList(uccSourceTypeBoList);
        resultBo.setOrgPath(orgPath);
        return resultBo;
    }
}

