/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.atom.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.bo.busi.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uac.config.ProperticeVo;
import com.tydic.uccext.bo.SyncSceneCommodityToEsExtReqBO;
import com.tydic.uccext.bo.SyncSceneCommodityToEsRspBO;
import com.tydic.uccext.bo.UccGoodsIssueDeleteAbilityReqBO;
import com.tydic.uccext.bo.UccGoodsIssueDeleteAbilityRspBO;
import com.tydic.uccext.dao.UccCommodityExtMapper;
import com.tydic.uccext.service.UccGoodsIssueDeleteAbilityService;
import com.tydic.uccext.service.UccSyncSceneCommodityToEsAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccGoodsIssueDeleteAbilityService"})
public class UccGoodsIssueDeleteAbilityServiceImpl
implements UccGoodsIssueDeleteAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private UccSyncSceneCommodityToEsAbilityService uccSyncSceneCommodityToEsAbilityService;
    @Autowired
    private ProperticeVo properticeVo;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccGoodsIssueDeleteAbilityServiceImpl.class);

    @PostMapping(value={"dealUccGoodsIssueDelete"})
    public UccGoodsIssueDeleteAbilityRspBO dealUccGoodsIssueDelete(@RequestBody UccGoodsIssueDeleteAbilityReqBO reqBO) {
        UccGoodsIssueDeleteAbilityRspBO rspBO = new UccGoodsIssueDeleteAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u6237ID");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5355\u54c1ID");
            return rspBO;
        }
        List supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isNotEmpty((Collection)supplierShopPos)) {
            reqBO.setSupplierShopId(((SupplierShopPo)supplierShopPos.get(0)).getSupplierShopId());
        }
        List<UccSkuPo> uccSkuPos = new ArrayList();
        try {
            uccSkuPos = this.uccSkuMapper.batchQrySku(reqBO.getSkuIds(), reqBO.getSupplierShopId());
            if (CollectionUtils.isEmpty(uccSkuPos)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6709\u6548\u5355\u54c1ID");
                return rspBO;
            }
            ArrayList<Long> failIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(uccSkuPos)) {
                for (UccSkuPo uccSkuPo : uccSkuPos) {
                    if (uccSkuPo.getSkuStatus().equals(SkuStatusEnum.DRAFT_STATUS.getStatus())) continue;
                    failIds.add(uccSkuPo.getSkuId());
                }
            }
            if (failIds.size() > 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5546\u54c1" + ((Object)failIds).toString() + "\u4e0d\u4e3a\u8349\u7a3f\u72b6\u6001");
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty(uccSkuPos)) {
            SyncSceneCommodityToEsExtReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsExtReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList((Iterable)reqBO.getSkuIds()));
            syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierShopId());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
            LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            try {
                try {
                    SyncSceneCommodityToEsRspBO syncSceneCommodityToEsRspBO = this.uccSyncSceneCommodityToEsAbilityService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                    if (!"0000".equals(syncSceneCommodityToEsRspBO.getRespCode())) {
                        LOGGER.error("\u5546\u54c1\u5220\u9664\u540c\u6b65" + syncSceneCommodityToEsRspBO.getRespDesc());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u5546\u54c1\u5220\u9664\u540c\u6b65" + e.getMessage());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u53d1\u5e03\u5220\u9664\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty(uccSkuPos)) {
            try {
                this.deleteData(uccSkuPos);
            }
            catch (ZTBusinessException e) {
                throw new BusinessException("8888", e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(uccSkuPos)) {
            List agreementDetailsId = uccSkuPos.stream().filter(poList -> poList.getAgreementDetailsId() != null).map(UccSkuPo::getAgreementDetailsId).collect(Collectors.toList());
            List agreementDetailsIds = agreementDetailsId.stream().map(a -> String.valueOf(a)).collect(Collectors.toList());
            UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
            try {
                notifyMessageBO.setAgreementId(String.valueOf(uccSkuPos.get(0).getAgreementId()));
                notifyMessageBO.setAgreementSkuIds(agreementDetailsIds);
                notifyMessageBO.setAgreementSkuStatus("20");
                notifyMessageBO.setMemIdIn(reqBO.getUserId());
                notifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_UP_SHELF.code());
                LOGGER.info("\u53d1\u5e03\u5220\u9664\u5546\u54c1\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
                this.zoneGoodsAuditMQ.send(new ProxyMessage(this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TOPIC"), this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
            }
            catch (Exception var16) {
                LOGGER.error("\u53d1\u5e03\u5220\u9664\uff0c\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
                throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
            }
        }
        return rspBO;
    }

    void deleteData(List<UccSkuPo> uccSkuPos) {
        LOGGER.info("\u5546\u54c1\u53d1\u5e03\u5220\u9664\u5546\u54c1\u6570\u636e\uff1a" + JSONObject.toJSONString(uccSkuPos));
        for (UccSkuPo po : uccSkuPos) {
            try {
                this.uccCommodityExtMapper.deleteDataByCommodityId(po.getCommodityId());
                this.uccSkuMapper.deleteSkuBySkuId(po);
                UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
                uccLadderPricePO.setSkuId(po.getSkuId());
                uccLadderPricePO.setSupplierShopId(po.getSupplierShopId());
                this.uccLadderPriceMapper.deleteByExample(uccLadderPricePO);
                UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
                uccSkuPricePo.setSkuId(po.getSkuId());
                uccSkuPricePo.setSupplierShopId(po.getSupplierShopId());
                this.uccSkuPriceMapper.deleteSkuPriceBySkuId(uccSkuPricePo);
            }
            catch (Exception e) {
                LOGGER.error("\u5220\u9664\u6570\u636e\u5931\u8d25\uff1a " + e.getMessage());
                throw new ZTBusinessException("\u5220\u9664\u6570\u636e\u5931\u8d25\uff1a " + e.getMessage());
            }
        }
    }
}

