/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.uccext.bo.UccOrgCatalogCandidateListBO;
import com.tydic.uccext.bo.UccOrgCategoryCandidateListQryReqBO;
import com.tydic.uccext.bo.UccOrgCategoryCandidateListQryRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccGuideCatalogExtMapper;
import com.tydic.uccext.dao.UccOrgGuideCatalogSalesRestrictionMapper;
import com.tydic.uccext.dao.po.UccOrgGuideCatalogSalesRestrictionPO;
import com.tydic.uccext.service.UccOrgCategoryCandidateListQryAbilityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccOrgCategoryCandidateListQryAbilityService"})
public class UccOrgCategoryCandidateListQryAbilityServiceImpl
implements UccOrgCategoryCandidateListQryAbilityService {
    @Autowired
    private UccOrgGuideCatalogSalesRestrictionMapper uccOrgGuideCatalogSalesRestrictionMapper;
    @Autowired
    private UccGuideCatalogExtMapper uccGuideCatalogExtMapper;

    @PostMapping(value={"getOrgCategoryCandidateListQry"})
    public UccOrgCategoryCandidateListQryRspBO getOrgCategoryCandidateListQry(@RequestBody UccOrgCategoryCandidateListQryReqBO reqBo) {
        List<Long> orgGuideCatalogSalesRestrictionList;
        List<UccOrgCatalogCandidateListBO> notRestrictionCatalog;
        UccOrgCategoryCandidateListQryRspBO rspBo = new UccOrgCategoryCandidateListQryRspBO();
        rspBo.setRespCode("8888");
        if (null == reqBo || null == reqBo.getOrgId() || null == reqBo.getAuthType() || null == reqBo.getChannelId() || !StringUtils.hasText((String)reqBo.getOrgPath())) {
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u673a\u6784ID/\u7528\u6237ID\u3001\u6240\u5c5e\u673a\u6784\u5168\u8def\u5f84\u3001\u9891\u9053ID\u3001\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        UccConstants.CatalogSaleRestrictionAuthType catalogSaleRestrictionAuthType = UccConstants.CatalogSaleRestrictionAuthType.find(reqBo.getAuthType());
        if (null == catalogSaleRestrictionAuthType) {
            rspBo.setRespDesc("\u672a\u77e5\u7684\u6743\u9650\u7c7b\u578b");
            return rspBo;
        }
        ArrayList<UccOrgCatalogCandidateListBO> uccOrgCatalogListBoList = new ArrayList<UccOrgCatalogCandidateListBO>();
        if (catalogSaleRestrictionAuthType.getAuthType() == UccConstants.CatalogSaleRestrictionAuthType.USER_CAN_PURCHASE_CATALOG.getAuthType()) {
            reqBo.setOrgPath(reqBo.getOrgId().toString());
        }
        if (!CollectionUtils.isEmpty(notRestrictionCatalog = this.getNotRestrictionCatalog(orgGuideCatalogSalesRestrictionList = this.getRestrictionL3Catalog(reqBo.getOrgId(), reqBo.getChannelId(), reqBo.getOrgPath()), reqBo.getCatalogName(), reqBo.getChannelId()))) {
            uccOrgCatalogListBoList.addAll(notRestrictionCatalog);
        }
        rspBo.setRows(uccOrgCatalogListBoList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<Long> getRestrictionL3Catalog(Long orgId, Long channelId, String orgPath) {
        ArrayList<Long> uccOrgGuideCatalogSalesRestrictionList = new ArrayList<Long>();
        if (!StringUtils.hasText((String)orgPath)) {
            orgPath = this.uccOrgGuideCatalogSalesRestrictionMapper.getOrgPath(orgId, null, UccConstants.Status.VALID, channelId);
        }
        if (StringUtils.hasText((String)orgPath)) {
            List<UccOrgGuideCatalogSalesRestrictionPO> uccOrgGuideCatalogSalesRestrictionPoList;
            List<Long> orgList = Arrays.stream(orgPath.split("-")).map(Long::new).collect(Collectors.toList());
            orgList.add(orgId);
            if (!CollectionUtils.isEmpty(orgList) && !CollectionUtils.isEmpty(uccOrgGuideCatalogSalesRestrictionPoList = this.uccOrgGuideCatalogSalesRestrictionMapper.getListByOrgIdList(orgList, null, UccConstants.Status.VALID, channelId))) {
                uccOrgGuideCatalogSalesRestrictionList.addAll(uccOrgGuideCatalogSalesRestrictionPoList.stream().map(UccOrgGuideCatalogSalesRestrictionPO::getGuideCatalogIdL3).collect(Collectors.toList()));
            }
        }
        return uccOrgGuideCatalogSalesRestrictionList;
    }

    private List<UccOrgCatalogCandidateListBO> getNotRestrictionCatalog(List<Long> orgGuideCatalogSalesRestrictionList, String catalogName, Long channelId) {
        return this.uccGuideCatalogExtMapper.getGuideCatalogTreeInfo(orgGuideCatalogSalesRestrictionList, UccConstants.Status.VALID, catalogName, channelId);
    }
}

