/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import com.tydic.uccext.bo.UccOrgCatalogListBO;
import com.tydic.uccext.bo.UccOrgCategoryListQryReqBO;
import com.tydic.uccext.bo.UccOrgCategoryListQryRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccGuideCatalogExtMapper;
import com.tydic.uccext.dao.UccOrgGuideCatalogSalesRestrictionMapper;
import com.tydic.uccext.dao.po.UccOrgGuideCatalogSalesRestrictionPO;
import com.tydic.uccext.service.UccOrgCategoryListQryAbilityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccOrgCategoryListQryAbilityService"})
public class UccOrgCategoryListQryAbilityServiceImpl
implements UccOrgCategoryListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccOrgCategoryListQryAbilityServiceImpl.class);
    @Autowired
    private UccOrgGuideCatalogSalesRestrictionMapper uccOrgGuideCatalogSalesRestrictionMapper;
    @Autowired
    private UccGuideCatalogExtMapper uccGuideCatalogExtMapper;

    @PostMapping(value={"getUccOrgCategoryList"})
    public UccOrgCategoryListQryRspBO getUccOrgCategoryList(@RequestBody UccOrgCategoryListQryReqBO reqBO) {
        Object orgList;
        UccOrgCategoryListQryRspBO rspBO = new UccOrgCategoryListQryRspBO();
        ArrayList<UccOrgCatalogListBO> uccOrgCatalogListBOS = new ArrayList<UccOrgCatalogListBO>();
        if (StringUtils.isEmpty((Object)reqBO.getOrgPath())) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u673a\u6784\u5168\u8def\u5f84");
        }
        if (reqBO.getFlag() != null && reqBO.getFlag() == 1 && reqBO.getOrgId() != null) {
            reqBO.setOrgPath(reqBO.getOrgId().toString());
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<Object> uccOrgGuideCatalogSalesRestrictionPoList = new ArrayList();
        String orgPath = reqBO.getOrgPath();
        if (reqBO.getAuthType() == UccConstants.CatalogSaleRestrictionAuthType.USER_CAN_PURCHASE_CATALOG.getAuthType().intValue()) {
            orgPath = String.valueOf(reqBO.getOrgId());
        }
        if (StringUtils.hasText((String)orgPath) && !CollectionUtils.isEmpty((Collection)(orgList = Arrays.stream(orgPath.split("-")).map(Long::new).collect(Collectors.toList())))) {
            uccOrgGuideCatalogSalesRestrictionPoList = this.uccOrgGuideCatalogSalesRestrictionMapper.getListByOrgIdListCopy(page, (List<Long>)orgList, reqBO.getAuthType(), UccConstants.Status.VALID, reqBO.getChannelId(), reqBO.getCatalogName());
        }
        if (!CollectionUtils.isEmpty(uccOrgGuideCatalogSalesRestrictionPoList)) {
            for (UccOrgGuideCatalogSalesRestrictionPO uccOrgGuideCatalogSalesRestrictionPO1 : uccOrgGuideCatalogSalesRestrictionPoList) {
                UccOrgCatalogListBO uccOrgCatalogListBO = new UccOrgCatalogListBO();
                uccOrgCatalogListBO.setCatalogIdLv1Name(uccOrgGuideCatalogSalesRestrictionPO1.getCatalogNameL1());
                uccOrgCatalogListBO.setCatalogIdLv2Name(uccOrgGuideCatalogSalesRestrictionPO1.getCatalogNameL2());
                uccOrgCatalogListBO.setCatalogIdLv3Name(uccOrgGuideCatalogSalesRestrictionPO1.getCatalogNameL3());
                uccOrgCatalogListBO.setCatalogIdLv1Id(uccOrgGuideCatalogSalesRestrictionPO1.getGuideCatalogIdL1());
                uccOrgCatalogListBO.setCatalogIdLv2Id(uccOrgGuideCatalogSalesRestrictionPO1.getGuideCatalogIdL2());
                uccOrgCatalogListBO.setCatalogIdLv3Id(uccOrgGuideCatalogSalesRestrictionPO1.getGuideCatalogIdL3());
                uccOrgCatalogListBOS.add(uccOrgCatalogListBO);
            }
        }
        this.dealFlag(uccOrgCatalogListBOS, reqBO.getOrgId());
        rspBO.setRows(uccOrgCatalogListBOS);
        UccOrgGuideCatalogSalesRestrictionPO uccOrgGuideCatalogSalesRestrictionPO1 = new UccOrgGuideCatalogSalesRestrictionPO();
        uccOrgGuideCatalogSalesRestrictionPO1.setRestrictionType(Long.valueOf(reqBO.getAuthType()));
        uccOrgGuideCatalogSalesRestrictionPO1.setOrderBy("UPDATE_TIME DESC");
        List<UccOrgGuideCatalogSalesRestrictionPO> uccOrgGuideCatalogSalesRestrictionPOList = this.uccOrgGuideCatalogSalesRestrictionMapper.getList(uccOrgGuideCatalogSalesRestrictionPO1);
        uccOrgGuideCatalogSalesRestrictionPO1.setOrderBy("CREATE_TIME DESC");
        List<UccOrgGuideCatalogSalesRestrictionPO> uccOrgGuideCatalogSalesRestrictionPOList1 = this.uccOrgGuideCatalogSalesRestrictionMapper.getList(uccOrgGuideCatalogSalesRestrictionPO1);
        if (!CollectionUtils.isEmpty(uccOrgGuideCatalogSalesRestrictionPOList1) && uccOrgGuideCatalogSalesRestrictionPOList1.get(0).getCreateTime() != null) {
            if (uccOrgGuideCatalogSalesRestrictionPOList.get(0).getUpdateTime() != null) {
                if (uccOrgGuideCatalogSalesRestrictionPOList1.get(0).getCreateTime().before(uccOrgGuideCatalogSalesRestrictionPOList.get(0).getUpdateTime())) {
                    rspBO.setLastUpdateTime(DateUtils.dateToStr((Date)uccOrgGuideCatalogSalesRestrictionPOList.get(0).getUpdateTime()));
                    rspBO.setLastUpdateUserId(uccOrgGuideCatalogSalesRestrictionPOList.get(0).getUpdateOperId());
                } else {
                    rspBO.setLastUpdateTime(DateUtils.dateToStr((Date)uccOrgGuideCatalogSalesRestrictionPOList1.get(0).getCreateTime()));
                    rspBO.setLastUpdateUserId(uccOrgGuideCatalogSalesRestrictionPOList1.get(0).getCreateOperId());
                }
            } else {
                rspBO.setLastUpdateTime(DateUtils.dateToStr((Date)uccOrgGuideCatalogSalesRestrictionPOList1.get(0).getCreateTime()));
                rspBO.setLastUpdateUserId(uccOrgGuideCatalogSalesRestrictionPOList1.get(0).getCreateOperId());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    private void dealFlag(List<UccOrgCatalogListBO> bos, Long orgId) {
        if (!CollectionUtils.isEmpty(bos) && orgId != null) {
            List<Long> catalogIds = bos.stream().map(UccOrgCatalogListBO::getCatalogIdLv3Id).collect(Collectors.toList());
            List<Long> havCatalogIds = this.uccOrgGuideCatalogSalesRestrictionMapper.getListByIds(catalogIds, UccConstants.CatalogSaleRestrictionAuthType.ORG_SALE_RESTRICTION_CATALOG.getAuthType(), orgId, UccConstants.Status.VALID);
            for (UccOrgCatalogListBO bo : bos) {
                if (!CollectionUtils.isEmpty(havCatalogIds)) {
                    if (havCatalogIds.contains(bo.getCatalogIdLv3Id())) {
                        bo.setFlag(UccConstants.OrgFlag.oneSlefLevel);
                        continue;
                    }
                    bo.setFlag(UccConstants.OrgFlag.notOneSlefLevel);
                    continue;
                }
                bo.setFlag(UccConstants.OrgFlag.notOneSlefLevel);
            }
        }
    }
}

