/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.util.ListUtils;
import com.tydic.uccext.bo.UccOrgSkuCandidateListQryReqBO;
import com.tydic.uccext.bo.UccOrgSkuCandidateListQryRspBO;
import com.tydic.uccext.bo.UccOrgSkuListBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccCommodityExtMapper;
import com.tydic.uccext.dao.UccOrgGuideCatalogSalesRestrictionMapper;
import com.tydic.uccext.dao.UccOrgSkuSalesRestrictionMapper;
import com.tydic.uccext.service.UccOrgSkuCandidateListQryAbilityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccOrgSkuCandidateListQryAbilityService"})
public class UccOrgSkuCandidateListQryAbilityServiceImpl
implements UccOrgSkuCandidateListQryAbilityService {
    @Autowired
    private UccOrgSkuSalesRestrictionMapper uccOrgSkuSalesRestrictionMapper;
    @Autowired
    private UccOrgGuideCatalogSalesRestrictionMapper uccOrgGuideCatalogSalesRestrictionMapper;
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;

    @PostMapping(value={"getOrgSkuCandidateListQry"})
    public UccOrgSkuCandidateListQryRspBO getOrgSkuCandidateListQry(@RequestBody UccOrgSkuCandidateListQryReqBO reqBo) {
        UccOrgSkuCandidateListQryRspBO rspBo = new UccOrgSkuCandidateListQryRspBO();
        rspBo.setRespCode("8888");
        if (null == reqBo || null == reqBo.getOrgId() || null == reqBo.getAuthType() || !StringUtils.hasText((String)reqBo.getOrgPath()) || null == reqBo.getChannelId()) {
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u673a\u6784ID\u3001\u6240\u5c5e\u673a\u6784\u5168\u8def\u5f84\u3001\u6743\u9650\u7c7b\u578b\u3001\u9891\u9053ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        UccConstants.SkuSaleRestrictionAuthType skuSaleRestrictionAuthType = UccConstants.SkuSaleRestrictionAuthType.find(reqBo.getAuthType());
        if (null == skuSaleRestrictionAuthType) {
            rspBo.setRespDesc("\u672a\u77e5\u7684\u6743\u9650\u7c7b\u578b");
            return rspBo;
        }
        if (0 > reqBo.getPageNo()) {
            reqBo.setPageNo(1);
        }
        if (0 > reqBo.getPageSize()) {
            reqBo.setPageSize(50);
        }
        ArrayList<UccOrgSkuListBO> orgSkuList = new ArrayList<UccOrgSkuListBO>();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List<Long> commodityTypeIdList = this.getComTypeIdList(reqBo.getOrgId(), reqBo.getChannelId(), reqBo.getOrgPath(), UccConstants.CatalogSaleRestrictionAuthType.ORG_SALE_RESTRICTION_CATALOG.getRestrictionType());
        List<Long> skuIdList = this.getSkuIdList(reqBo.getOrgId(), skuSaleRestrictionAuthType.getSkuSource());
        List commodityTypeIdList1 = ListUtils.removeNull(commodityTypeIdList);
        List<UccOrgSkuListBO> skuList = this.getOrgSkuList(reqBo, skuSaleRestrictionAuthType.getSkuSource(), commodityTypeIdList1, skuIdList, (Page<UccOrgSkuListBO>)page);
        if (!CollectionUtils.isEmpty(skuList)) {
            orgSkuList.addAll(skuList);
        }
        rspBo.setRows(orgSkuList);
        rspBo.setPageNo(page.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<Long> getComTypeIdList(Long orgId, Long channelId, String orgPath, Integer restrictionType) {
        List<Long> comTypeIdList;
        List<Long> orgIdList;
        ArrayList<Long> commodityTypeIdList = new ArrayList<Long>();
        if (!StringUtils.hasText((String)orgPath)) {
            orgPath = this.uccOrgGuideCatalogSalesRestrictionMapper.getOrgPath(orgId, restrictionType, UccConstants.Status.VALID, channelId);
        }
        if (StringUtils.hasText((String)orgPath) && !CollectionUtils.isEmpty(orgIdList = Arrays.stream(orgPath.split("-")).map(Long::new).collect(Collectors.toList())) && !CollectionUtils.isEmpty(comTypeIdList = this.uccOrgGuideCatalogSalesRestrictionMapper.getComTypeIdListByOrgIdList(orgIdList, restrictionType, UccConstants.Status.VALID, channelId))) {
            commodityTypeIdList.addAll(comTypeIdList);
        }
        return commodityTypeIdList;
    }

    private List<Long> getSkuIdList(Long orgId, Integer skuSource) {
        List<Long> skuIdListByOrgIdList;
        List<Long> orgIdList;
        ArrayList<Long> skuIdList = new ArrayList<Long>();
        String orgPath = this.uccOrgSkuSalesRestrictionMapper.getOrgPath(orgId, skuSource, UccConstants.Status.VALID);
        if (StringUtils.hasText((String)orgPath) && !CollectionUtils.isEmpty(orgIdList = Arrays.stream(orgPath.split("-")).map(Long::new).collect(Collectors.toList())) && !CollectionUtils.isEmpty(skuIdListByOrgIdList = this.uccOrgSkuSalesRestrictionMapper.getSkuIdListByOrgIdList(orgIdList, skuSource, UccConstants.Status.VALID))) {
            skuIdList.addAll(skuIdListByOrgIdList);
        }
        return skuIdList;
    }

    private List<UccOrgSkuListBO> getOrgSkuList(UccOrgSkuCandidateListQryReqBO reqBo, Integer skuSource, List<Long> commodityTypeIdList, List<Long> skuIdList, Page<UccOrgSkuListBO> page) {
        return this.uccCommodityExtMapper.getOrgSkuNotRestrictionList(reqBo, skuSource, commodityTypeIdList, skuIdList, page);
    }
}

