/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccOrgSkuListBO;
import com.tydic.uccext.bo.UccOrgSkuListQryReqBO;
import com.tydic.uccext.bo.UccOrgSkuListQryRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccOrgGuideCatalogSalesRestrictionMapper;
import com.tydic.uccext.dao.UccOrgSkuSalesRestrictionMapper;
import com.tydic.uccext.dao.po.CnncUccSkuListPo;
import com.tydic.uccext.service.UccOrgSkuListQryAbilityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccOrgSkuListQryAbilityService"})
public class UccOrgSkuListQryAbilityServiceImpl
implements UccOrgSkuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccOrgSkuListQryAbilityServiceImpl.class);
    @Autowired
    private UccOrgSkuSalesRestrictionMapper uccOrgSkuSalesRestrictionMapper;
    @Autowired
    private UccOrgGuideCatalogSalesRestrictionMapper uccOrgGuideCatalogSalesRestrictionMapper;

    @PostMapping(value={"getUccOrgSkuList"})
    public UccOrgSkuListQryRspBO getUccOrgSkuList(@RequestBody UccOrgSkuListQryReqBO reqBO) {
        UccOrgSkuListQryRspBO rspBO = new UccOrgSkuListQryRspBO();
        if (reqBO.getFlag() != null && reqBO.getFlag() == 1 && reqBO.getOrgId() != null) {
            reqBO.setOrgPath(reqBO.getOrgId().toString());
        }
        ArrayList<UccOrgSkuListBO> uccOrgSkuListBOS = new ArrayList<UccOrgSkuListBO>();
        CnncUccSkuListPo cnncUccSkuListPo = new CnncUccSkuListPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)cnncUccSkuListPo);
        cnncUccSkuListPo.setStatus(UccConstants.Status.VALID);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        cnncUccSkuListPo.setSkuSource(UccConstants.SkuSaleRestrictionAuthType.find(reqBO.getAuthType()).getSkuSource());
        String orgPath = reqBO.getOrgPath();
        if (StringUtils.hasText((String)orgPath)) {
            List<Long> orgList = Arrays.stream(orgPath.split("-")).map(Long::new).collect(Collectors.toList());
            cnncUccSkuListPo.setOrgIds(orgList);
            List<CnncUccSkuListPo> cnncUccSkuListPos = this.uccOrgSkuSalesRestrictionMapper.getSkuListPage(page, cnncUccSkuListPo);
            if (!CollectionUtils.isEmpty(cnncUccSkuListPos)) {
                for (CnncUccSkuListPo cnncUccSkuListPo1 : cnncUccSkuListPos) {
                    UccOrgSkuListBO uccOrgSkuListBO = new UccOrgSkuListBO();
                    BeanUtils.copyProperties((Object)cnncUccSkuListPo1, (Object)uccOrgSkuListBO);
                    uccOrgSkuListBOS.add(uccOrgSkuListBO);
                }
            }
        } else {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u673a\u6784\u5168\u8def\u5f84");
        }
        this.dealFlag(uccOrgSkuListBOS, reqBO.getOrgId());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(uccOrgSkuListBOS);
        return rspBO;
    }

    private void dealFlag(List<UccOrgSkuListBO> bos, Long orgId) {
        if (!CollectionUtils.isEmpty(bos) && orgId != null) {
            List<Long> skuIds = bos.stream().map(UccOrgSkuListBO::getSkuId).collect(Collectors.toList());
            List<Long> havIds = this.uccOrgSkuSalesRestrictionMapper.getListByOrgIdsAndSkuIds(Lists.newArrayList((Object[])new Long[]{orgId}), skuIds, UccConstants.Status.VALID);
            for (UccOrgSkuListBO bo : bos) {
                if (!CollectionUtils.isEmpty(havIds)) {
                    if (havIds.contains(bo.getSkuId())) {
                        bo.setFlag(UccConstants.OrgFlag.oneSlefLevel);
                        continue;
                    }
                    bo.setFlag(UccConstants.OrgFlag.notOneSlefLevel);
                    continue;
                }
                bo.setFlag(UccConstants.OrgFlag.notOneSlefLevel);
            }
        }
    }
}

