/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.dao.UccDicDictionaryMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.enumType.SkuEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.search.config.ElasticsearchUtil;
import com.tydic.commodity.search.config.EsConfig;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.UccCommodityListBO;
import com.tydic.uccext.bo.UccQryCommodityListExportAbilityReqBO;
import com.tydic.uccext.bo.UccQryCommodityListExportAbilityRspBO;
import com.tydic.uccext.dao.UccCommodityExtMapper;
import com.tydic.uccext.service.UccQryCommodityListExportAbilityService;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccQryCommodityListExportAbilityService"})
public class UccQryCommodityListExportAbilityServiceImpl
implements UccQryCommodityListExportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccQryCommodityListExportAbilityServiceImpl.class);
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    @PostMapping(value={"qryCommodityListExport"})
    public UccQryCommodityListExportAbilityRspBO qryCommodityListExport(@RequestBody UccQryCommodityListExportAbilityReqBO reqBo) {
        UccQryCommodityListExportAbilityRspBO rspBo = new UccQryCommodityListExportAbilityRspBO();
        if (null == reqBo) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (1 > reqBo.getPageNo()) {
            reqBo.setPageNo(1);
        }
        reqBo.setPageSize(2000);
        BoolQueryBuilder boolQueryBuilder = this.buildSql(reqBo);
        List<FieldSortBuilder> sortQuery = this.buildSort();
        List<UccCommodityListBO> commodityListInfo = this.executeQueryEs(reqBo, rspBo, boolQueryBuilder, sortQuery);
        if (!CollectionUtils.isEmpty(commodityListInfo)) {
            List dicDictionaryPos = this.uccDicDictionaryMapper.selectByPCode(SkuEnum.SKU_STATUS.toString());
            commodityListInfo.forEach(com -> {
                if (!CollectionUtils.isEmpty((Collection)dicDictionaryPos)) {
                    for (DicDictionaryPo dic : dicDictionaryPos) {
                        if (null == com.getStatus() || !StringUtils.hasText((String)dic.getCode()) || !dic.getCode().equals(com.getStatus().toString())) continue;
                        com.setStatusDesc(dic.getTitle());
                        break;
                    }
                }
                com.setSalePrice(null == com.getSalePrice() ? null : MoneyUtils.haoToYuan((BigDecimal)com.getSalePrice()));
                com.setSalePriceStr(com.getSalePrice().setScale(2, 5).toPlainString());
            });
            List<Long> commodityIdList = commodityListInfo.stream().map(UccCommodityListBO::getCommodityId).collect(Collectors.toList());
            List<UccCommodityListBO> commodityListGiftInfo = this.uccCommodityExtMapper.getCommodityListGiftInfo(commodityIdList);
            if (!CollectionUtils.isEmpty(commodityListGiftInfo)) {
                Date now = new Date();
                commodityListInfo.forEach(com -> {
                    for (UccCommodityListBO gift : commodityListGiftInfo) {
                        if (!com.getCommodityId().equals(gift.getCommodityId())) continue;
                        if (null != gift.getExpTime() && gift.getExpTime().before(now)) break;
                        com.setGiftId(gift.getGiftId());
                        com.setGiftName(gift.getGiftName());
                        com.setEffTime(gift.getEffTime());
                        com.setExpTime(gift.getExpTime());
                        com.setRuleBuyCount(gift.getRuleBuyCount());
                        com.setRulePresentCount(gift.getRulePresentCount());
                        if (null != gift.getRuleBuyCount() && null != gift.getRulePresentCount()) {
                            com.setGiftRule("\u4e70" + gift.getRuleBuyCount() + "\u8d60" + gift.getRulePresentCount());
                            break;
                        }
                        com.setGiftRule("");
                        break;
                    }
                });
            }
        }
        rspBo.setRows(commodityListInfo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<UccCommodityListBO> executeQueryEs(UccQryCommodityListExportAbilityReqBO reqBo, UccQryCommodityListExportAbilityRspBO rspBo, BoolQueryBuilder boolQueryBuilder, List<FieldSortBuilder> sortQuery) {
        ArrayList<UccCommodityListBO> commodityListInfo = new ArrayList();
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        queryJson.put("sort", (Object)JSONObject.parseArray((String)sortQuery.toString()));
        JSONObject collapse = new JSONObject();
        collapse.put("field", (Object)"commodity_id");
        queryJson.put("collapse", (Object)collapse);
        String queryString = queryJson.toString();
        log.debug("\u540e\u53f0\u5546\u54c1\u5217\u8868\u67e5\u8be2es\u8bed\u53e5-->{}", (Object)queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Integer total;
            int add;
            int totalPage;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject resultObj = JSONObject.parseObject((String)result);
            JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
            Integer totalRecords = hitsObj.getInteger("total");
            JSONArray listObject = hitsObj.getJSONArray("hits");
            log.debug("\u603b\u8bb0\u5f55\u6570:" + totalRecords + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
            if (listObject.size() > 0) {
                commodityListInfo = this.dealSearchResult(listObject);
            }
            int size = reqBo.getPageSize();
            int no = reqBo.getPageNo();
            Integer esSeaarchSize = 10000;
            if (esSeaarchSize.compareTo(totalRecords) > 0) {
                totalPage = totalRecords / size;
                add = totalRecords % size == 0 ? 0 : 1;
                total = totalRecords;
            } else {
                totalPage = esSeaarchSize / size;
                total = size * (totalPage + (add = esSeaarchSize % size == 0 ? 0 : 1));
                if (total.compareTo(totalRecords) > 0) {
                    total = totalRecords;
                }
            }
            rspBo.setTotal(totalPage + add);
            rspBo.setPageNo(no);
            rspBo.setRecordsTotal(total.intValue());
            return commodityListInfo;
        }
        catch (IOException e) {
            log.error("\u67e5\u8be2es\u5f02\u5e38", (Throwable)e);
            return new ArrayList<UccCommodityListBO>();
        }
    }

    private List<UccCommodityListBO> dealSearchResult(JSONArray listObject) {
        ArrayList<UccCommodityListBO> commodityListInfo = new ArrayList<UccCommodityListBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            UccCommodityListBO uccCommodityListBo = new UccCommodityListBO();
            uccCommodityListBo.setCommodityId(null == data.get((Object)"commodity_id") ? null : Long.valueOf(data.get((Object)"commodity_id").toString()));
            uccCommodityListBo.setSupplierShopId(null == data.get((Object)"supplier_shop_id") ? null : Long.valueOf(data.get((Object)"supplier_shop_id").toString()));
            uccCommodityListBo.setCommodityCode(null == data.get((Object)"commodity_code") ? null : data.get((Object)"commodity_code").toString());
            uccCommodityListBo.setCommodityName(null == data.get((Object)"sku_name") ? null : data.get((Object)"sku_name").toString());
            uccCommodityListBo.setCommodityTypeName(null == data.get((Object)"type_name") ? null : data.get((Object)"type_name").toString());
            uccCommodityListBo.setMaterialTypeId(null == data.get((Object)"material_id") ? null : Long.valueOf(data.get((Object)"material_id").toString()));
            uccCommodityListBo.setMaterialTypeName(null == data.get((Object)"material_name") ? null : data.get((Object)"material_name").toString());
            uccCommodityListBo.setCommodityBanner(null == data.get((Object)"commodity_banner") ? null : data.get((Object)"commodity_banner").toString());
            uccCommodityListBo.setBrandId(null == data.get((Object)"brand_id") ? null : Long.valueOf(data.get((Object)"brand_id").toString()));
            uccCommodityListBo.setBrandName(null == data.get((Object)"brand_name") ? null : data.get((Object)"brand_name").toString());
            uccCommodityListBo.setSalePrice(null == data.get((Object)"sale_price") ? null : new BigDecimal(data.get((Object)"sale_price").toString()));
            uccCommodityListBo.setMeasureName(null == data.get((Object)"measure_name") ? null : data.get((Object)"measure_name").toString());
            uccCommodityListBo.setStatus(null == data.get((Object)"sku_status") ? null : Integer.valueOf(data.get((Object)"sku_status").toString()));
            JSONArray supplyIds = data.getJSONArray("supply_ids");
            uccCommodityListBo.setSupplierCount(Integer.valueOf(CollectionUtils.isEmpty((Collection)supplyIds) ? 0 : supplyIds.size()));
            commodityListInfo.add(uccCommodityListBo);
        }
        return commodityListInfo;
    }

    private BoolQueryBuilder buildSql(UccQryCommodityListExportAbilityReqBO reqBo) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (Object)SkuStatusEnum.INVALID_STATUS.getStatus()));
        if (null != reqBo.getStatus()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (Object)reqBo.getStatus()));
        }
        if (null != reqBo.getBrandId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (StringUtils.hasText((String)reqBo.getCommodityCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*")));
        }
        if (null != reqBo.getCommodityId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (null != reqBo.getCommodityTypeId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (null != reqBo.getSceneId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"scene_ids", (Object)reqBo.getSceneId()));
        }
        if (null != reqBo.getMaterialType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_id", (Object)reqBo.getMaterialType()));
        }
        if (StringUtils.hasText((String)reqBo.getCommodityName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getCommodityName() + "*")));
        }
        if (StringUtils.hasText((String)reqBo.getSupplierId())) {
            if ("0".equals(reqBo.getSupplierId())) {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"supply_ids"));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supply_ids", (String)reqBo.getSupplierId()));
            }
        }
        return boolQueryBuilder;
    }

    private List<FieldSortBuilder> buildSort() {
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"commodity_id").order(SortOrder.DESC);
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        fieldSortBuilders.add(sortQuery);
        return fieldSortBuilders;
    }
}

