/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.bo.UccFtpBO;
import com.tydic.commodity.bo.UccFtpConfig;
import com.tydic.commodity.util.UccFtpUtil;
import com.tydic.uccext.bo.UccFtpDirectoryBO;
import com.tydic.uccext.bo.UccFtpDirectoryFileBO;
import com.tydic.uccext.bo.UccQryFtpDirectoryAbilityReqBO;
import com.tydic.uccext.bo.UccQryFtpDirectoryAbilityRspBO;
import com.tydic.uccext.service.UccQryFtpDirectoryAbilityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccQryFtpDirectoryAbilityService"})
public class UccQryFtpDirectoryAbilityServiceImpl
implements UccQryFtpDirectoryAbilityService {
    @Value(value="${ftp.host:}")
    private String fileHost;
    @Value(value="${ftp.user:}")
    private String fileUser;
    @Value(value="${ftp.pwd:}")
    private String filePwd;
    @Value(value="${ftp.port:}")
    private Integer filePort;
    @Value(value="${ftp.timeout:}")
    private Integer timeOut;
    private final List<String> suffixList = Arrays.asList("jpg", "jpeg", "png");

    @PostMapping(value={"qryFtpDirectory"})
    public UccQryFtpDirectoryAbilityRspBO qryFtpDirectory(@RequestBody UccQryFtpDirectoryAbilityReqBO reqBo) {
        UccQryFtpDirectoryAbilityRspBO rspBo = new UccQryFtpDirectoryAbilityRspBO();
        UccFtpConfig uccFtpConfig = new UccFtpConfig(this.fileHost, this.fileUser, this.filePwd, this.filePort, this.timeOut);
        UccFtpBO ftpDirectory = UccFtpUtil.getFtpDirectory((UccFtpConfig)uccFtpConfig, (String)reqBo.getDirPath(), this.suffixList);
        if (null != ftpDirectory) {
            UccFtpDirectoryBO uccFtpDirectoryBo = new UccFtpDirectoryBO();
            uccFtpDirectoryBo.setCurrentPath(ftpDirectory.getCurrentPath());
            ArrayList uccFtpDirectoryFileBoList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)ftpDirectory.getFileList())) {
                ftpDirectory.getFileList().forEach(fileBo -> {
                    UccFtpDirectoryFileBO uccFtpDirectoryFileBo = new UccFtpDirectoryFileBO();
                    uccFtpDirectoryFileBo.setIsDir(fileBo.getIsDir());
                    uccFtpDirectoryFileBo.setFileName(fileBo.getFileName());
                    uccFtpDirectoryFileBoList.add(uccFtpDirectoryFileBo);
                });
            }
            uccFtpDirectoryBo.setFileList(uccFtpDirectoryFileBoList);
            rspBo.setFtpDirectory(uccFtpDirectoryBo);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
        } else {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8be5\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\u6216\u8005\u65e0\u8bbf\u95ee\u6743\u9650");
        }
        return rspBo;
    }
}

