/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import com.tydic.uccext.bo.UccGiftBO;
import com.tydic.uccext.bo.UccGiftPicBO;
import com.tydic.uccext.bo.UccQryGiftDetailAbilityReqBO;
import com.tydic.uccext.bo.UccQryGiftDetailAbilityRspBO;
import com.tydic.uccext.bo.UccSkuGiftRelBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccGiftsMapper;
import com.tydic.uccext.dao.UccGiftsPicMapper;
import com.tydic.uccext.dao.UccRelSkuGiftsMapper;
import com.tydic.uccext.dao.po.UccGiftsPO;
import com.tydic.uccext.dao.po.UccGiftsPicPO;
import com.tydic.uccext.dao.po.UccRelSkuGiftsPO;
import com.tydic.uccext.service.UccQryGiftDetailAbilityService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccQryGiftDetailAbilityService"})
public class UccQryGiftDetailAbilityServiceImpl
implements UccQryGiftDetailAbilityService {
    @Autowired
    private UccGiftsMapper uccGiftsMapper;
    @Autowired
    private UccRelSkuGiftsMapper uccRelSkuGiftsMapper;
    @Autowired
    private UccGiftsPicMapper uccGiftsPicMapper;

    @PostMapping(value={"qryGiftDetail"})
    public UccQryGiftDetailAbilityRspBO qryGiftDetail(@RequestBody UccQryGiftDetailAbilityReqBO reqBo) {
        this.doCheckValidReq(reqBo);
        UccGiftsPO uccGiftsPo = new UccGiftsPO();
        uccGiftsPo.setGiftId(reqBo.getGiftId());
        uccGiftsPo.setGiftStatus(UccConstants.Status.VALID);
        uccGiftsPo = this.uccGiftsMapper.getModelBy(uccGiftsPo);
        if (uccGiftsPo == null) {
            throw new BusinessException("8888", "\u8be5\u8d60\u54c1\u4e0d\u5b58\u5728\uff01");
        }
        UccQryGiftDetailAbilityRspBO rspBo = new UccQryGiftDetailAbilityRspBO();
        UccGiftBO giftDetail = new UccGiftBO();
        rspBo.setGiftDetail(giftDetail);
        BeanUtils.copyProperties((Object)uccGiftsPo, (Object)giftDetail);
        giftDetail.setCreateTime(uccGiftsPo.getCreateTime() == null ? "" : DateUtils.dateToStr((Date)uccGiftsPo.getCreateTime()));
        giftDetail.setUpdateTime(uccGiftsPo.getUpdateTime() == null ? "" : DateUtils.dateToStr((Date)uccGiftsPo.getUpdateTime()));
        UccGiftsPicPO uccGiftsPicPo = new UccGiftsPicPO();
        uccGiftsPicPo.setGiftId(reqBo.getGiftId());
        List<UccGiftsPicPO> picList = this.uccGiftsPicMapper.getList(uccGiftsPicPo);
        if (!CollectionUtils.isEmpty(picList)) {
            ArrayList giftPic = new ArrayList(picList.size());
            rspBo.setGiftPic(giftPic);
            picList.forEach(pic -> {
                UccGiftPicBO picBO = new UccGiftPicBO();
                giftPic.add(picBO);
                BeanUtils.copyProperties((Object)pic, (Object)picBO);
                picBO.setUpdateTime(pic.getUpdateTime() == null ? "" : DateUtils.dateToStr((Date)pic.getUpdateTime()));
                picBO.setCreateTime(pic.getCreateTime() == null ? "" : DateUtils.dateToStr((Date)pic.getCreateTime()));
            });
        }
        UccRelSkuGiftsPO uccRelSkuGiftsPo = new UccRelSkuGiftsPO();
        uccRelSkuGiftsPo.setGiftId(reqBo.getGiftId());
        uccRelSkuGiftsPo.setCommodityId(reqBo.getCommodityId());
        List<UccRelSkuGiftsPO> relList = this.uccRelSkuGiftsMapper.getList(uccRelSkuGiftsPo);
        if (!CollectionUtils.isEmpty(relList)) {
            ArrayList giftRel = new ArrayList(relList.size());
            rspBo.setGiftRel(giftRel);
            relList.forEach(rel -> {
                UccSkuGiftRelBO relBO = new UccSkuGiftRelBO();
                giftRel.add(relBO);
                BeanUtils.copyProperties((Object)rel, (Object)relBO);
                relBO.setCreateTime(rel.getCreateTime() == null ? "" : DateUtils.dateToStr((Date)rel.getCreateTime()));
                relBO.setEffTime(rel.getEffTime() == null ? "" : DateUtils.dateToStr((Date)rel.getEffTime()));
                relBO.setExpTime(rel.getExpTime() == null ? "" : DateUtils.dateToStr((Date)rel.getExpTime()));
                relBO.setUpdateTime(rel.getUpdateTime() == null ? "" : DateUtils.dateToStr((Date)rel.getUpdateTime()));
            });
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void doCheckValidReq(UccQryGiftDetailAbilityReqBO reqBo) {
        if (reqBo == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBo.getGiftId() == null) {
            throw new BusinessException("8888", "\u8d60\u54c1id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
    }
}

