/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.util.DateUtils;
import com.tydic.uccext.bo.UccGiftListBO;
import com.tydic.uccext.bo.UccQryGiftListAbilityReqBO;
import com.tydic.uccext.bo.UccQryGiftListAbilityRspBO;
import com.tydic.uccext.bo.UccSkuGiftRelBO;
import com.tydic.uccext.dao.UccGiftsMapper;
import com.tydic.uccext.dao.UccRelSkuGiftsMapper;
import com.tydic.uccext.service.UccQryGiftListAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccQryGiftListAbilityService"})
public class UccQryGiftListAbilityServiceImpl
implements UccQryGiftListAbilityService {
    @Autowired
    private UccGiftsMapper uccGiftsMapper;
    @Autowired
    private UccRelSkuGiftsMapper uccRelSkuGiftsMapper;

    @PostMapping(value={"qryGiftList"})
    public UccQryGiftListAbilityRspBO qryGiftList(@RequestBody UccQryGiftListAbilityReqBO reqBo) {
        UccQryGiftListAbilityRspBO rspBo = new UccQryGiftListAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List<UccGiftListBO> rows = this.uccGiftsMapper.getGifsListPage(reqBo, (Page<UccGiftListBO>)page);
        if (CollectionUtils.isEmpty(rows)) {
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList(0));
            return rspBo;
        }
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(rows);
        List<Long> giftIdList = rows.stream().map(UccGiftListBO::getGiftId).collect(Collectors.toList());
        List<UccSkuGiftRelBO> relList = this.uccRelSkuGiftsMapper.getListByGiftIds(giftIdList);
        if (CollectionUtils.isEmpty(relList)) {
            return rspBo;
        }
        Date now = new Date();
        Map<Long, List<UccSkuGiftRelBO>> giftRelMap = relList.stream().collect(Collectors.groupingBy(UccSkuGiftRelBO::getGiftId));
        rows.forEach(gift -> {
            List skuGiftRels = (List)giftRelMap.get(gift.getGiftId());
            if (!CollectionUtils.isEmpty((Collection)skuGiftRels)) {
                skuGiftRels = skuGiftRels.stream().filter(relBo -> {
                    Date exp = DateUtils.strToDate((String)relBo.getExpTime());
                    return exp.after(now);
                }).distinct().collect(Collectors.toList());
            }
            gift.setRelSkuList(skuGiftRels);
        });
        return rspBo;
    }
}

