/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.uccext.bo.UccGiftListExportBO;
import com.tydic.uccext.bo.UccQryGiftListExportAbilityReqBO;
import com.tydic.uccext.bo.UccQryGiftListExportAbilityRspBO;
import com.tydic.uccext.dao.UccGiftsMapper;
import com.tydic.uccext.dao.UccRelSkuGiftsMapper;
import com.tydic.uccext.service.UccQryGiftListExportAbilityService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccQryGiftListExportAbilityService"})
public class UccQryGiftListExportAbilityServiceImpl
implements UccQryGiftListExportAbilityService {
    @Autowired
    private UccGiftsMapper uccGiftsMapper;
    @Autowired
    private UccRelSkuGiftsMapper uccRelSkuGiftsMapper;

    @PostMapping(value={"qryGiftListExport"})
    public UccQryGiftListExportAbilityRspBO qryGiftListExport(@RequestBody UccQryGiftListExportAbilityReqBO reqBo) {
        UccQryGiftListExportAbilityRspBO rspBo = new UccQryGiftListExportAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (1 > reqBo.getPageNo()) {
            reqBo.setPageNo(1);
        }
        reqBo.setPageSize(2000);
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List<UccGiftListExportBO> rows = this.uccGiftsMapper.getGiftsListByPage(reqBo, (Page<UccGiftListExportBO>)page);
        if (CollectionUtils.isEmpty(rows)) {
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList(0));
            return rspBo;
        }
        rows.forEach(gift -> {
            if (null != gift.getRuleBuyCount() && null != gift.getRulePresentCount()) {
                gift.setGiftRule("\u4e70" + gift.getRuleBuyCount() + "\u8d60" + gift.getRulePresentCount());
            } else {
                gift.setGiftRule("");
            }
        });
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(rows);
        return rspBo;
    }
}

