/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.dao.UccDicDictionaryMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.uccext.bo.UccMaterialTypeBO;
import com.tydic.uccext.bo.UccQryMaterialTypeListAbilityReqBO;
import com.tydic.uccext.bo.UccQryMaterialTypeListAbilityRspBO;
import com.tydic.uccext.dao.UccMaterialTypeMapper;
import com.tydic.uccext.dao.po.UccMaterialTypePO;
import com.tydic.uccext.service.UccQryMaterialTypeListAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccQryMaterialTypeListAbilityService"})
public class UccQryMaterialTypeListAbilityServiceImpl
implements UccQryMaterialTypeListAbilityService {
    @Autowired
    private UccMaterialTypeMapper uccMaterialTypeMapper;
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;

    @PostMapping(value={"qryMaterialTypeList"})
    public UccQryMaterialTypeListAbilityRspBO qryMaterialTypeList(@RequestBody UccQryMaterialTypeListAbilityReqBO reqBo) {
        UccQryMaterialTypeListAbilityRspBO rspBo = new UccQryMaterialTypeListAbilityRspBO();
        if (reqBo == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (1 > reqBo.getPageNo()) {
            reqBo.setPageNo(1);
        }
        if (1 > reqBo.getPageSize()) {
            reqBo.setPageSize(10);
        }
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        ArrayList<UccMaterialTypeBO> boList = new ArrayList<UccMaterialTypeBO>();
        UccMaterialTypePO materialTypePo = new UccMaterialTypePO();
        materialTypePo.setMaterialType(reqBo.getMaterialType());
        List<UccMaterialTypePO> listPage = this.uccMaterialTypeMapper.getListPage(materialTypePo, (Page<UccMaterialTypePO>)page);
        if (!CollectionUtils.isEmpty(listPage)) {
            Map<String, List<DicDictionaryPo>> collectByCode = null;
            List dicDictionaryPos = this.uccDicDictionaryMapper.selectByPCode("MATERIAL_TYPE_COLOR");
            if (!CollectionUtils.isEmpty((Collection)dicDictionaryPos)) {
                collectByCode = dicDictionaryPos.stream().collect(Collectors.groupingBy(po -> po.getCode().toUpperCase()));
            }
            for (UccMaterialTypePO each : listPage) {
                List<DicDictionaryPo> dictionaryPos;
                UccMaterialTypeBO bo = new UccMaterialTypeBO();
                bo.setTypeId(each.getTypeId());
                bo.setTypeCode(each.getTypeCode());
                bo.setMaterialType(each.getMaterialType());
                bo.setBgColor(each.getBgColor());
                if (!CollectionUtils.isEmpty(collectByCode) && StringUtils.hasText((String)each.getBgColor()) && !CollectionUtils.isEmpty(dictionaryPos = collectByCode.get(each.getBgColor().toUpperCase()))) {
                    bo.setBgColorDesc(dictionaryPos.get(0).getTitle());
                }
                boList.add(bo);
            }
        }
        rspBo.setPageNo(page.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(boList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

