/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.uccext.bo.SynEsInfoThreadBo;
import com.tydic.uccext.bo.SyncAllCommodityToEsReqBO;
import com.tydic.uccext.bo.SyncSceneCommodityToEsExtReqBO;
import com.tydic.uccext.bo.SyncSceneCommodityToEsRspBO;
import com.tydic.uccext.busi.impl.SynEsInfoThread;
import com.tydic.uccext.service.SyncSceneCommodityToEsBusiService;
import com.tydic.uccext.service.UccSyncSceneCommodityToEsAbilityService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccSyncSceneCommodityToEsAbilityService"})
public class UccSyncSceneCommodityToEsAbilityServiceImpl
implements UccSyncSceneCommodityToEsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncSceneCommodityToEsAbilityServiceImpl.class);
    @Autowired
    private SyncSceneCommodityToEsBusiService syncSceneCommodityToEsBusiService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    @PostMapping(value={"syncSceneCommodityToEs"})
    public SyncSceneCommodityToEsRspBO syncSceneCommodityToEs(@RequestBody SyncSceneCommodityToEsExtReqBO syncSceneCommodityToEsExtReqBO) {
        return this.syncSceneCommodityToEsBusiService.syncSceneCommodityToEs(syncSceneCommodityToEsExtReqBO);
    }

    @PostMapping(value={"syncAlllCommodityToEs"})
    public SyncSceneCommodityToEsRspBO syncAlllCommodityToEs(@RequestBody SyncAllCommodityToEsReqBO reqBO) {
        SyncSceneCommodityToEsRspBO rspBO = new SyncSceneCommodityToEsRspBO();
        long star = System.currentTimeMillis();
        if (reqBO.getShar() > 1) {
            if (reqBO.getSupplierId() != null) {
                int total = this.uccCommodityMapper.countCommodity(reqBO.getSupplierId());
                reqBO.setTotal(total);
                rspBO = this.run(reqBO);
                return rspBO;
            }
            List countShopIds = this.uccCommodityMapper.countShopIds();
            if (CollectionUtils.isEmpty((Collection)countShopIds)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65e0\u540c\u6b65\u6570\u636e");
                return rspBO;
            }
            Object SyncAllCommodityToEsReqBO2 = null;
            for (Long each : countShopIds) {
                int total = this.uccCommodityMapper.countCommodity(each);
                reqBO.setSupplierId(each);
                reqBO.setTotal(total);
                rspBO = this.run(reqBO);
                if ("0000".equals(rspBO.getRespCode())) continue;
                return rspBO;
            }
        } else {
            if (reqBO.getSupplierId() != null) {
                int total = this.uccCommodityMapper.countCommodity(reqBO.getSupplierId());
                reqBO.setTotal(total);
                return this.syncToEsImpl(reqBO);
            }
            List countShopIds = this.uccCommodityMapper.countShopIds();
            if (CollectionUtils.isEmpty((Collection)countShopIds)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65e0\u540c\u6b65\u6570\u636e");
                return rspBO;
            }
            SyncAllCommodityToEsReqBO SyncAllCommodityToEsReqBO3 = null;
            for (Long each : countShopIds) {
                SyncAllCommodityToEsReqBO3 = new SyncAllCommodityToEsReqBO();
                SyncAllCommodityToEsReqBO3.setSupplierId(each);
                rspBO = this.syncToEsImpl(reqBO);
                if ("0000".equals(rspBO.getRespCode())) continue;
                return rspBO;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u66f4\u65b0\u7ed3\u675f\uff0c\u603b\u8017\u65f6\uff1a " + (System.currentTimeMillis() - star));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private SyncSceneCommodityToEsRspBO syncToEsImpl(SyncAllCommodityToEsReqBO reqBO) {
        SyncSceneCommodityToEsRspBO rspBO = new SyncSceneCommodityToEsRspBO();
        int total = this.uccCommodityMapper.countCommodity(reqBO.getSupplierId());
        if (total == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5e97\u94fa\u4e0b\u65e0\u540c\u6b65\u6570\u636e");
            return rspBO;
        }
        int cycle = total % reqBO.getSize() == 0 ? total / reqBO.getSize() : total / reqBO.getSize() + 1;
        SyncSceneCommodityToEsExtReqBO syncSceneCommodityToEsExtReqBO = null;
        UccCommodityPo po = new UccCommodityPo();
        po.setSupplierShopId(reqBO.getSupplierId());
        Page page = new Page();
        for (int i = 1; i < cycle + 1; ++i) {
            page.setPageNo(i);
            page.setPageSize(reqBO.getSize());
            List comds = this.uccCommodityMapper.queryCommodityList(po, page);
            if (CollectionUtils.isEmpty((Collection)comds)) continue;
            syncSceneCommodityToEsExtReqBO = new SyncSceneCommodityToEsExtReqBO();
            syncSceneCommodityToEsExtReqBO.setCommodityIds(comds);
            syncSceneCommodityToEsExtReqBO.setSyncType(Integer.valueOf(0));
            syncSceneCommodityToEsExtReqBO.setOperType(Integer.valueOf(0));
            syncSceneCommodityToEsExtReqBO.setSupplierId(reqBO.getSupplierId());
            rspBO = this.syncSceneCommodityToEsBusiService.syncSceneCommodityToEs(syncSceneCommodityToEsExtReqBO);
            if ("0000".equals(rspBO.getRespCode())) continue;
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private SyncSceneCommodityToEsRspBO run(SyncAllCommodityToEsReqBO reqBO) {
        SyncSceneCommodityToEsRspBO rspBO = new SyncSceneCommodityToEsRspBO();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor(50, 50, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        if (log.isDebugEnabled()) {
            log.debug(reqBO.getSupplierId() + "\u5546\u54c1\u540c\u6b65es\u5f00\u59cb");
        }
        long start = System.currentTimeMillis();
        int cycle = reqBO.getTotal() % reqBO.getShar() == 0 ? reqBO.getTotal() / reqBO.getShar() : reqBO.getTotal() / reqBO.getShar() + 1;
        for (int i = 0; i < reqBO.getShar(); ++i) {
            SynEsInfoThreadBo synEsInfoThreadBo = new SynEsInfoThreadBo();
            synEsInfoThreadBo.setSupplierId(reqBO.getSupplierId());
            synEsInfoThreadBo.setStart(i * cycle);
            synEsInfoThreadBo.setEnd((i + 1) * cycle);
            synEsInfoThreadBo.setTotal(cycle);
            synEsInfoThreadBo.setSize(reqBO.getSize());
            if (synEsInfoThreadBo.getStart() > reqBO.getTotal()) continue;
            SynEsInfoThread synInfoThread = new SynEsInfoThread();
            synInfoThread.setUccCommodityMapper(this.uccCommodityMapper);
            synInfoThread.setSyncSceneCommodityToEsBusiService(this.syncSceneCommodityToEsBusiService);
            synInfoThread.setSynEsInfoThreadBo(synEsInfoThreadBo);
            fixedThreadPool.submit(synInfoThread);
        }
        fixedThreadPool.shutdown();
        while (true) {
            if (fixedThreadPool.isTerminated()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u66f4\u65b0\u7ed3\u675f");
        long end = System.currentTimeMillis();
        long l = (end - start) / 1000L;
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u66f4\u65b0\u7ed3\u675f\u8017\u65f6\uff1a " + l);
        }
        return rspBO;
    }
}

