/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.UccCommodityPicBO;
import com.tydic.uccext.bo.UccLadderPriceBO;
import com.tydic.uccext.bo.UccUpdateCommodityAbilityReqBO;
import com.tydic.uccext.bo.UccUpdateCommodityAbilityRspBO;
import com.tydic.uccext.bo.supply.UccSupplyPriceBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccSupplyInfoMapper;
import com.tydic.uccext.service.UccUpdateCommodityAbilityService;
import com.tydic.uccext.service.UccUpdateCommodityBusiService;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccUpdateCommodityAbilityService"})
public class UccUpdateCommodityAbilityServiceImpl
implements UccUpdateCommodityAbilityService {
    @Value(value="${DEFAULT_MAIN_PIC_URL}")
    private String defaultMainPicUrl;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccUpdateCommodityBusiService uccUpdateCommodityBusiService;
    @Autowired
    private UccSupplyInfoMapper uccSupplyInfoMapper;

    @PostMapping(value={"updateCommodity"})
    public UccUpdateCommodityAbilityRspBO updateCommodity(@RequestBody UccUpdateCommodityAbilityReqBO reqBo) {
        UccUpdateCommodityAbilityRspBO rspBo = new UccUpdateCommodityAbilityRspBO();
        rspBo.setRespCode("8888");
        String rspDesc = this.validateArgs(reqBo);
        if (StringUtils.hasText((String)rspDesc)) {
            rspBo.setRespDesc(rspDesc);
            return rspBo;
        }
        rspBo = this.uccUpdateCommodityBusiService.updateCommodity(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBo.setCommodityIds(Collections.singletonList(reqBo.getCommodityId()));
            syncSceneCommodityToEsReqBo.setSupplierId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
            syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
        }
        return rspBo;
    }

    private String validateArgs(UccUpdateCommodityAbilityReqBO reqBo) {
        if (null == reqBo || null == reqBo.getCommodityId()) {
            return "\u5165\u53c2\u5bf9\u8c61\u3001\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null != reqBo.getMoq() && 1 > reqBo.getMoq()) {
            reqBo.setMoq(Integer.valueOf(1));
        }
        if (null != reqBo.getMoq() && null != reqBo.getMaxoq() && reqBo.getMaxoq() <= reqBo.getMoq()) {
            return "\u6700\u5927\u8d77\u8ba2\u91cf\u5fc5\u987b\u5927\u4e8e\u6700\u5c0f\u8d77\u8ba2\u91cf";
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommdImages())) {
            for (UccCommodityPicBO picBo : reqBo.getCommdImages()) {
                if (null == picBo.getPicType()) {
                    return "\u5165\u53c2\u56fe\u7247\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (!ModelRuleConstant.COMMD_IMG_MAIN.equals(picBo.getPicType()) && !ModelRuleConstant.COMMD_IMG_DETAIL.equals(picBo.getPicType())) {
                    return "\u5165\u53c2\u56fe\u7247\u7c7b\u578b\u4e0d\u6b63\u786e";
                }
                if (!StringUtils.hasText((String)picBo.getPicUrl())) {
                    return "\u5165\u53c2\u56fe\u7247\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null != picBo.getPicOrder()) continue;
                picBo.setPicOrder(Integer.valueOf(0));
            }
        } else {
            UccCommodityPicBO uccCommodityPicBo = new UccCommodityPicBO();
            uccCommodityPicBo.setPicType(ModelRuleConstant.COMMD_IMG_MAIN);
            uccCommodityPicBo.setPicUrl(this.defaultMainPicUrl);
            uccCommodityPicBo.setPicOrder(Integer.valueOf(0));
            uccCommodityPicBo.setRemark("\u9ed8\u8ba4\u4e3b\u56fe");
            reqBo.setCommdImages(Collections.singletonList(uccCommodityPicBo));
        }
        if (null != reqBo.getCommodityPackageSpec() && UccConstants.YesOrNo.YES.equals(reqBo.getIsShowSaleUnit())) {
            if (!StringUtils.hasText((String)reqBo.getCommodityPackageSpec().getPackageSpec())) {
                return "\u5305\u88c5\u89c4\u683c\u4fe1\u606f\u4e2d\u5305\u88c5\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getCommodityPackageSpec().getUnitRate()) {
                return "\u5305\u88c5\u89c4\u683c\u4fe1\u606f\u4e2d\u5355\u4f4d\u6362\u7b97\u503c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            reqBo.getCommodityPackageSpec().setAgreementPrice(reqBo.getSalePrice());
            reqBo.getCommodityPackageSpec().setSalePrice(reqBo.getSalePrice().multiply(reqBo.getCommodityPackageSpec().getUnitRate()).setScale(2, 4));
        }
        BigDecimal salePrice = UccConstants.YesOrNo.YES.equals(reqBo.getIsShowSaleUnit()) ? reqBo.getCommodityPackageSpec().getSalePrice() : reqBo.getSalePrice();
        BigDecimal ladderSalePrice = null;
        if (!CollectionUtils.isEmpty((Collection)reqBo.getLadderPrice())) {
            List ladderPrice = reqBo.getLadderPrice();
            if (((UccLadderPriceBO)ladderPrice.get(0)).getPrice().compareTo(salePrice) != 0) {
                return "\u9636\u68af\u4ef7\u683c\u7b2c\u4e00\u9636\u6bb5\u7684\u4ef7\u683c\u5e94\u4e0e\u9500\u552e\u4ef7\u76f8\u540c";
            }
            for (int i = 0; i < ladderPrice.size(); ++i) {
                UccLadderPriceBO ladder = (UccLadderPriceBO)ladderPrice.get(i);
                if (i == 0 && 1L != ladder.getStart()) {
                    ladder.setStart(Long.valueOf(1L));
                }
                if (null == ladder.getStart()) {
                    return "\u9636\u68af\u4ef7\u683c\u8d77\u59cb\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (0L > ladder.getStart()) {
                    return "\u9636\u68af\u4ef7\u683c\u8d77\u59cb\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u96f6";
                }
                if ((null == ladder.getStop() || 0L >= ladder.getStop()) && i != ladderPrice.size() - 1) {
                    return "\u9636\u68af\u4ef7\u683c\u622a\u6b62\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e\u96f6";
                }
                if (null == ladder.getPrice()) {
                    return "\u9636\u68af\u4ef7\u683c\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (BigDecimal.ZERO.compareTo(ladder.getPrice()) > 0) {
                    return "\u9636\u68af\u4ef7\u683c\u552e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u96f6";
                }
                ladder.setPrice(ladder.getPrice().setScale(2, 4));
                if (i > 0 && i < ladderPrice.size()) {
                    Long start = ladder.getStart();
                    Long stop = ((UccLadderPriceBO)ladderPrice.get(i - 1)).getStop();
                    if (stop + 1L != start) {
                        return "\u9636\u68af\u4ef7\u683c\u6bcf\u4e00\u9636\u6bb5\u7684\u6570\u91cf\u5fc5\u987b\u5173\u8054\u8d77\u6765";
                    }
                }
                ladder.setDiscount(ladder.getPrice().divide(salePrice, 6, RoundingMode.HALF_UP).multiply(new BigDecimal("100")));
                if (i != ladderPrice.size() - 1) continue;
                ladderSalePrice = ladder.getPrice();
                if (null == ladder.getStop() || ladder.getStop() <= 0L) continue;
                return "\u9636\u68af\u4ef7\u683c\u5fc5\u987b\u4e3a\u95ed\u73af\uff0c\u6700\u540e\u4e00\u9636\u6bb5\u622a\u6b62\u6570\u91cf\u5fc5\u987b\u5230\u8fbe\u65e0\u7a77\u5927\u221e";
            }
        }
        if (BigDecimal.ZERO.compareTo(reqBo.getSalePrice()) > 0) {
            return "\u9500\u552e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u96f6";
        }
        List<UccSupplyPriceBO> supplyPriceBySkus = this.uccSupplyInfoMapper.getSupplyPriceBySkus(Collections.singletonList(reqBo.getCommodityId()), null);
        if (!CollectionUtils.isEmpty(supplyPriceBySkus)) {
            supplyPriceBySkus.sort(Comparator.comparing(UccSupplyPriceBO::getSupplyPrice).reversed());
            if (null != supplyPriceBySkus.get(0).getSupplyPrice()) {
                BigDecimal supplyPrice = MoneyUtils.haoToYuan((BigDecimal)supplyPriceBySkus.get(0).getSupplyPrice());
                if (null != salePrice && supplyPrice.compareTo(salePrice) > 0) {
                    return "\u5b9e\u9645\u9500\u552e\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u5927\u4f9b\u5e94\u4ef7";
                }
                if (null != ladderSalePrice && supplyPrice.compareTo(ladderSalePrice) > 0) {
                    return "\u9636\u68af\u4ef7\u683c\u4e2d\u6700\u4f4e\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u5927\u4f9b\u5e94\u4ef7";
                }
            }
        }
        if (StringUtils.hasText((String)reqBo.getCommodityPcDetailChar())) {
            byte[] bytes = Base64Utils.decodeFromString((String)reqBo.getCommodityPcDetailChar());
            try {
                reqBo.setCommodityPcDetailChar(URLDecoder.decode(new String(bytes), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        reqBo.setSalePrice(reqBo.getSalePrice().setScale(2, 4));
        return null;
    }
}

