/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccGiftPicBO;
import com.tydic.uccext.bo.UccUpdateGiftAbilityReqBO;
import com.tydic.uccext.bo.UccUpdateGiftAbilityRspBO;
import com.tydic.uccext.service.UccUpdateGiftAbilityService;
import com.tydic.uccext.service.UccUpdateGiftBusiService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccUpdateGiftAbilityService"})
public class UccUpdateGiftAbilityServiceImpl
implements UccUpdateGiftAbilityService {
    @Autowired
    private UccUpdateGiftBusiService uccUpdateGiftBusiService;
    @Value(value="${DEFAULT_MAIN_PIC_URL}")
    private String defaultMainPicUrl;

    @PostMapping(value={"updateGift"})
    public UccUpdateGiftAbilityRspBO updateGift(@RequestBody UccUpdateGiftAbilityReqBO reqBo) {
        this.doCheckValidReq(reqBo);
        return this.uccUpdateGiftBusiService.updateGift(reqBo);
    }

    private void doCheckValidReq(UccUpdateGiftAbilityReqBO reqBo) {
        if (reqBo == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBo.getGiftId() == null) {
            throw new BusinessException("8888", "\u4fee\u6539\u8d60\u54c1\u3010\u8d60\u54c1id\u3011\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getGiftPics())) {
            UccGiftPicBO uccGiftPicBo = new UccGiftPicBO();
            uccGiftPicBo.setGiftPicType(ModelRuleConstant.COMMD_IMG_MAIN);
            uccGiftPicBo.setGiftPicUrl(this.defaultMainPicUrl);
            uccGiftPicBo.setGiftPicOrder(Integer.valueOf(0));
            uccGiftPicBo.setRemark("\u9ed8\u8ba4\u4e3b\u56fe");
            reqBo.setGiftPics(Collections.singletonList(uccGiftPicBo));
        } else {
            reqBo.getGiftPics().forEach(pic -> {
                if (!StringUtils.hasText((String)pic.getGiftPicUrl())) {
                    throw new BusinessException("8888", "\u56fe\u7247URL\u4e0d\u80fd\u7a7a\uff01");
                }
                if (null == pic.getGiftPicOrder()) {
                    pic.setGiftPicOrder(Integer.valueOf(0));
                }
            });
        }
        if (StringUtils.hasText((String)reqBo.getDetail())) {
            byte[] bytes = Base64Utils.decodeFromString((String)reqBo.getDetail());
            try {
                reqBo.setDetail(URLDecoder.decode(new String(bytes), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }
}

