/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.ListUtils;
import com.tydic.uccext.bo.UccUpdateMaterialTypeAbilityReqBO;
import com.tydic.uccext.bo.UccUpdateMaterialTypeAbilityRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccMaterialTypeMapper;
import com.tydic.uccext.dao.po.UccMaterialTypePO;
import com.tydic.uccext.service.UccUpdateMaterialTypeAbilityService;
import com.tydic.uccext.service.UccUpdateMaterialTypeBusiService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccUpdateMaterialTypeAbilityService"})
public class UccUpdateMaterialTypeAbilityServiceImpl
implements UccUpdateMaterialTypeAbilityService {
    @Autowired
    private UccUpdateMaterialTypeBusiService uccUpdateMaterialTypeBusiService;
    @Autowired
    private UccMaterialTypeMapper uccMaterialTypeMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"updateMaterialType"})
    public UccUpdateMaterialTypeAbilityRspBO updateMaterialType(@RequestBody UccUpdateMaterialTypeAbilityReqBO reqBo) {
        Map batchList;
        List<Long> commodityList;
        UccUpdateMaterialTypeAbilityRspBO rspBo = new UccUpdateMaterialTypeAbilityRspBO();
        String str = this.check(reqBo);
        if (!StringUtils.isEmpty((Object)str)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(str);
            return rspBo;
        }
        rspBo = this.uccUpdateMaterialTypeBusiService.updateMaterialType(reqBo);
        if ("0000".equals(rspBo.getRespCode()) && !CollectionUtils.isEmpty(commodityList = this.uccMaterialTypeMapper.getComsByTypeId(reqBo.getTypeId())) && !CollectionUtils.isEmpty((Map)(batchList = ListUtils.batchList(commodityList, (int)200)))) {
            batchList.forEach((index, list) -> {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBo.setCommodityIds(list);
                syncSceneCommodityToEsReqBo.setSupplierId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
                syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
            });
        }
        return rspBo;
    }

    private String check(UccUpdateMaterialTypeAbilityReqBO reqBo) {
        String str = null;
        if (null == reqBo) {
            str = "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
            return str;
        }
        if (reqBo.getTypeId() == null) {
            str = "\u7269\u8d44\u7c7b\u578bID\u4e0d\u80fd\u4e3a\u7a7a";
            return str;
        }
        if (!StringUtils.hasText((String)reqBo.getMaterialType())) {
            str = "\u7269\u8d44\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
            return str;
        }
        UccMaterialTypePO uccMaterialTypePo = new UccMaterialTypePO();
        uccMaterialTypePo.setMaterialType(reqBo.getMaterialType());
        List<UccMaterialTypePO> materialTypeList = this.uccMaterialTypeMapper.getList(uccMaterialTypePo);
        if (!CollectionUtils.isEmpty(materialTypeList)) {
            if (materialTypeList.size() > 1) {
                str = "\u8be5\u7269\u8d44\u7c7b\u578b\u5df2\u5b58\u5728";
                return str;
            }
            if (!reqBo.getTypeId().equals(materialTypeList.get(0).getTypeId())) {
                str = "\u8be5\u7269\u8d44\u7c7b\u578b\u5df2\u5b58\u5728";
                return str;
            }
        }
        return str;
    }
}

