/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.atom.UccSkuPutCirAtomService;
import com.tydic.commodity.atom.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.atom.bo.UccSkuStatusUpdatesAtomReqBO;
import com.tydic.commodity.atom.bo.UccSkuStatusUpdatesAtomRspBO;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.DateUtils;
import com.tydic.commodity.util.ListUtils;
import com.tydic.uac.config.ProperticeVo;
import com.tydic.uccext.bo.UccZoneGoodsForcedShutAbilityReqBO;
import com.tydic.uccext.bo.UccZoneGoodsForcedShutAbilityRspBO;
import com.tydic.uccext.service.UccZoneGoodsForcedShutAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccZoneGoodsForcedShutAbilityService"})
public class UccZoneGoodsForcedShutAbilityServiceImpl
implements UccZoneGoodsForcedShutAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private ProperticeVo properticeVo;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccZoneGoodsForcedShutAbilityServiceImpl.class);

    @PostMapping(value={"dealUccZoneGoodsForcedShut"})
    public UccZoneGoodsForcedShutAbilityRspBO dealUccZoneGoodsForcedShut(@RequestBody UccZoneGoodsForcedShutAbilityReqBO reqBO) {
        UccZoneGoodsForcedShutAbilityRspBO rspBO = new UccZoneGoodsForcedShutAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5f3a\u5236\u4e0b\u67b6\u6210\u529f");
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u6237ID");
            return rspBO;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u54c1ID");
            return rspBO;
        }
        List supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)supplierShopPos)) {
            reqBO.setSupplierShopId(((SupplierShopPo)supplierShopPos.get(0)).getSupplierShopId());
        }
        List uccSkuPos = null;
        try {
            uccSkuPos = this.uccSkuMapper.batchQrySku(reqBO.getSkuIds(), reqBO.getSupplierShopId());
            List<Long> failIds = new ArrayList();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
                for (UccSkuPo uccSkuPo : uccSkuPos) {
                    if (uccSkuPo.getSkuStatus() == SkuStatusEnum.ON_SHELVES_STATUS.getStatus()) continue;
                    failIds.add(uccSkuPo.getSkuId());
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIds = ListUtils.removeNull(failIds))) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5546\u54c1" + failIds.toString() + "\u72b6\u6001\u4e0d\u4e3a\u4e0a\u67b6");
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        try {
            UccSkuStatusUpdatesAtomReqBO uccSkuStatusUpdatesAtomReqBO = new UccSkuStatusUpdatesAtomReqBO();
            uccSkuStatusUpdatesAtomReqBO.setSkuIds(reqBO.getSkuIds());
            uccSkuStatusUpdatesAtomReqBO.setState(Integer.valueOf(5));
            uccSkuStatusUpdatesAtomReqBO.setSupplierShopId(reqBO.getSupplierShopId());
            UccSkuStatusUpdatesAtomRspBO uccSkuStatusUpdatesAtomRspBO = this.uccSkuStatusUpdatesAtomService.dealUccSkuStatusUpdates(uccSkuStatusUpdatesAtomReqBO);
            if (!"0000".equals(uccSkuStatusUpdatesAtomRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)uccSkuStatusUpdatesAtomRspBO, (Object)rspBO);
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        List skuIds = reqBO.getSkuIds();
        try {
            for (Long skuId : skuIds) {
                UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                uccSkuPutCirReqBO.setSkuId(skuId);
                uccSkuPutCirReqBO.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPutCirReqBO.setDownType(Integer.valueOf(1));
                uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr((Date)new Date()));
                uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                uccSkuPutCirReqBO.setRemark("\u5f3a\u5236\u4e0b\u67b6");
                this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            List agreementDetailsId = uccSkuPos.stream().filter(poList -> poList.getAgreementDetailsId() != null).map(UccSkuPo::getAgreementDetailsId).collect(Collectors.toList());
            List agreementDetailsIds = agreementDetailsId.stream().map(a -> String.valueOf(a)).collect(Collectors.toList());
            UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
            try {
                notifyMessageBO.setAgreementId(String.valueOf(((UccSkuPo)uccSkuPos.get(0)).getAgreementId()));
                notifyMessageBO.setAgreementSkuIds(agreementDetailsIds);
                notifyMessageBO.setAgreementSkuStatus("5");
                notifyMessageBO.setMemIdIn(reqBO.getUserId());
                notifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_DOWN_SHELF.code());
                LOGGER.info("\u5f3a\u5236\u4e0b\u67b6\u5546\u54c1\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
                this.zoneGoodsAuditMQ.send(new ProxyMessage(this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TOPIC"), this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
            }
            catch (Exception var16) {
                LOGGER.error("\u5f3a\u5236\u4e0b\u67b6\uff0c\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
                throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
            }
        }
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList((Iterable)reqBO.getSkuIds()));
        syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierShopId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
        LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            LOGGER.error("\u5f3a\u5236\u4e0b\u67b6\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
            throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
        }
        return rspBO;
    }
}

