/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.uac.config.ProperticeVo;
import com.tydic.uccext.ability.impl.UccZoneGoodsReopenAbilityServiceImpl;
import com.tydic.uccext.bo.UccGoodsAgreementAndCommodityBO;
import com.tydic.uccext.bo.UccPreProcessAuditReqBO;
import com.tydic.uccext.bo.UccPreProcessAuditRspBO;
import com.tydic.uccext.bo.UccZoneGoodsManualShutAbilityReqBO;
import com.tydic.uccext.bo.UccZoneGoodsManualShutAbilityRspBO;
import com.tydic.uccext.service.UccPreProcessAuditBusiService;
import com.tydic.uccext.service.UccZoneGoodsManualShutAbilityService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccZoneGoodsManualShutAbilityService"})
public class UccZoneGoodsManualShutAbilityServiceImpl
implements UccZoneGoodsManualShutAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccZoneGoodsReopenAbilityServiceImpl.class);
    @Autowired
    private UccPreProcessAuditBusiService preProcessAuditBusiService;
    @Value(value="${ZONE_GOODS_MANUAL_SHUT_DEF_ID}")
    private String processDefId;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccSkuMapper skuMapper;
    @Autowired
    private BatchUpdateCommoStatusForMarketService statusForMarketService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private ProperticeVo properticeVo;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealUccZoneGoodsManualShut"})
    public UccZoneGoodsManualShutAbilityRspBO dealUccZoneGoodsManualShut(@RequestBody UccZoneGoodsManualShutAbilityReqBO reqBO) {
        UccZoneGoodsManualShutAbilityRspBO rspBO = new UccZoneGoodsManualShutAbilityRspBO();
        UccPreProcessAuditReqBO preProcessAuditReqBO = new UccPreProcessAuditReqBO();
        preProcessAuditReqBO.setSyncAdtFlag(Integer.valueOf(0));
        preProcessAuditReqBO.setSkuIds(reqBO.getSkuIds());
        List supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isNotEmpty((Collection)supplierShopPos)) {
            preProcessAuditReqBO.setSupplierShopId(((SupplierShopPo)supplierShopPos.get(0)).getSupplierShopId());
            reqBO.setSupplierShopId(((SupplierShopPo)supplierShopPos.get(0)).getSupplierShopId());
        }
        preProcessAuditReqBO.setObjType(Integer.valueOf(ApprovalTypeEnum.APPROVAL_DOWN_SHELF.getStep()));
        preProcessAuditReqBO.setProcessDefId(this.processDefId);
        preProcessAuditReqBO.setSupplierId(reqBO.getSupplierId());
        HashMap<Integer, SkuStatusEnum> map = new HashMap<Integer, SkuStatusEnum>();
        map.put(SkuStatusEnum.ON_SHELVES_STATUS.getStatus(), SkuStatusEnum.ON_SHELVES_STATUS);
        preProcessAuditReqBO.setCurrentStatus(map);
        preProcessAuditReqBO.setStatus(SkuStatusEnum.DOWN_FRAME_STATUS);
        UccPreProcessAuditRspBO uccPreProcessAuditRspBO = this.preProcessAuditBusiService.dealCheckParameters(preProcessAuditReqBO);
        if ("8888".equals(uccPreProcessAuditRspBO.getRespCode())) {
            throw new BusinessException("8888", uccPreProcessAuditRspBO.getRespDesc());
        }
        preProcessAuditReqBO.setSkuAndCommodity(uccPreProcessAuditRspBO.getAgreementAndCommodityBOS());
        UccPreProcessAuditRspBO preProcessAuditRspBO = this.preProcessAuditBusiService.dealPreProcessAudit(preProcessAuditReqBO);
        if ("8888".equals(preProcessAuditRspBO.getRespCode())) {
            throw new BusinessException("8888", preProcessAuditRspBO.getRespDesc());
        }
        UccCommodityPo commodityPo = null;
        for (Object uccGoodsAgreementAndCommodityBO : uccPreProcessAuditRspBO.getAgreementAndCommodityBOS()) {
            commodityPo = this.uccCommodityMapper.getCommodityById(uccGoodsAgreementAndCommodityBO.getCommodityId());
            CommodityBo commodityBo = new CommodityBo();
            BeanUtils.copyProperties((Object)commodityPo, (Object)commodityBo);
            commodityBo.setCommodityStatus(null);
            commodityBo.setApprovalStatus(preProcessAuditRspBO.getStepId());
            this.statusForMarketService.updateCommoApprovalStatus(commodityBo, AuditResultStatusEnum.Audit_Pass);
        }
        UccSkuPo skuPo = new UccSkuPo();
        for (Long skuId : reqBO.getSkuIds()) {
            skuPo.setSkuId(skuId);
            skuPo.setSupplierShopId(preProcessAuditReqBO.getSupplierShopId());
            skuPo.setRemark(reqBO.getApprovalRemark());
            this.skuMapper.updateSku(skuPo);
        }
        Long[] businessId = new Long[uccPreProcessAuditRspBO.getAgreementAndCommodityBOS().size()];
        for (int i = 0; i < uccPreProcessAuditRspBO.getAgreementAndCommodityBOS().size(); ++i) {
            businessId[i] = ((UccGoodsAgreementAndCommodityBO)uccPreProcessAuditRspBO.getAgreementAndCommodityBOS().get(i)).getCommodityId();
        }
        BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
        batchUpdateCommoStatusForMarketBO.setReason(reqBO.getApprovalRemark());
        batchUpdateCommoStatusForMarketBO.setBusinessId(businessId);
        this.statusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.FROZEN_STATUS, SkuStatusEnum.FROZEN_STATUS);
        UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
        List agreementDetailIdsString = uccPreProcessAuditRspBO.getAgreementAndCommodityBOS().stream().map(UccGoodsAgreementAndCommodityBO::getAgreementDetailsId).collect(Collectors.toList());
        try {
            notifyMessageBO.setStationCode(preProcessAuditRspBO.getNextStationCode());
            notifyMessageBO.setAgreementId(commodityPo.getAgreementId());
            notifyMessageBO.setAgreementSkuIds(agreementDetailIdsString);
            notifyMessageBO.setAgreementSkuStatus("8");
            notifyMessageBO.setAuditStatus("2");
            notifyMessageBO.setMemIdIn(reqBO.getUserId());
            notifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_DOWN_SHELF.code());
            LOGGER.info("\u5ba1\u6279\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
            this.zoneGoodsAuditMQ.send(new ProxyMessage(this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TOPIC"), this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
        }
        catch (Exception var16) {
            LOGGER.error("\u4e0b\u67b6\uff0c\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
            throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
        }
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList((Iterable)reqBO.getSkuIds()));
        syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierShopId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
        LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            LOGGER.error("\u624b\u5de5\u4e0b\u67b6\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
            throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

