/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccCommodityUpReqBO;
import com.tydic.commodity.bo.busi.UccCommodityUpRspBO;
import com.tydic.commodity.bo.busi.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.busi.api.UccCommodityUpBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.uac.config.ProperticeVo;
import com.tydic.uccext.bo.UccZoneGoodsTimeOnAbilityReqBO;
import com.tydic.uccext.bo.UccZoneGoodsTimeOnAbilityRspBO;
import com.tydic.uccext.service.UccZoneGoodsTimeOnAbilityService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccZoneGoodsTimeOnAbilityService"})
public class UccZoneGoodsTimeOnAbilityServiceImpl
implements UccZoneGoodsTimeOnAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccZoneGoodsTimeOnAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityUpBusiService uccCommodityUpBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private ProperticeVo properticeVo;

    @PostMapping(value={"dealUccZoneGoodsUp"})
    public UccZoneGoodsTimeOnAbilityRspBO dealUccZoneGoodsUp(@RequestBody UccZoneGoodsTimeOnAbilityReqBO reqBO) {
        UccZoneGoodsTimeOnAbilityRspBO rspBO = new UccZoneGoodsTimeOnAbilityRspBO();
        List uccSkuPos = this.uccSkuMapper.selectSkuPutCir();
        if (CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
            Map<Long, List<UccSkuPo>> map = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Map.Entry<Long, List<UccSkuPo>> each : map.entrySet()) {
                Long supplierShopId = each.getKey();
                List skuIds = each.getValue().stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                UccCommodityUpReqBO uccCommodityUpReqBO = new UccCommodityUpReqBO();
                uccCommodityUpReqBO.setUpType(Integer.valueOf(2));
                uccCommodityUpReqBO.setSupplierShopId(supplierShopId);
                uccCommodityUpReqBO.setRemark("\u5b9a\u65f6\u4e0b\u67b6");
                uccCommodityUpReqBO.setSkuIds(skuIds);
                uccCommodityUpReqBO.setShelfSource("linkmall");
                UccCommodityUpRspBO uccCommodityUpRspBO = this.uccCommodityUpBusiService.dealCommodityUp(uccCommodityUpReqBO);
                if (!"0000".equals(uccCommodityUpRspBO.getRespCode())) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc(uccCommodityUpRspBO.getRespDesc());
                    return rspBO;
                }
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    LOGGER.error("\u5b9a\u65f6\u4e0a\u67b6\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                    throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                }
                for (Long skuId : skuIds) {
                    UccSkuPo skuPo = new UccSkuPo();
                    skuPo.setSkuId(skuId);
                    List skuPos = this.uccSkuMapper.qerySku(skuPo);
                    if (!CollectionUtils.isNotEmpty((Collection)skuPos)) continue;
                    UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
                    UccSkuPo uccSkuPo = (UccSkuPo)skuPos.get(0);
                    if (uccSkuPo.getAgreementDetailsId() == null || uccSkuPo.getAgreementId() == null) continue;
                    try {
                        notifyMessageBO.setAuditStatus("1");
                        notifyMessageBO.setAgreementId(String.valueOf(uccSkuPo.getAgreementId()));
                        notifyMessageBO.setAgreementSkuIds((List)Lists.newArrayList((Object[])new String[]{String.valueOf(uccSkuPo.getAgreementDetailsId())}));
                        notifyMessageBO.setAgreementSkuStatus("3");
                        notifyMessageBO.setMemIdIn(reqBO.getUserId());
                        notifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_UP_SHELF.code());
                        LOGGER.info("\u81ea\u52a8\u4e0a\u67b6\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
                        this.zoneGoodsAuditMQ.send(new ProxyMessage(this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TOPIC"), this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
                    }
                    catch (Exception var16) {
                        LOGGER.error("\u81ea\u52a8\u4e0a\u67b6\u6570\u636e\uff0c\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
                        throw new BusinessException("8888", "\u81ea\u52a8\u4e0a\u67b6\u534f\u8bae\u6d88\u606f\u5931\u8d25");
                    }
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

