/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.ability.api.UccCommodityListsAbilityService;
import com.tydic.commodity.bo.ability.UccCommodityAndSkusDetailRspBO;
import com.tydic.commodity.bo.ability.UccCommodityInfoListsReqBO;
import com.tydic.commodity.bo.ability.UccCommodityInfoListsRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.uccext.bo.UccCommdGiftInfoBO;
import com.tydic.uccext.bo.UccCommodityExtInfoBO;
import com.tydic.uccext.bo.UccextCommodityInfoListsReqBO;
import com.tydic.uccext.bo.UccextCommodityInfoListsRspBO;
import com.tydic.uccext.dao.StoreSkuSaleNumMapper;
import com.tydic.uccext.dao.UccGuideCatalogExtMapper;
import com.tydic.uccext.dao.UccMaterialTypeMapper;
import com.tydic.uccext.dao.UccRelSkuGiftsMapper;
import com.tydic.uccext.dao.po.StoreSkuSaleNumPO;
import com.tydic.uccext.service.UccextCommodityListsAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccextCommodityListsAbilityService"})
public class UccextCommodityListsAbilityServiceImpl
implements UccextCommodityListsAbilityService {
    @Autowired
    private UccCommodityListsAbilityService uccCommodityListsAbilityService;
    @Autowired
    private UccRelSkuGiftsMapper uccRelSkuGiftsMapper;
    @Autowired
    private UccGuideCatalogExtMapper uccGuideCatalogExtMapper;
    @Autowired
    private UccMaterialTypeMapper uccMaterialTypeMapper;
    @Autowired
    private StoreSkuSaleNumMapper storeSkuSaleNumMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"queryCommodityListsInfo"})
    public UccextCommodityInfoListsRspBO queryCommodityListsInfo(@RequestBody UccextCommodityInfoListsReqBO reqBo) {
        UccextCommodityInfoListsRspBO rspBo = new UccextCommodityInfoListsRspBO();
        HashMap skuIdBuyNum = new HashMap(16);
        reqBo.getSkusDetailListReqBOS().forEach(skuReqBo -> skuIdBuyNum.putAll(skuReqBo.getSkuInfo()));
        if (!CollectionUtils.isEmpty(skuIdBuyNum) && null != reqBo.getOrgIdIn()) {
            List skuPoList = this.uccSkuMapper.qeryBatchSkus(new ArrayList(skuIdBuyNum.keySet()));
            List<StoreSkuSaleNumPO> storeSkuSaleNumList = this.storeSkuSaleNumMapper.getListBySku(new ArrayList<Long>(skuIdBuyNum.keySet()), reqBo.getOrgIdIn().toString());
            Map<Long, List<StoreSkuSaleNumPO>> storeSaleNumBySkuId = storeSkuSaleNumList.stream().collect(Collectors.groupingBy(StoreSkuSaleNumPO::getSkuId));
            if (!CollectionUtils.isEmpty((Collection)skuPoList)) {
                for (UccSkuPo sku : skuPoList) {
                    BigDecimal buyNum = (BigDecimal)skuIdBuyNum.get(sku.getSkuId());
                    BigDecimal moq = sku.getMoq();
                    BigDecimal maxoq = sku.getMaxoq();
                    if (null != moq && BigDecimal.ZERO.compareTo(moq) < 0 && buyNum.compareTo(moq) < 0) {
                        rspBo.setRespCode("8888");
                        rspBo.setRespDesc("\u5546\u54c1[" + sku.getSkuName() + "]\u4e0d\u6ee1\u8db3\u6700\u5c0f\u8d77\u8ba2\u91cf");
                        return rspBo;
                    }
                    if (null != maxoq && BigDecimal.ZERO.compareTo(maxoq) < 0 && buyNum.compareTo(maxoq) > 0) {
                        rspBo.setRespCode("8888");
                        rspBo.setRespDesc("\u5546\u54c1[" + sku.getSkuName() + "]\u8d85\u8fc7\u4e86\u6700\u5927\u8d77\u8ba2\u91cf");
                        return rspBo;
                    }
                    BigDecimal limitCount = sku.getLimitCount();
                    BigDecimal saleNum = BigDecimal.ZERO;
                    List<StoreSkuSaleNumPO> storeSkuSaleNumPos = storeSaleNumBySkuId.get(sku.getSkuId());
                    if (!CollectionUtils.isEmpty(storeSkuSaleNumPos)) {
                        saleNum = storeSkuSaleNumPos.get(0).getSaleNum();
                    }
                    if (null == limitCount || BigDecimal.ZERO.compareTo(limitCount) >= 0 || limitCount.compareTo(saleNum.add(buyNum)) >= 0) continue;
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc("\u5546\u54c1[" + sku.getSkuName() + "]\u8d85\u8fc7\u4e86\u9650\u8d2d\u91cf");
                    return rspBo;
                }
            }
        }
        UccCommodityInfoListsRspBO commodityInfoListsRspBo = this.uccCommodityListsAbilityService.queryCommodityListsInfo((UccCommodityInfoListsReqBO)reqBo);
        BeanUtils.copyProperties((Object)commodityInfoListsRspBo, (Object)rspBo);
        if (!"0000".equals(commodityInfoListsRspBo.getRespCode())) {
            return rspBo;
        }
        List<Long> commodityIdList = commodityInfoListsRspBo.getUccCommodityAndSkusDetailRspBOS().stream().map(UccCommodityAndSkusDetailRspBO::getCommodityId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(commodityIdList)) {
            List<UccCommodityExtInfoBO> materialTypeList;
            List<UccCommodityExtInfoBO> catalogByComIds;
            ArrayList extInfoList = new ArrayList();
            commodityIdList.forEach(id -> {
                UccCommodityExtInfoBO extInfoBo = new UccCommodityExtInfoBO();
                extInfoBo.setCommodityId(id);
                extInfoList.add(extInfoBo);
            });
            List<UccCommdGiftInfoBO> giftInfo = this.uccRelSkuGiftsMapper.getGiftInfoBySkuIds(commodityIdList);
            if (!CollectionUtils.isEmpty(giftInfo)) {
                extInfoList.forEach(extInfo -> {
                    for (UccCommdGiftInfoBO info : giftInfo) {
                        if (!extInfo.getCommodityId().equals(info.getCommodityId())) continue;
                        extInfo.setGiftInfo(info);
                        break;
                    }
                });
            }
            if (!CollectionUtils.isEmpty(catalogByComIds = this.uccGuideCatalogExtMapper.getCatalogByComIds(commodityIdList))) {
                extInfoList.forEach(extInfo -> {
                    for (UccCommodityExtInfoBO catalog : catalogByComIds) {
                        if (!extInfo.getCommodityId().equals(catalog.getCommodityId())) continue;
                        extInfo.setCatalogIdL3(catalog.getCatalogIdL3());
                        extInfo.setCatalogNameL3(catalog.getCatalogNameL3());
                        extInfo.setCatalogIdL2(catalog.getCatalogIdL2());
                        extInfo.setCatalogNameL2(catalog.getCatalogNameL2());
                        extInfo.setCatalogIdL1(catalog.getCatalogIdL1());
                        extInfo.setCatalogNameL1(catalog.getCatalogNameL1());
                        break;
                    }
                });
            }
            if (!CollectionUtils.isEmpty(materialTypeList = this.uccMaterialTypeMapper.getListByComIds(commodityIdList))) {
                extInfoList.forEach(extInfo -> {
                    for (UccCommodityExtInfoBO materialType : materialTypeList) {
                        if (!extInfo.getCommodityId().equals(materialType.getCommodityId())) continue;
                        extInfo.setMaterialTypeId(materialType.getMaterialTypeId());
                        extInfo.setMaterialTypeName(materialType.getMaterialTypeName());
                        break;
                    }
                });
            }
            rspBo.setExtInfo(extInfoList);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

