/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl.supply;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.ListUtils;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.supply.UccCommoditySyncSupplierInfoBO;
import com.tydic.uccext.bo.supply.UccDealCommoditySupplierSyncAbilityReqBO;
import com.tydic.uccext.bo.supply.UccDealCommoditySupplierSyncAbilityRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccExtLadderPriceMapper;
import com.tydic.uccext.dao.UccRelSkuSupskuMapper;
import com.tydic.uccext.dao.po.UccRelSkuSupskuPO;
import com.tydic.uccext.service.supply.UccDealCommoditySupplierSyncAbilityService;
import com.tydic.uccext.service.supply.UccDealCommoditySupplierSyncBusiService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.supply.UccDealCommoditySupplierSyncAbilityService"})
public class UccDealCommoditySupplierSyncAbilityServiceImpl
implements UccDealCommoditySupplierSyncAbilityService {
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccRelSkuSupskuMapper uccRelSkuSupskuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccExtLadderPriceMapper uccExtLadderPriceMapper;
    @Autowired
    private UccDealCommoditySupplierSyncBusiService uccDealCommoditySupplierSyncBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealCommoditySupplierSync"})
    public UccDealCommoditySupplierSyncAbilityRspBO dealCommoditySupplierSync(@RequestBody UccDealCommoditySupplierSyncAbilityReqBO reqBo) {
        List commodityIdList;
        Map batchList;
        UccDealCommoditySupplierSyncAbilityRspBO rspBo = new UccDealCommoditySupplierSyncAbilityRspBO();
        if (null == reqBo || CollectionUtils.isEmpty((Collection)reqBo.getSyncInfoList())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u540c\u6b65\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        reqBo.setSyncInfoList(reqBo.getSyncInfoList().stream().distinct().collect(Collectors.toList()));
        Integer operTypeCreate = 0;
        Integer operTypeCancel = 1;
        for (UccCommoditySyncSupplierInfoBO each : reqBo.getSyncInfoList()) {
            UccLadderPricePO uccLadderPricePo;
            List<UccLadderPricePO> minPriceBySkuList;
            if (null == each.getCommodityId() || null == each.getOperType() || !StringUtils.hasText((String)each.getSupplierId())) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u540c\u6b65\u4fe1\u606f\u4e2d\u5546\u54c1ID\u3001\u4f9b\u8d27\u5546ID\u3001\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBo;
            }
            if (!operTypeCreate.equals(each.getOperType()) && !operTypeCancel.equals(each.getOperType())) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                return rspBo;
            }
            if (!operTypeCreate.equals(each.getOperType())) continue;
            if (null == each.getSupplyPrice() || !StringUtils.hasText((String)each.getSupplierName())) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u540c\u6b65\u4fe1\u606f\u4e2d\u4f9b\u8d27\u4ef7\u3001\u4f9b\u8d27\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBo;
            }
            if (BigDecimal.ZERO.compareTo(each.getSupplyPrice()) >= 0) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u540c\u6b65\u4fe1\u606f\u4e2d\u4f9b\u8d27\u4ef7\u5fc5\u987b\u5927\u4e8e\u96f6");
                return rspBo;
            }
            List<UccRelSkuSupskuPO> listBySkuIds = this.uccRelSkuSupskuMapper.getListBySkuIds(Collections.singletonList(each.getCommodityId()), each.getSupplierId());
            if (!CollectionUtils.isEmpty(listBySkuIds)) {
                UccCommodityPo commodity = this.uccCommodityMapper.getCommodityById(each.getCommodityId());
                String desc = "\u8be5\u5546\u54c1\u5df2\u5b58\u5728\u4f9b\u5e94\u4fe1\u606f\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0\u4f9b\u5e94";
                if (null != commodity) {
                    desc = "\u7f16\u7801\uff1a" + commodity.getCommodityCode() + "\uff0c\u540d\u79f0\uff1a" + commodity.getCommodityName() + "\uff0c" + desc;
                }
                rspBo.setRespCode("8888");
                rspBo.setRespDesc(desc);
                return rspBo;
            }
            BigDecimal salePrice = null;
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            uccSkuPricePo.setSkuId(each.getCommodityId());
            uccSkuPricePo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
            UccSkuPricePo skuPricePo = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
            if (null != skuPricePo && null != skuPricePo.getSalePrice()) {
                salePrice = MoneyUtils.haoToYuan((Long)skuPricePo.getSalePrice());
            }
            if (!CollectionUtils.isEmpty(minPriceBySkuList = this.uccExtLadderPriceMapper.getListForMinPriceBySkuList(Collections.singletonList(each.getCommodityId()))) && null != (uccLadderPricePo = minPriceBySkuList.get(0)).getPrice()) {
                BigDecimal minLadderPrice = MoneyUtils.haoToYuan((Long)uccLadderPricePo.getPrice());
                if (null != salePrice && null != minLadderPrice && minLadderPrice.compareTo(salePrice) < 0) {
                    salePrice = minLadderPrice;
                } else if (null == salePrice && null != minLadderPrice) {
                    salePrice = minLadderPrice;
                }
            }
            if (null == salePrice || salePrice.compareTo(each.getSupplyPrice()) >= 0) continue;
            UccCommodityPo commodity = this.uccCommodityMapper.getCommodityById(each.getCommodityId());
            String desc = "\u8be5\u5546\u54c1\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u5927\u4e8e\u6700\u4f4e\u9500\u552e\u4ef7:" + salePrice.toPlainString() + "\u5143";
            if (null != commodity) {
                desc = "\u7f16\u7801\uff1a" + commodity.getCommodityCode() + "\uff0c\u540d\u79f0\uff1a" + commodity.getCommodityName() + "\uff0c" + desc;
            }
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(desc);
            return rspBo;
        }
        rspBo = this.uccDealCommoditySupplierSyncBusiService.dealCommoditySupplierSync(reqBo);
        if ("0000".equals(rspBo.getRespCode()) && !CollectionUtils.isEmpty((Map)(batchList = ListUtils.batchList(commodityIdList = reqBo.getSyncInfoList().stream().map(UccCommoditySyncSupplierInfoBO::getCommodityId).collect(Collectors.toList()), (int)200)))) {
            batchList.forEach((index, list) -> {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBo.setCommodityIds(list);
                syncSceneCommodityToEsReqBo.setSupplierId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
                syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
            });
        }
        return rspBo;
    }
}

