/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl.supply;

import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.supply.UccCommodityByCodeListBO;
import com.tydic.uccext.bo.supply.UccQryCommodityByCodeListAbilityReqBO;
import com.tydic.uccext.bo.supply.UccQryCommodityByCodeListAbilityRspBO;
import com.tydic.uccext.dao.UccCommodityExtMapper;
import com.tydic.uccext.dao.UccExtLadderPriceMapper;
import com.tydic.uccext.service.supply.UccQryCommodityByCodeListAbilityService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.supply.UccQryCommodityByCodeListAbilityService"})
public class UccQryCommodityByCodeListAbilityServiceImpl
implements UccQryCommodityByCodeListAbilityService {
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;
    @Autowired
    private UccExtLadderPriceMapper uccExtLadderPriceMapper;

    @PostMapping(value={"qryCommodityByCodeList"})
    public UccQryCommodityByCodeListAbilityRspBO qryCommodityByCodeList(@RequestBody UccQryCommodityByCodeListAbilityReqBO reqBo) {
        UccQryCommodityByCodeListAbilityRspBO rspBo = new UccQryCommodityByCodeListAbilityRspBO();
        if (null == reqBo) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getCommodityCodeList()) && CollectionUtils.isEmpty((Collection)reqBo.getCommodityIdList())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5546\u54c1ID\u5217\u8868\u548c\u5546\u54c1\u7f16\u7801\u5217\u8868\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            return rspBo;
        }
        List<UccCommodityByCodeListBO> infoByCommodityList = this.uccCommodityExtMapper.getInfoByCommodityList(reqBo.getSupplierId(), reqBo.getCommodityIdList(), reqBo.getCommodityCodeList());
        if (!CollectionUtils.isEmpty(infoByCommodityList)) {
            List<Long> skuIdList = infoByCommodityList.stream().map(UccCommodityByCodeListBO::getSkuId).collect(Collectors.toList());
            Date now = new Date();
            infoByCommodityList.forEach(each -> {
                each.setSalePrice(null == each.getSalePrice() ? null : MoneyUtils.haoToYuan((BigDecimal)each.getSalePrice()));
                each.setSupplyPrice(null == each.getSupplyPrice() ? null : MoneyUtils.haoToYuan((BigDecimal)each.getSupplyPrice()));
                if (null != each.getExpTime() && each.getExpTime().before(now)) {
                    each.setGiftId(null);
                    each.setGiftName(null);
                    each.setRuleBuyCount(null);
                    each.setRulePresentCount(null);
                    each.setEffTime(null);
                    each.setExpTime(null);
                }
            });
            List<UccLadderPricePO> minPriceList = this.uccExtLadderPriceMapper.getListForMinPriceBySkuList(skuIdList);
            if (!CollectionUtils.isEmpty(minPriceList)) {
                infoByCommodityList.forEach(com -> {
                    for (UccLadderPricePO min : minPriceList) {
                        if (!com.getSkuId().equals(min.getSkuId()) || null == min.getPrice() || null == com.getSalePrice()) continue;
                        BigDecimal minLadderPrice = MoneyUtils.haoToYuan((Long)min.getPrice());
                        if (minLadderPrice.compareTo(com.getSalePrice()) >= 0) break;
                        com.setMinSalePrice(minLadderPrice);
                        break;
                    }
                });
            }
        }
        rspBo.setCommodityList(infoByCommodityList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

