/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl.supply;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.supply.UccCommoditySupplierBO;
import com.tydic.uccext.bo.supply.UccQryCommoditySupplierListAbilityReqBO;
import com.tydic.uccext.bo.supply.UccQryCommoditySupplierListAbilityRspBO;
import com.tydic.uccext.dao.UccSupplyInfoMapper;
import com.tydic.uccext.service.supply.UccQryCommoditySupplierListAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.supply.UccQryCommoditySupplierListAbilityService"})
public class UccQryCommoditySupplierListAbilityServiceImpl
implements UccQryCommoditySupplierListAbilityService {
    @Autowired
    private UccSupplyInfoMapper uccSupplyInfoMapper;

    @PostMapping(value={"qryCommoditySupplierList"})
    public UccQryCommoditySupplierListAbilityRspBO qryCommoditySupplierList(@RequestBody UccQryCommoditySupplierListAbilityReqBO reqBo) {
        UccQryCommoditySupplierListAbilityRspBO rspBo = new UccQryCommoditySupplierListAbilityRspBO();
        if (null == reqBo || null == reqBo.getCommodityId()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (1 > reqBo.getPageNo()) {
            reqBo.setPageNo(1);
        }
        if (1 > reqBo.getPageSize()) {
            reqBo.setPageSize(10);
        }
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List<UccCommoditySupplierBO> supplyInfoList = this.uccSupplyInfoMapper.getSupplyInfoBySkuId(reqBo.getCommodityId(), (Page<UccCommoditySupplierBO>)page);
        ArrayList<UccCommoditySupplierBO> commoditySupplierList = new ArrayList<UccCommoditySupplierBO>();
        if (!CollectionUtils.isEmpty(supplyInfoList)) {
            supplyInfoList.forEach(info -> info.setSupplyPrice(null == info.getSupplyPrice() ? null : MoneyUtils.haoToYuan((BigDecimal)info.getSupplyPrice())));
            commoditySupplierList.addAll(supplyInfoList);
        }
        rspBo.setRows(commoditySupplierList);
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

