/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl.supply;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.dao.UccDicDictionaryMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.enumType.SkuEnum;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.supply.UccQrySupplyCommodityListAbilityReqBO;
import com.tydic.uccext.bo.supply.UccQrySupplyCommodityListAbilityRspBO;
import com.tydic.uccext.bo.supply.UccSupplyCommodityListBO;
import com.tydic.uccext.dao.UccCommodityExtMapper;
import com.tydic.uccext.dao.UccExtLadderPriceMapper;
import com.tydic.uccext.service.supply.UccQrySupplyCommodityListAbilityService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.supply.UccQrySupplyCommodityListAbilityService"})
public class UccQrySupplyCommodityListAbilityServiceImpl
implements UccQrySupplyCommodityListAbilityService {
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;
    @Autowired
    private UccExtLadderPriceMapper uccExtLadderPriceMapper;

    @PostMapping(value={"qrySupplyCommodityList"})
    public UccQrySupplyCommodityListAbilityRspBO qrySupplyCommodityList(@RequestBody UccQrySupplyCommodityListAbilityReqBO reqBo) {
        Page page;
        List<UccSupplyCommodityListBO> supplyCommodityList;
        UccQrySupplyCommodityListAbilityRspBO rspBo = new UccQrySupplyCommodityListAbilityRspBO();
        if (null == reqBo) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (null == reqBo.getMaterialType()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u7269\u8d44\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u4f9b\u5e94\u5546\u7269\u8d44\u7c7b\u578b\u4fe1\u606f");
            return rspBo;
        }
        if (!StringUtils.hasText((String)reqBo.getSupplierId())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u4f9b\u8d27\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (1 > reqBo.getPageNo()) {
            reqBo.setPageNo(1);
        }
        if (1 > reqBo.getPageSize()) {
            reqBo.setPageSize(10);
        }
        if (!CollectionUtils.isEmpty(supplyCommodityList = this.uccCommodityExtMapper.getSupplyCommodityList(reqBo, (Page<UccSupplyCommodityListBO>)(page = new Page(reqBo.getPageNo(), reqBo.getPageSize()))))) {
            List<UccLadderPricePO> minPriceList;
            List dicDictionaryPos = this.uccDicDictionaryMapper.selectByPCode(SkuEnum.SKU_STATUS.toString());
            supplyCommodityList.forEach(com -> {
                if (!CollectionUtils.isEmpty((Collection)dicDictionaryPos)) {
                    for (DicDictionaryPo dic : dicDictionaryPos) {
                        if (null == com.getStatus() || !StringUtils.hasText((String)dic.getCode()) || !dic.getCode().equals(com.getStatus().toString())) continue;
                        com.setStatusDesc(dic.getTitle());
                        break;
                    }
                }
                com.setSalePrice(null == com.getSalePrice() ? null : MoneyUtils.haoToYuan((BigDecimal)com.getSalePrice()));
                com.setIsSupplied(Boolean.valueOf(com.getSupplierIds().contains(reqBo.getSupplierId())));
            });
            List<Long> commodityIdList = supplyCommodityList.stream().map(UccSupplyCommodityListBO::getCommodityId).collect(Collectors.toList());
            List<Long> skuIdList = supplyCommodityList.stream().map(UccSupplyCommodityListBO::getSkuId).collect(Collectors.toList());
            List<UccSupplyCommodityListBO> supplyCommodityListGiftInfo = this.uccCommodityExtMapper.getSupplyCommodityListGiftInfo(commodityIdList);
            if (!CollectionUtils.isEmpty(supplyCommodityListGiftInfo)) {
                Date now = new Date();
                supplyCommodityList.forEach(com -> {
                    for (UccSupplyCommodityListBO gift : supplyCommodityListGiftInfo) {
                        if (!com.getCommodityId().equals(gift.getCommodityId())) continue;
                        if (null != gift.getExpTime() && gift.getExpTime().before(now)) break;
                        com.setGiftId(gift.getGiftId());
                        com.setGiftName(gift.getGiftName());
                        com.setEffTime(gift.getEffTime());
                        com.setExpTime(gift.getExpTime());
                        com.setRuleBuyCount(gift.getRuleBuyCount());
                        com.setRulePresentCount(gift.getRulePresentCount());
                        break;
                    }
                });
            }
            if (!CollectionUtils.isEmpty(minPriceList = this.uccExtLadderPriceMapper.getListForMinPriceBySkuList(skuIdList))) {
                supplyCommodityList.forEach(com -> {
                    for (UccLadderPricePO min : minPriceList) {
                        if (!com.getSkuId().equals(min.getSkuId()) || null == min.getPrice() || null == com.getSalePrice()) continue;
                        BigDecimal minLadderPrice = MoneyUtils.haoToYuan((Long)min.getPrice());
                        if (minLadderPrice.compareTo(com.getSalePrice()) >= 0) break;
                        com.setMinSalePrice(minLadderPrice);
                        break;
                    }
                });
            }
        }
        rspBo.setRows(supplyCommodityList);
        rspBo.setPageNo(page.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

