/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl.supply;

import com.tydic.uccext.bo.UccCommodityExtInfoBO;
import com.tydic.uccext.bo.supply.UccUpdateCommodityLabelAbilityReqBO;
import com.tydic.uccext.bo.supply.UccUpdateCommodityLabelAbilityRspBO;
import com.tydic.uccext.dao.UccRelSkuSupskuMapper;
import com.tydic.uccext.service.supply.UccUpdateCommodityLabelAbilityService;
import com.tydic.uccext.service.supply.UccUpdateCommodityLabelBusiService;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.supply.UccUpdateCommodityLabelAbilityService"})
public class UccUpdateCommodityLabelAbilityServiceImpl
implements UccUpdateCommodityLabelAbilityService {
    @Autowired
    private UccUpdateCommodityLabelBusiService uccUpdateCommodityLabelBusiService;
    @Autowired
    private UccRelSkuSupskuMapper uccRelSkuSupskuMapper;

    @PostMapping(value={"updateCommodityLabel"})
    public UccUpdateCommodityLabelAbilityRspBO updateCommodityLabel(@RequestBody UccUpdateCommodityLabelAbilityReqBO reqBo) {
        UccUpdateCommodityLabelAbilityRspBO rspBo = new UccUpdateCommodityLabelAbilityRspBO();
        if (null == reqBo || CollectionUtils.isEmpty((Collection)reqBo.getCommodityIdList()) || null == reqBo.getOperType() || !StringUtils.hasText((String)reqBo.getSupplierId()) || null == reqBo.getLabelType() || null == reqBo.getLabelValue()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5546\u54c1ID\u5217\u8868\u3001\u64cd\u4f5c\u7c7b\u578b\u3001\u4f9b\u8d27\u5546ID\u3001\u6807\u8bc6\u7c7b\u578b\u3001\u6807\u8bc6\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        Integer operTypeCreate = 0;
        Integer operTypeCancel = 1;
        if (!operTypeCreate.equals(reqBo.getOperType()) && !operTypeCancel.equals(reqBo.getOperType())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
            return rspBo;
        }
        Integer labelTypeRebate = 1;
        Integer labelTypePrepayment = 2;
        if (!labelTypeRebate.equals(reqBo.getLabelType()) && !labelTypePrepayment.equals(reqBo.getLabelType())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u77e5\u7684\u6807\u8bc6\u7c7b\u578b");
            return rspBo;
        }
        List<UccCommodityExtInfoBO> supplierInfoBySkuIds = this.uccRelSkuSupskuMapper.getSupplierInfoBySkuIds(reqBo.getCommodityIdList(), reqBo.getSupplierId());
        if (CollectionUtils.isEmpty(supplierInfoBySkuIds)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4f9b\u8d27\u4fe1\u606f");
            return rspBo;
        }
        List commodityIdList = supplierInfoBySkuIds.stream().map(UccCommodityExtInfoBO::getCommodityId).collect(Collectors.toList());
        List collect = reqBo.getCommodityIdList().stream().filter(id -> !commodityIdList.contains(id)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            StringJoiner sj = new StringJoiner(",", "[", "]");
            collect.stream().map(Object::toString).forEach(sj::add);
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4f9b\u8d27\u4fe1\u606f" + sj.toString());
            return rspBo;
        }
        return this.uccUpdateCommodityLabelBusiService.updateCommodityLabel(reqBo);
    }
}

