/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl.supply;

import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.supply.UccUpdateSupplyPriceAbilityReqBO;
import com.tydic.uccext.bo.supply.UccUpdateSupplyPriceAbilityRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccExtLadderPriceMapper;
import com.tydic.uccext.service.supply.UccUpdateSupplyPriceAbilityService;
import com.tydic.uccext.service.supply.UccUpdateSupplyPriceBusiService;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.supply.UccUpdateSupplyPriceAbilityService"})
public class UccUpdateSupplyPriceAbilityServiceImpl
implements UccUpdateSupplyPriceAbilityService {
    @Autowired
    private UccUpdateSupplyPriceBusiService uccUpdateSupplyPriceBusiService;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccExtLadderPriceMapper uccExtLadderPriceMapper;

    @PostMapping(value={"updateSupplyPrice"})
    public UccUpdateSupplyPriceAbilityRspBO updateSupplyPrice(@RequestBody UccUpdateSupplyPriceAbilityReqBO reqBo) {
        UccLadderPricePO uccLadderPricePo;
        List<UccLadderPricePO> minPriceBySkuList;
        UccUpdateSupplyPriceAbilityRspBO rspBo = new UccUpdateSupplyPriceAbilityRspBO();
        if (null == reqBo || null == reqBo.getCommodityId() || !StringUtils.hasText((String)reqBo.getSupplierId()) || null == reqBo.getSupplyPrice()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5546\u54c1ID\u3001\u4f9b\u8d27\u5546ID\u3001\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (BigDecimal.ZERO.compareTo(reqBo.getSupplyPrice()) >= 0) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u4f9b\u8d27\u4ef7\u5fc5\u987b\u5927\u4e8e\u96f6");
            return rspBo;
        }
        BigDecimal salePrice = null;
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        uccSkuPricePo.setSkuId(reqBo.getCommodityId());
        uccSkuPricePo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
        UccSkuPricePo skuPricePo = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
        if (null != skuPricePo && null != skuPricePo.getSalePrice()) {
            salePrice = MoneyUtils.haoToYuan((Long)skuPricePo.getSalePrice());
        }
        if (!CollectionUtils.isEmpty(minPriceBySkuList = this.uccExtLadderPriceMapper.getListForMinPriceBySkuList(Collections.singletonList(reqBo.getCommodityId()))) && null != (uccLadderPricePo = minPriceBySkuList.get(0)).getPrice()) {
            BigDecimal minLadderPrice = MoneyUtils.haoToYuan((Long)uccLadderPricePo.getPrice());
            salePrice = null != salePrice && minLadderPrice.compareTo(salePrice) < 0 ? minLadderPrice : minLadderPrice;
        }
        if (null != salePrice && salePrice.compareTo(reqBo.getSupplyPrice()) < 0) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u5927\u4e8e\u9500\u552e\u4ef7");
            return rspBo;
        }
        return this.uccUpdateSupplyPriceBusiService.updateSupplyPrice(reqBo);
    }
}

