/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.ability.CommodityPackBO;
import com.tydic.commodity.bo.busi.CommodityPackageInfo;
import com.tydic.commodity.bo.busi.CommodityPicBo;
import com.tydic.commodity.bo.busi.UccAddSupplierBusiReqBO;
import com.tydic.commodity.bo.busi.UccAddSupplierShopBusiReqBO;
import com.tydic.commodity.bo.busi.UccVendorBO;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPackageMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.dao.po.UccCommodityPackagePo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuPutCirPo;
import com.tydic.commodity.dao.po.UccSkuStockPo;
import com.tydic.commodity.dao.po.UccVendorPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.ListUtils;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.GoodsBatchUpdateAbilityReqBO;
import com.tydic.uccext.bo.GoodsBatchUpdateAbilityRspBO;
import com.tydic.uccext.bo.LadderPriceBO;
import com.tydic.uccext.bo.UccGengerateCommodityDataRspBO;
import com.tydic.uccext.bo.UccGoodsAgreementAndCommodityBO;
import com.tydic.uccext.dao.CnncUccEMdmCatalogMapper;
import com.tydic.uccext.dao.CnncUccEMdmMaterialMapper;
import com.tydic.uccext.dao.UccBrandExtMapper;
import com.tydic.uccext.dao.UccCommodityExtMapper;
import com.tydic.uccext.dao.UccExtCommodityTypeMapper;
import com.tydic.uccext.dao.po.CnncUccEMdmCatalogPo;
import com.tydic.uccext.dao.po.CnncUccEMdmMaterialPo;
import com.tydic.uccext.dao.po.UccExtCommodityTypePo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BatchAbstractGenerateCommodity {
    private static final Logger log = LoggerFactory.getLogger(BatchAbstractGenerateCommodity.class);
    private Sequence uccBatchSequence = Sequence.getInstance();
    private Sequence uccCommdSequence = Sequence.getInstance();
    private Sequence uccSkuSequence = Sequence.getInstance();
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private CnncUccEMdmMaterialMapper cnncUccEMdmMaterialMapper;
    @Autowired
    private UccCommodityMapper commodityMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccCommodityTypeMapper commodityTypeMapper;
    @Autowired
    private UccSkuMapper skuMapper;
    @Autowired
    private UccSkuPutCirMapper putCirMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccCommodityPackageMapper commodityPackageMapper;
    @Autowired
    private UccCommodityPicMapper commodityPicMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccExtCommodityTypeMapper uccExtCommodityTypeMapper;
    @Autowired
    private CnncUccEMdmCatalogMapper cnncUccEMdmCatalogMapper;
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;

    public GoodsBatchUpdateAbilityRspBO dealBatchGenerateTemplateMethod(GoodsBatchUpdateAbilityReqBO reqBO) {
        GoodsBatchUpdateAbilityRspBO rspBO = new GoodsBatchUpdateAbilityRspBO();
        this.createSupplierData(reqBO);
        this.createShopData(reqBO);
        this.createCommodityType(reqBO);
        this.createVendorData(reqBO);
        this.createBrandData(reqBO);
        this.createMaterial(reqBO);
        this.createCommoData(reqBO);
        this.createSkuData(reqBO);
        this.createPutCirData(reqBO);
        this.createSkuPriceData(reqBO);
        this.createPackageData(reqBO);
        this.createCommodityPic(reqBO);
        this.createLadderPriceData(reqBO);
        this.createStock(reqBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void createVendorData(GoodsBatchUpdateAbilityReqBO reqBO) {
        if (reqBO != null && !CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            UccVendorBO uccVendorBO = reqBO.getVendorBO();
            if (uccVendorBO == null) {
                return;
            }
            UccVendorPo po = new UccVendorPo();
            po.setVendorId(uccVendorBO.getVendorId());
            List vendorPos = this.uccVendorMapper.queryVerdor(po);
            if (CollectionUtils.isEmpty((Collection)vendorPos)) {
                UccVendorPo uccVendorPo = new UccVendorPo();
                uccVendorPo.setId(Long.valueOf(this.uccBatchSequence.nextId()));
                uccVendorPo.setContacts(uccVendorBO.getContacts());
                uccVendorPo.setCreateTime(new Date());
                uccVendorPo.setRelaPhone1(uccVendorBO.getRelaPhone1());
                uccVendorPo.setRelaPhone2(uccVendorBO.getRelaPhone2());
                uccVendorPo.setShopName(uccVendorBO.getVendorName());
                if (StringUtils.isBlank((String)uccVendorBO.getVendorCode())) {
                    uccVendorPo.setVendorCode(String.valueOf(uccVendorBO.getVendorId()));
                } else {
                    uccVendorPo.setVendorCode(uccVendorBO.getVendorCode());
                }
                if (uccVendorBO.getVendorId() != null) {
                    uccVendorPo.setVendorId(uccVendorBO.getVendorId());
                } else {
                    uccVendorPo.setVendorId(uccVendorPo.getId());
                }
                uccVendorPo.setShopId(uccVendorPo.getId());
                uccVendorPo.setVendorName(uccVendorBO.getVendorName());
                try {
                    this.uccVendorMapper.insert(uccVendorPo);
                }
                catch (Exception e) {
                    throw new ZTBusinessException("\u521b\u5efa\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
    }

    private void createStock(GoodsBatchUpdateAbilityReqBO reqBO) {
        if (reqBO != null && !CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            ArrayList<UccSkuStockPo> uccSkuStockPos = new ArrayList<UccSkuStockPo>();
            for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                UccSkuStockPo skuStockPo = new UccSkuStockPo();
                skuStockPo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuId());
                skuStockPo.setStockId(Long.valueOf(this.uccBatchSequence.nextId()));
                if (((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getStockNum() == null) {
                    skuStockPo.setStockNum(BigDecimal.ZERO);
                } else {
                    skuStockPo.setStockNum(BigDecimal.valueOf(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getStockNum()));
                }
                skuStockPo.setStockStatus(Integer.valueOf(0));
                skuStockPo.setCreateTime(new Date());
                skuStockPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuStockPos.add(skuStockPo);
            }
            try {
                this.uccSkuStockMapper.batchInsert(uccSkuStockPos);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u521b\u5efa\u5546\u54c1\u5e93\u5b58\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void createSupplierData(GoodsBatchUpdateAbilityReqBO reqBO) {
        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(reqBO.getSupplierId());
        if (null == supplierBusiPo) {
            UccAddSupplierBusiReqBO uccAddSupplierBusiReqBO = new UccAddSupplierBusiReqBO();
            uccAddSupplierBusiReqBO.setSupplierId(reqBO.getSupplierId());
            uccAddSupplierBusiReqBO.setCreateTime(new Date());
            uccAddSupplierBusiReqBO.setSupplierCode(reqBO.getSupplierCode());
            uccAddSupplierBusiReqBO.setSupplierName(reqBO.getSupplierName());
            uccAddSupplierBusiReqBO.setSupplierSource(Integer.valueOf(3));
            this.supplierMapper.insertSelective(uccAddSupplierBusiReqBO);
        }
    }

    public UccGengerateCommodityDataRspBO dealUpdateFromalTemplateMethod(GoodsBatchUpdateAbilityReqBO reqBO) {
        UccGengerateCommodityDataRspBO rspBO = new UccGengerateCommodityDataRspBO();
        if (!reqBO.getIsBatchEdit().booleanValue()) {
            this.updateCommoData(reqBO);
            this.updateSkuData(reqBO);
            this.updateSkuPriceData(reqBO);
            this.updatePackageData(reqBO);
            this.updateLadderPriceData(reqBO);
        }
        this.updatePutCirData(reqBO);
        this.updateCommodityPic(reqBO);
        rspBO.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void updateLadderPriceData(GoodsBatchUpdateAbilityReqBO reqBO) {
        UccLadderPricePO ladderPricePO = new UccLadderPricePO();
        ladderPricePO.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
        ladderPricePO.setSupplierShopId(reqBO.getSupplierShopId());
        List uccLadderPricePOS = this.uccLadderPriceMapper.selectByExample(ladderPricePO);
        if (CollectionUtils.isNotEmpty((Collection)uccLadderPricePOS)) {
            try {
                this.uccLadderPriceMapper.deleteByExample(ladderPricePO);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u9636\u68af\u4ef7\u683c\u5931\u8d25:skuId:" + ladderPricePO.getSkuId());
                throw new BusinessException("8888", "\u5220\u9664\u9636\u68af\u4ef7\u683c\u5931\u8d25");
            }
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getLadderPrice())) {
            return;
        }
        for (LadderPriceBO ladderPriceBO : reqBO.getLadderPrice()) {
            UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
            if (ladderPriceBO.getPrice() != null) {
                uccLadderPricePO.setPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getPrice()).longValue()));
            }
            if (ladderPriceBO.getStartPrice() != null) {
                uccLadderPricePO.setStart(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getStartPrice()).longValue()));
            }
            if (ladderPriceBO.getStopPrice() != null) {
                uccLadderPricePO.setStop(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getStopPrice()).longValue()));
            }
            uccLadderPricePO.setDiscount(ladderPriceBO.getDiscount());
            uccLadderPricePO.setId(Long.valueOf(this.uccBatchSequence.nextId()));
            uccLadderPricePO.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
            uccLadderPricePO.setSupplierShopId(reqBO.getSupplierShopId());
            uccLadderPricePO.setSkuPriceId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuPriceId());
            try {
                this.uccLadderPriceMapper.insertSelective(uccLadderPricePO);
            }
            catch (Exception e) {
                log.error("\u53d1\u5e03\u5ba1\u6279\u9636\u68af\u4ef7\u683c\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
                throw new BusinessException("8888", "\u4fdd\u5b58\u9636\u68af\u4ef7\u683c\u5931\u8d25");
            }
        }
    }

    protected void updateCommodityPic(GoodsBatchUpdateAbilityReqBO reqBO) {
        try {
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getCommodityPicInfo())) {
                this.commodityPicMapper.deleteByCommodityId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getCommodityId(), reqBO.getSupplierShopId());
                for (CommodityPicBo commodityPicBo : reqBO.getCommodityPicInfo()) {
                    UccCommodityPicPo commodityPicPo = new UccCommodityPicPo();
                    commodityPicPo.setCommodityPicId(Long.valueOf(this.uccBatchSequence.nextId()));
                    commodityPicPo.setCommodityId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getCommodityId());
                    commodityPicPo.setCreateTime(new Date());
                    commodityPicPo.setCommodityPicUrl(commodityPicBo.getCommodityPicUrl());
                    commodityPicPo.setCommodityPicType(commodityPicBo.getCommodityPicType());
                    commodityPicPo.setSupplierShopId(reqBO.getSupplierShopId());
                    commodityPicPo.setUpdateTime(new Date());
                    this.commodityPicMapper.addcommodityPic(commodityPicPo);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4e13\u533a\u7f16\u8f91\uff0c\u521b\u5efa\u5546\u54c1\u56fe\u7247\u5931\u8d25,\u539f\u56e0" + e);
            throw new BusinessException("8888", "\u521b\u5efa\u5546\u54c1\u56fe\u7247\u5931\u8d25");
        }
    }

    private void updatePackageData(GoodsBatchUpdateAbilityReqBO reqBO) {
        UccCommodityPackagePo commodityPackagePo = new UccCommodityPackagePo();
        commodityPackagePo.setCommodityId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getCommodityId());
        commodityPackagePo.setSupplierShopId(reqBO.getSupplierShopId());
        List commodityPackagePos = this.commodityPackageMapper.queryCommdPackage(commodityPackagePo);
        if (CollectionUtils.isEmpty((Collection)commodityPackagePos) || commodityPackagePos.size() != 1) {
            log.error("\u53d1\u5e03\u5ba1\u6279\u5546\u54c1\u5305\u88c5\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5546\u54c1\u5305\u88c5\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5b58\u5728\u591a\u6761.commodityId:" + ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getCommodityId());
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)commodityPackagePos)) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityPackInfo())) {
                return;
            }
            UccCommodityPackagePo uccCommodityPackagePo = (UccCommodityPackagePo)commodityPackagePos.get(0);
            CommodityPackageInfo commodityPackageInfo = new CommodityPackageInfo();
            commodityPackageInfo.setPackParam(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getList());
            commodityPackageInfo.setUpdateTime(new Date());
            commodityPackageInfo.setWeight(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getWeight());
            commodityPackageInfo.setLength(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getLength());
            commodityPackageInfo.setHeight(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getHeight());
            commodityPackageInfo.setWidth(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getWidth());
            commodityPackageInfo.setPackageId(uccCommodityPackagePo.getPackageId());
            commodityPackageInfo.setSupplierShopId(uccCommodityPackagePo.getSupplierShopId());
            try {
                commodityPackageInfo.setUpdateTime(new Date());
                this.commodityPackageMapper.updateCommodityPackage(commodityPackageInfo);
            }
            catch (Exception e) {
                log.error("\u53d1\u5e03\u5ba1\u6279\u5546\u54c1\u5305\u88c5\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
                throw new BusinessException("8888", "\u4fdd\u5b58\u5546\u54c1\u5305\u88c5\u6570\u636e\u5931\u8d25");
            }
        }
    }

    private void updateSkuPriceData(GoodsBatchUpdateAbilityReqBO reqBO) {
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        uccSkuPricePo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
        uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
        UccSkuPricePo skuPricePo = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
        if (skuPricePo == null) {
            log.error("\u5546\u54c1\u4e34\u65f6\u6570\u636e\u56de\u5199\u6b63\u5f0f\u6570\u636e\u5931\u8d25\uff1a\u4ef7\u683c\u4e0d\u5b58\u5728:skuId:" + ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
            throw new BusinessException("8888", "\u4ef7\u683c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        skuPricePo.setMarketPrice(Long.valueOf(reqBO.getMarketPrice().longValue()));
        skuPricePo.setSingleAgreementPrice(reqBO.getCommodityPackSpecBO().getSaleUnitPrice());
        skuPricePo.setSingleSalePrice(reqBO.getCommodityPackSpecBO().getPurchaseUnitPrice());
        if (null != reqBO.getCommodityPackSpecBO().getPackagePurchaseUitPrice()) {
            skuPricePo.setAgreementPrice(Long.valueOf(reqBO.getCommodityPackSpecBO().getPackagePurchaseUitPrice().longValue()));
        }
        if (null != reqBO.getCommodityPackSpecBO().getPackageSaleUnitPrice()) {
            skuPricePo.setSalePrice(Long.valueOf(reqBO.getCommodityPackSpecBO().getPackageSaleUnitPrice().longValue()));
        }
        try {
            ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).setSkuPriceId(skuPricePo.getSkuPriceId());
            skuPricePo.setUpdateTime(new Date());
            this.uccSkuPriceMapper.updateSkuPrice(skuPricePo);
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03\u5ba1\u6279\u4ef7\u683c\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("8888", "\u4fdd\u5b58\u4ef7\u683c\u6570\u636e\u5931\u8d25");
        }
    }

    private void updatePutCirData(GoodsBatchUpdateAbilityReqBO reqBO) {
        UccSkuPutCirPo skuPutCirPo = new UccSkuPutCirPo();
        skuPutCirPo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
        skuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
        try {
            this.putCirMapper.deleteSkuPutCirInfoBySkuId(skuPutCirPo);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u5220\u9664\u4e0a\u4e0b\u67b6\u6570\u636e\u5931\u8d25");
        }
        if (reqBO.getOnShelveWay() != null && 2 == reqBO.getOnShelveWay()) {
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setId(Long.valueOf(this.uccBatchSequence.nextId()));
            uccSkuPutCirPo.setState(Integer.valueOf(1));
            uccSkuPutCirPo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
            uccSkuPutCirPo.setUpType(reqBO.getOnShelveWay());
            uccSkuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPutCirPo.setCreateTime(new Date());
            uccSkuPutCirPo.setPreUpTime(reqBO.getShelveTime());
            try {
                this.putCirMapper.addSkuPutCir(uccSkuPutCirPo);
            }
            catch (Exception e) {
                log.error("\u53d1\u5e03\u5ba1\u6279\u4e0a\u4e0b\u67b6\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
                throw new BusinessException("8888", "\u4fdd\u5b58\u4e0a\u4e0b\u67b6\u6570\u636e\u5931\u8d25");
            }
        }
    }

    private void updateSkuData(GoodsBatchUpdateAbilityReqBO reqBO) {
        UccSkuPo skuPo = new UccSkuPo();
        skuPo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
        List skuPos = this.skuMapper.qerySku(skuPo);
        if (CollectionUtils.isEmpty((Collection)skuPos)) {
            throw new BusinessException("8888", "\u5355\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
        }
        skuPo.setMoq(reqBO.getMiniOrderNum() == null ? null : reqBO.getMiniOrderNum());
        skuPo.setOnShelveWay(reqBO.getOnShelveWay());
        skuPo.setSkuLongName(reqBO.getSkuName());
        skuPo.setSkuName(reqBO.getSkuName());
        skuPo.setSkuPcDetailChar(reqBO.getSkuDesc());
        skuPo.setSkuPcDetailUrl(reqBO.getSkuDesc());
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCommodityPackInfo())) {
            skuPo.setWeight(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getWeight());
        }
        skuPo.setIsShopSalesUnit(reqBO.getShowPackUnit());
        skuPo.setSalesUnitName(reqBO.getCommodityPackSpecBO().getSaleUnit());
        skuPo.setSalesUnitRate(reqBO.getCommodityPackSpecBO().getUnitConversionValue());
        skuPo.setPackageSpec(reqBO.getCommodityPackSpecBO().getPackageSpec());
        skuPo.setSettlementUnit(reqBO.getCommodityPackSpecBO().getSettlementUnit());
        skuPo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
        skuPo.setSupplierShopId(reqBO.getSupplierShopId());
        skuPo.setRemark(reqBO.getApprovalRemark());
        skuPo.setUpdateTime(new Date());
        try {
            this.skuMapper.updateSku(skuPo);
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03\u5ba1\u6279\u5355\u54c1\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("8888", "\u4fdd\u5b58\u5355\u54c1\u6570\u636e\u5931\u8d25");
        }
    }

    protected void updateCommoData(GoodsBatchUpdateAbilityReqBO reqBO) {
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        uccCommodityPo.setCommodityId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getCommodityId());
        UccCommodityPo po = this.commodityMapper.qryCommdByCommdId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getCommodityId(), reqBO.getSupplierShopId());
        if (po == null) {
            log.error("\u53d1\u5e03\u5ba1\u6279\u5546\u54c1\u6570\u636e\u4fdd\u5b58\u5931\u8d25,\u539f\u56e0\uff1a\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728\u3002commodityId" + ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getCommodityId());
            throw new BusinessException("8888", "\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
        }
        uccCommodityPo.setCommodityName(reqBO.getSkuName());
        uccCommodityPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccCommodityPo.setCommodityPcDetailUrl(reqBO.getSkuDesc());
        uccCommodityPo.setCommodityPcDetailChar(reqBO.getSkuDesc());
        uccCommodityPo.setUpdateTime(new Date());
        try {
            this.commodityMapper.updateCommodity(uccCommodityPo);
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03\u5ba1\u6279\u5546\u54c1\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("8888", "\u4fdd\u5b58\u5546\u54c1\u6570\u636e\u5931\u8d25");
        }
    }

    private void createLadderPriceData(GoodsBatchUpdateAbilityReqBO reqBO) {
        if (reqBO != null && !CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            ArrayList<UccLadderPricePO> uccLadderPricePOS = new ArrayList<UccLadderPricePO>();
            for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                if (CollectionUtils.isEmpty((Collection)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getLadderPrice())) continue;
                for (LadderPriceBO ladderPriceBO : ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getLadderPrice()) {
                    UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
                    if (ladderPriceBO.getPrice() == null || new BigDecimal("0").compareTo(ladderPriceBO.getPrice()) >= 0) continue;
                    uccLadderPricePO.setPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getPrice()).longValue()));
                    if (ladderPriceBO.getStartPrice() != null) {
                        uccLadderPricePO.setStart(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getStartPrice()).longValue()));
                    }
                    if (ladderPriceBO.getStopPrice() != null) {
                        uccLadderPricePO.setStop(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getStopPrice()).longValue()));
                    }
                    uccLadderPricePO.setDiscount(ladderPriceBO.getDiscount());
                    uccLadderPricePO.setId(Long.valueOf(this.uccBatchSequence.nextId()));
                    uccLadderPricePO.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuId());
                    uccLadderPricePO.setSupplierShopId(reqBO.getSupplierShopId());
                    uccLadderPricePO.setSkuPriceId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuPriceId());
                    uccLadderPricePOS.add(uccLadderPricePO);
                }
            }
            try {
                this.uccLadderPriceMapper.batchInsert(uccLadderPricePOS);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u521b\u5efa\u5546\u54c1\u9636\u68af\u4ef7\u683c\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    protected void createCommodityPic(GoodsBatchUpdateAbilityReqBO reqBO) {
        if (reqBO != null && !CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            ArrayList<UccCommodityPicPo> uccCommodityPicPos = new ArrayList<UccCommodityPicPo>();
            for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                if (CollectionUtils.isEmpty((Collection)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPicInfo())) continue;
                for (CommodityPicBo commodityPicBo : ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPicInfo()) {
                    UccCommodityPicPo commodityPicPo = new UccCommodityPicPo();
                    commodityPicPo.setCommodityPicId(Long.valueOf(this.uccBatchSequence.nextId()));
                    commodityPicPo.setCommodityId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityId());
                    commodityPicPo.setCreateTime(new Date());
                    commodityPicPo.setCommodityPicUrl(commodityPicBo.getCommodityPicUrl());
                    commodityPicPo.setCommodityPicType(commodityPicBo.getCommodityPicType());
                    commodityPicPo.setSupplierShopId(reqBO.getSupplierShopId());
                    uccCommodityPicPos.add(commodityPicPo);
                }
            }
            try {
                this.commodityPicMapper.batchInsert(uccCommodityPicPos);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u521b\u5efa\u5546\u54c1\u56fe\u7247\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void createCommoData(GoodsBatchUpdateAbilityReqBO reqBO) {
        if (reqBO != null && !CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            ArrayList<UccCommodityPo> uccCommodityPoList = new ArrayList<UccCommodityPo>();
            for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                UccCommodityPo commodityPo = new UccCommodityPo();
                commodityPo.setSupplierShopId(reqBO.getSupplierShopId());
                commodityPo.setCommodityStatus(Integer.valueOf(0));
                commodityPo.setCommodityPcDetailUrl(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuDesc());
                commodityPo.setCommodityPcDetailChar(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuDesc());
                Long commdityId = this.uccCommdSequence.nextId();
                commodityPo.setCommodityId(commdityId);
                commodityPo.setFreeFhipping(Integer.valueOf(0));
                commodityPo.setViewOrder(Integer.valueOf(0));
                commodityPo.setAgreementId(reqBO.getAgreementId());
                commodityPo.setAgreementDetailsId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getAgreementDetailsId());
                commodityPo.setBrandId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandId());
                commodityPo.setBrandName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandName());
                commodityPo.setCommodityCode("COMMODITY_CODE");
                commodityPo.setServenRejectAllow(Integer.valueOf(0));
                commodityPo.setCommoditySource(Integer.valueOf(3));
                commodityPo.setCommodityName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuName());
                commodityPo.setArrivalTime(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getArrivalTime());
                commodityPo.setCommodityTypeId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityTypeId());
                commodityPo.setMaterialId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMaterialId());
                commodityPo.setVendorShopId(reqBO.getVendorBO().getVendorId());
                commodityPo.setVendorId(reqBO.getVendorBO().getVendorId());
                ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setCommodityId(commdityId);
                uccCommodityPoList.add(commodityPo);
            }
            try {
                this.uccCommodityExtMapper.batchInsert(uccCommodityPoList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u521b\u5efa\u5546\u54c1\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void createSkuData(GoodsBatchUpdateAbilityReqBO reqBO) {
        if (reqBO != null && !CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            ArrayList<UccSkuPo> uccSkuPos = new ArrayList<UccSkuPo>();
            for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                UccSkuPo po = new UccSkuPo();
                Long skuId = this.uccSkuSequence.nextId();
                po.setModel(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getModel());
                po.setSpec(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSpec());
                po.setTexture(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getTexture());
                po.setFigure(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getFigure());
                po.setMaterialName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMaterialName());
                if (((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMaterialId() != null) {
                    po.setMaterialId(String.valueOf(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMaterialId()));
                }
                po.setSkuId(skuId);
                po.setSupplierShopId(reqBO.getSupplierShopId());
                po.setCommodityId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityId());
                po.setSkuStatus(Integer.valueOf(0));
                po.setOnShelveWay(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getOnShelveWay());
                po.setAgreementId(Long.valueOf(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getAgreementId()));
                po.setAgreementDetailsId(Long.valueOf(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getAgreementDetailsId()));
                po.setBrandId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandId());
                po.setBrandName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandName());
                po.setCommodityTypeId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityTypeId());
                if (null != ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMiniOrderNum()) {
                    po.setMoq(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMiniOrderNum());
                }
                po.setShopName(reqBO.getShopName());
                po.setSkuCode("sku_code");
                po.setSkuLongName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuName());
                po.setSkuName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuName());
                po.setSkuPcDetailChar(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuDesc());
                po.setSkuPcDetailUrl(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuDesc());
                po.setSkuSource(Integer.valueOf(3));
                if (((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackInfo() != null) {
                    po.setWeight(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackInfo().getWeight());
                }
                po.setIsShopSalesUnit(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getShowPackUnit());
                if (((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackSpecBO() != null) {
                    if (1 == ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getShowPackUnit()) {
                        po.setSalesUnitName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackSpecBO().getSaleUnit());
                        po.setSalesUnitRate(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackSpecBO().getUnitConversionValue());
                        po.setPackageSpec(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackSpecBO().getPackageSpec());
                    }
                    po.setSettlementUnit(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackSpecBO().getSettlementUnit());
                }
                po.setManufacturer(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getManufacturer());
                po.setAgreementType(reqBO.getAgreementType());
                if (!StringUtils.isEmpty((String)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getPreDeliverDay())) {
                    po.setPreDeliverDay(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getPreDeliverDay());
                }
                po.setMeasureName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMeasureName());
                po.setRate(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getTaxRate());
                uccSkuPos.add(po);
                ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setSkuId(skuId);
            }
            try {
                this.uccCommodityExtMapper.batchInsertSku(uccSkuPos);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u521b\u5efa\u5355\u54c1\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void createShopData(GoodsBatchUpdateAbilityReqBO reqBO) {
        List supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isEmpty((Collection)supplierShopPos)) {
            UccAddSupplierShopBusiReqBO supplierShopBusiReqBO = new UccAddSupplierShopBusiReqBO();
            supplierShopBusiReqBO.setSupplierShopId(Long.valueOf(this.uccBatchSequence.nextId()));
            supplierShopBusiReqBO.setSupplierId(reqBO.getSupplierId());
            supplierShopBusiReqBO.setSupplierName(reqBO.getSupplierName());
            supplierShopBusiReqBO.setShopName(reqBO.getSupplierName());
            supplierShopBusiReqBO.setRelaPhone1("11111111");
            supplierShopBusiReqBO.setContacts("111223");
            supplierShopBusiReqBO.setShopStatus(Integer.valueOf(1));
            supplierShopBusiReqBO.setAddress(reqBO.getAddress());
            reqBO.setSupplierShopId(supplierShopBusiReqBO.getSupplierShopId());
            reqBO.setShopName(reqBO.getSupplierName());
            this.supplierShopMapper.insertSelective(supplierShopBusiReqBO);
        } else {
            reqBO.setSupplierShopId(((SupplierShopPo)supplierShopPos.get(0)).getSupplierShopId());
            reqBO.setShopName(((SupplierShopPo)supplierShopPos.get(0)).getShopName());
        }
    }

    private void createBrandData(GoodsBatchUpdateAbilityReqBO reqBO) {
        if (reqBO != null && !CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            List brandNames = reqBO.getGoodsAgreementAndCommodityBOS().stream().filter(a -> !StringUtils.isEmpty((String)a.getBrandName())).map(UccGoodsAgreementAndCommodityBO::getBrandName).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(brandNames)) {
                throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u54c1\u724c\u4fe1\u606f");
            }
            for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                if (!StringUtils.isEmpty((String)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandName())) continue;
                throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u7f16\u53f7" + ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getAgreementDetailsId() + "\u7684\u54c1\u724c\u4fe1\u606f");
            }
            brandNames = ListUtils.removeReapet(brandNames);
            List<UccBrandDealPO> uccBrandDealPOS = this.uccBrandExtMapper.getListByNames(brandNames);
            ArrayList<UccBrandDealPO> uccBrandDealPOList = new ArrayList<UccBrandDealPO>();
            if (CollectionUtils.isEmpty(uccBrandDealPOS)) {
                for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                    UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
                    Long brandId = this.uccBatchSequence.nextId();
                    uccBrandDealPO.setBrandCode(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandName());
                    uccBrandDealPO.setBrandName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandName());
                    uccBrandDealPO.setBrandEnName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandName());
                    uccBrandDealPO.setEffTime(new Date());
                    uccBrandDealPO.setExpTime(DateUtils.strToDateyyyyMMddHHmmss((String)"2099-12-31 00:00:00"));
                    uccBrandDealPO.setBrandStatus(Integer.valueOf(1));
                    uccBrandDealPO.setCreateTime(DateUtils.dateToStrLong((Date)new Date()));
                    uccBrandDealPO.setBrandId(brandId);
                    ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setBrandId(brandId);
                    uccBrandDealPOList.add(uccBrandDealPO);
                }
            } else {
                Map<String, Long> map = uccBrandDealPOS.stream().collect(Collectors.toMap(UccBrandDealPO::getBrandName, UccBrandDealPO::getBrandId));
                for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                    if (!map.containsKey(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandName())) {
                        UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
                        Long brandId = this.uccBatchSequence.nextId();
                        uccBrandDealPO.setBrandCode(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandName());
                        uccBrandDealPO.setBrandName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandName());
                        uccBrandDealPO.setBrandEnName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandName());
                        uccBrandDealPO.setEffTime(new Date());
                        uccBrandDealPO.setExpTime(DateUtils.strToDateyyyyMMddHHmmss((String)"2099-12-31 00:00:00"));
                        uccBrandDealPO.setBrandStatus(Integer.valueOf(1));
                        uccBrandDealPO.setCreateTime(DateUtils.dateToStrLong((Date)new Date()));
                        uccBrandDealPO.setBrandId(brandId);
                        ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setBrandId(brandId);
                        uccBrandDealPOList.add(uccBrandDealPO);
                        continue;
                    }
                    ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setBrandId(map.get(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getBrandName()));
                }
            }
            try {
                this.uccBrandExtMapper.batchInsert(uccBrandDealPOList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u521b\u5efa\u54c1\u724c\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void createPutCirData(GoodsBatchUpdateAbilityReqBO reqBO) {
        if (reqBO != null && !CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            ArrayList uccSkuPutCirPos = new ArrayList();
            for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                if (((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getOnShelveWay() == null || 2 != ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getOnShelveWay() || ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getAutomaticShelveType() == null || ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getAutomaticShelveType() != 1) continue;
                UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
                uccSkuPutCirPo.setId(Long.valueOf(this.uccBatchSequence.nextId()));
                uccSkuPutCirPo.setState(Integer.valueOf(1));
                uccSkuPutCirPo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuId());
                uccSkuPutCirPo.setUpType(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getOnShelveWay());
                uccSkuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPutCirPo.setCreateTime(new Date());
                uccSkuPutCirPo.setPreUpTime(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getShelveTime());
            }
            try {
                this.putCirMapper.batchInsert(uccSkuPutCirPos);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u521b\u5efa\u4e0a\u4e0b\u67b6\u5468\u671f\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    protected void createSkuPriceData(GoodsBatchUpdateAbilityReqBO reqBO) {
        if (reqBO != null && !CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            ArrayList<UccSkuPricePo> uccSkuPricePos = new ArrayList<UccSkuPricePo>();
            for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                Long priceId;
                UccSkuPricePo uccSkuPricePo;
                if (((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackSpecBO() != null) {
                    uccSkuPricePo = new UccSkuPricePo();
                    priceId = this.uccBatchSequence.nextId();
                    uccSkuPricePo.setSkuPriceId(priceId);
                    uccSkuPricePo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuId());
                    uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
                    uccSkuPricePo.setSingleAgreementPrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getCommodityPackSpecBO().getSaleUnitPrice()));
                    uccSkuPricePo.setSingleSalePrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getCommodityPackSpecBO().getPurchaseUnitPrice()));
                    uccSkuPricePo.setCreateTime(new Date());
                    uccSkuPricePo.setMarketPrice(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMarketPrice() != null ? Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMarketPrice()).longValue()) : null);
                    if (0 == ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getShowPackUnit()) {
                        uccSkuPricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackSpecBO().getSaleUnitPrice()).longValue()));
                        uccSkuPricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackSpecBO().getPurchaseUnitPrice()).longValue()));
                    } else {
                        uccSkuPricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackSpecBO().getPackagePurchaseUitPrice()).longValue()));
                        uccSkuPricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackSpecBO().getPackageSaleUnitPrice()).longValue()));
                    }
                    uccSkuPricePos.add(uccSkuPricePo);
                    ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setSkuPriceId(priceId);
                    continue;
                }
                uccSkuPricePo = new UccSkuPricePo();
                priceId = this.uccBatchSequence.nextId();
                uccSkuPricePo.setSkuPriceId(priceId);
                uccSkuPricePo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getSkuId());
                uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPricePo.setSingleAgreementPrice(new BigDecimal(0));
                uccSkuPricePo.setSingleSalePrice(new BigDecimal(0));
                uccSkuPricePo.setCreateTime(new Date());
                uccSkuPricePo.setMarketPrice(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMarketPrice() != null ? Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMarketPrice()).longValue()) : null);
                uccSkuPricePo.setSalePrice(Long.valueOf(0L));
                uccSkuPricePo.setAgreementPrice(Long.valueOf(0L));
                uccSkuPricePos.add(uccSkuPricePo);
                ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setSkuPriceId(priceId);
            }
            try {
                this.uccSkuPriceMapper.batchInsert(uccSkuPricePos);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u521b\u5efa\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void createPackageData(GoodsBatchUpdateAbilityReqBO reqBO) {
        if (reqBO != null && !CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            ArrayList<UccCommodityPackagePo> uccCommodityPackagePos = new ArrayList<UccCommodityPackagePo>();
            for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                UccCommodityPackagePo commodityPackagePo = new UccCommodityPackagePo();
                commodityPackagePo.setPackageId(Long.valueOf(this.uccBatchSequence.nextId()));
                if (((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackInfo() != null) {
                    commodityPackagePo.setPackParam(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackInfo().getList());
                    commodityPackagePo.setWeight(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackInfo().getWeight());
                    commodityPackagePo.setLength(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackInfo().getLength());
                    commodityPackagePo.setHeight(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackInfo().getHeight());
                    commodityPackagePo.setWidth(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackInfo().getWidth());
                } else {
                    commodityPackagePo.setPackParam("");
                    commodityPackagePo.setWeight(new BigDecimal("0"));
                    commodityPackagePo.setLength(new BigDecimal("0"));
                    commodityPackagePo.setHeight(new BigDecimal("0"));
                    commodityPackagePo.setWidth(new BigDecimal("0"));
                }
                commodityPackagePo.setInvoiceType(Integer.valueOf(1));
                commodityPackagePo.setCreateTime(new Date());
                commodityPackagePo.setCommodityId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCommodityPackInfo().getCommodityId());
                commodityPackagePo.setSupplierShopId(reqBO.getSupplierShopId());
                uccCommodityPackagePos.add(commodityPackagePo);
            }
            try {
                this.commodityPackageMapper.batchInsert(uccCommodityPackagePos);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u521b\u5efa\u5546\u54c1\u5305\u88c5\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void createCommodityType(GoodsBatchUpdateAbilityReqBO reqBO) {
        List<Object> catalogIds = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            catalogIds = reqBO.getGoodsAgreementAndCommodityBOS().stream().filter(a -> a.getCatalogId() != null).map(UccGoodsAgreementAndCommodityBO::getCatalogId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(catalogIds)) {
                throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u7269\u6599\u5206\u7c7b\u4fe1\u606f");
            }
            List<CnncUccEMdmCatalogPo> cnncUccEMdmCatalogPos = this.cnncUccEMdmCatalogMapper.queryListBycatalogIds(catalogIds = ListUtils.removeReapet(catalogIds), 4);
            if (CollectionUtils.isEmpty(cnncUccEMdmCatalogPos)) {
                throw new ZTBusinessException("\u83b7\u53d6\u5230\u7684\u7269\u6599\u5206\u7c7b\u4fe1\u606f\u4e0d\u6b63\u786e,\u8bf7\u8f93\u5165\u6b63\u786e\u56db\u7ea7\u7269\u6599\u5206\u7c7b");
            }
            Map<Long, String> catalogMap = cnncUccEMdmCatalogPos.stream().collect(Collectors.toMap(CnncUccEMdmCatalogPo::getCatalogId, CnncUccEMdmCatalogPo::getCatalogName));
            for (UccGoodsAgreementAndCommodityBO uccGoodsAgreementAndCommodityBO : reqBO.getGoodsAgreementAndCommodityBOS()) {
                if (!catalogMap.containsKey(uccGoodsAgreementAndCommodityBO.getCatalogId())) {
                    throw new ZTBusinessException("\u7f16\u53f7\u4e3a" + uccGoodsAgreementAndCommodityBO.getAgreementDetailsId() + "\u7684\u7269\u6599\u5206\u7c7b\u4fe1\u606f\u9519\u8bef!");
                }
                uccGoodsAgreementAndCommodityBO.setCatalogName(catalogMap.get(uccGoodsAgreementAndCommodityBO.getCatalogId()));
            }
            ArrayList<UccExtCommodityTypePo> uccExtCommodityTypePoList = new ArrayList<UccExtCommodityTypePo>();
            List<UccExtCommodityTypePo> uccExtCommodityTypePos = this.uccExtCommodityTypeMapper.getListByCatalogIds(catalogIds);
            if (CollectionUtils.isEmpty(uccExtCommodityTypePos)) {
                for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                    UccExtCommodityTypePo uccExtCommodityTypePo = new UccExtCommodityTypePo();
                    Long commodityTypeId = this.uccBatchSequence.nextId();
                    uccExtCommodityTypePo.setCommodityTypeId(commodityTypeId);
                    uccExtCommodityTypePo.setCatalogId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCatalogId());
                    uccExtCommodityTypePo.setCommodityTypeName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCatalogName());
                    uccExtCommodityTypePo.setCommodityTypeStatus(1);
                    uccExtCommodityTypePo.setRemark("\u521b\u5efa\u534f\u8bae\u5546\u54c1\u540c\u6b65\u521b\u5efa\u5546\u54c1\u7c7b\u578b");
                    uccExtCommodityTypePoList.add(uccExtCommodityTypePo);
                    ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setCommodityTypeId(commodityTypeId);
                }
            } else {
                List catalogIdList = uccExtCommodityTypePos.stream().map(UccExtCommodityTypePo::getCatalogId).collect(Collectors.toList());
                for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                    if (catalogIdList.contains(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCatalogId())) continue;
                    UccExtCommodityTypePo uccExtCommodityTypePo = new UccExtCommodityTypePo();
                    Long commodityTypeId = this.uccBatchSequence.nextId();
                    uccExtCommodityTypePo.setCommodityTypeId(commodityTypeId);
                    uccExtCommodityTypePo.setCatalogId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCatalogId());
                    uccExtCommodityTypePo.setCommodityTypeName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCatalogName());
                    uccExtCommodityTypePo.setCommodityTypeStatus(1);
                    uccExtCommodityTypePo.setRemark("\u521b\u5efa\u534f\u8bae\u5546\u54c1\u540c\u6b65\u521b\u5efa\u5546\u54c1\u7c7b\u578b");
                    uccExtCommodityTypePoList.add(uccExtCommodityTypePo);
                    ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setCommodityTypeId(commodityTypeId);
                }
            }
            try {
                this.uccExtCommodityTypeMapper.batchInsert(uccExtCommodityTypePoList);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u5546\u54c1\u7c7b\u578b\u5931\u8d25\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u65b0\u589e\u5546\u54c1\u7c7b\u578b\u5931\u8d25");
            }
        }
    }

    private void createMaterial(GoodsBatchUpdateAbilityReqBO reqBO) {
        if (reqBO != null && CollectionUtils.isNotEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            List materialNames = reqBO.getGoodsAgreementAndCommodityBOS().stream().filter(a -> !StringUtils.isEmpty((String)a.getMaterialName())).map(UccGoodsAgreementAndCommodityBO::getMaterialName).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)(materialNames = ListUtils.removeReapet(materialNames)))) {
                ArrayList<CnncUccEMdmMaterialPo> uccEMdmMaterialPOList = new ArrayList<CnncUccEMdmMaterialPo>();
                List<CnncUccEMdmMaterialPo> cnncUccEMdmMaterialPos = this.cnncUccEMdmMaterialMapper.queryListByNames(materialNames);
                if (CollectionUtils.isEmpty(cnncUccEMdmMaterialPos)) {
                    for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                        CnncUccEMdmMaterialPo uccEMdmMaterialPO = new CnncUccEMdmMaterialPo();
                        Long materialId = this.uccBatchSequence.nextId();
                        uccEMdmMaterialPO.setMaterialId(materialId);
                        uccEMdmMaterialPO.setMaterialCode(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMaterialCode());
                        uccEMdmMaterialPO.setMaterialName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMaterialName());
                        uccEMdmMaterialPO.setCatalogId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCatalogId());
                        uccEMdmMaterialPO.setCatalogName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCatalogName());
                        uccEMdmMaterialPO.setSysId(0L);
                        uccEMdmMaterialPOList.add(uccEMdmMaterialPO);
                        ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setMaterialId(materialId);
                    }
                } else {
                    Map<String, Long> map = cnncUccEMdmMaterialPos.stream().collect(Collectors.toMap(CnncUccEMdmMaterialPo::getMaterialName, CnncUccEMdmMaterialPo::getMaterialId));
                    for (int i = 0; i < reqBO.getGoodsAgreementAndCommodityBOS().size(); ++i) {
                        if (!map.containsKey(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMaterialName())) {
                            CnncUccEMdmMaterialPo uccEMdmMaterialPO = new CnncUccEMdmMaterialPo();
                            Long materialId = this.uccBatchSequence.nextId();
                            uccEMdmMaterialPO.setMaterialId(materialId);
                            uccEMdmMaterialPO.setMaterialCode(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMaterialCode());
                            uccEMdmMaterialPO.setMaterialName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMaterialName());
                            uccEMdmMaterialPO.setCatalogId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCatalogId());
                            uccEMdmMaterialPO.setCatalogName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getCatalogName());
                            uccEMdmMaterialPO.setSysId(0L);
                            uccEMdmMaterialPOList.add(uccEMdmMaterialPO);
                            ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setMaterialId(materialId);
                            continue;
                        }
                        ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).setMaterialId(map.get(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(i)).getMaterialName()));
                    }
                }
                try {
                    this.cnncUccEMdmMaterialMapper.batchInsert(uccEMdmMaterialPOList);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u521b\u5efa\u7269\u6599\u4fe1\u606f\u5931\u8d25!");
                }
            }
        }
    }
}

