/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.SyncSequenceUtil;
import com.tydic.uccext.bo.UccAddSceneAbilityReqBO;
import com.tydic.uccext.bo.UccAddSceneAbilityRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccSceneLogMapper;
import com.tydic.uccext.dao.UccSceneMapper;
import com.tydic.uccext.dao.po.UccSceneLogPO;
import com.tydic.uccext.dao.po.UccScenePO;
import com.tydic.uccext.service.UccAddSceneBusiService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAddSceneBusiServiceImpl
implements UccAddSceneBusiService {
    @Autowired
    private UccSceneMapper uccSceneMapper;
    @Autowired
    private UccSceneLogMapper uccSceneLogMapper;
    @Autowired
    private OrderSequence uccSceneCodeSequence;
    private Sequence sequence = Sequence.getInstance();

    public UccAddSceneAbilityRspBO addScene(UccAddSceneAbilityReqBO reqBo) {
        UccAddSceneAbilityRspBO rspBo = new UccAddSceneAbilityRspBO();
        List ids = SyncSequenceUtil.getIds((OrderSequence)this.uccSceneCodeSequence, (int)1);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            throw new BusinessException("8888", "\u83b7\u53d6\u9152\u5e97\u54c1\u724c\u7f16\u7801\u5931\u8d25");
        }
        int maxSceneCode = 999;
        if ((Long)ids.get(0) > (long)maxSceneCode) {
            throw new BusinessException("8888", "\u9152\u5e97\u54c1\u724c\u7f16\u7801\u5df2\u7528\u5c3d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        }
        String code = "JDPP" + String.format("%03d", ids.get(0));
        UccScenePO po = new UccScenePO();
        long sceneId = this.sequence.nextId();
        po.setSceneId(sceneId);
        po.setSceneCode(code);
        po.setCreateOperId(reqBo.getUsername());
        po.setCreateTime(new Date());
        po.setSceneName(reqBo.getSceneName());
        po.setSceneStatus(1L);
        po.setRemark(UccConstants.YesOrNo.YES.toString());
        this.uccSceneMapper.insert(po);
        UccSceneLogPO uccSceneLogPo = new UccSceneLogPO();
        uccSceneLogPo.setLogId(this.sequence.nextId());
        uccSceneLogPo.setSceneId(sceneId);
        uccSceneLogPo.setOldSceneCode(po.getSceneCode());
        uccSceneLogPo.setOldSceneName(po.getSceneName());
        uccSceneLogPo.setNewSceneCode(po.getSceneCode());
        uccSceneLogPo.setNewSceneName(po.getSceneName());
        uccSceneLogPo.setOperId(reqBo.getUsername());
        uccSceneLogPo.setOperTime(new Date());
        uccSceneLogPo.setOperRemark("\u9875\u9762\u65b0\u589e\u573a\u666f");
        this.uccSceneLogMapper.insert(uccSceneLogPo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

