/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccBannerAddBReqBo;
import com.tydic.uccext.bo.UccBannerAddBRspBo;
import com.tydic.uccext.dao.UccBannerConfigMapper;
import com.tydic.uccext.dao.UccPortalCmsSkuListMapper;
import com.tydic.uccext.dao.po.UccBannerConfigPO;
import com.tydic.uccext.dao.po.UccPortalCmsSkuListPO;
import com.tydic.uccext.service.UccBannerAddBusiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccBannerAddBusiService"})
public class UccBannerAddBusiServiceImpl
implements UccBannerAddBusiService {
    private Sequence uccBannerSequence = Sequence.getInstance();
    @Autowired
    private UccBannerConfigMapper uccBannerConfigMapper;
    @Autowired
    private UccPortalCmsSkuListMapper uccPortalCmsSkuListMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccBannerAddBusiServiceImpl.class);

    @PostMapping(value={"addBanner"})
    public UccBannerAddBRspBo addBanner(@RequestBody UccBannerAddBReqBo reqBo) {
        UccBannerAddBRspBo rspBO = new UccBannerAddBRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBo.getOrgIdIn() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u673a\u6784ID");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBo.getBannerPicUrl())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u8f6e\u64ad\u56fe\u5730\u5740");
            return rspBO;
        }
        if (reqBo.getPicOrder() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6392\u5e8f\u53f7");
            return rspBO;
        }
        try {
            UccBannerConfigPO uccBannerConfigPO = new UccBannerConfigPO();
            BeanUtils.copyProperties((Object)reqBo, (Object)uccBannerConfigPO);
            uccBannerConfigPO.setSupplierId(reqBo.getOrgIdIn());
            Long bannerId = this.uccBannerSequence.nextId();
            uccBannerConfigPO.setBannerId(bannerId);
            this.uccBannerConfigMapper.addBranner(uccBannerConfigPO);
            rspBO.setBannerId(bannerId);
            if (StringUtils.isEmpty((Object)reqBo.getForwardUrl())) {
                UccPortalCmsSkuListPO uccPortalCmsSkuListPO = new UccPortalCmsSkuListPO();
                uccPortalCmsSkuListPO.setSupplierId(reqBo.getOrgIdIn());
                uccPortalCmsSkuListPO.setColumnCode(bannerId.toString());
                uccPortalCmsSkuListPO.setSkuLocation("banner");
                uccPortalCmsSkuListPO.setSkuId(reqBo.getCommodityId());
                this.uccPortalCmsSkuListMapper.insertCms(uccPortalCmsSkuListPO);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            throw new BusinessException("8888", "\u6dfb\u52a0\u5931\u8d25");
        }
        return rspBO;
    }
}

