/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.uccext.bo.UccBatchImportSceneBusiReqBO;
import com.tydic.uccext.bo.UccBatchImportSceneBusiRspBO;
import com.tydic.uccext.bo.UccSceneBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccExtSkuMapper;
import com.tydic.uccext.dao.UccSceneLogMapper;
import com.tydic.uccext.dao.UccSceneMapper;
import com.tydic.uccext.dao.UccSceneSkuSubscribeMapper;
import com.tydic.uccext.dao.po.SceneRelUpdatePO;
import com.tydic.uccext.dao.po.UccSceneLogPO;
import com.tydic.uccext.dao.po.UccScenePO;
import com.tydic.uccext.dao.po.UccSceneSkuRelPO;
import com.tydic.uccext.service.UccBatchImportSceneBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccBatchImportSceneBusiServiceImpl
implements UccBatchImportSceneBusiService {
    @Autowired
    private UccSceneMapper uccSceneMapper;
    @Autowired
    private UccSceneLogMapper uccSceneLogMapper;
    @Autowired
    private UccSceneSkuSubscribeMapper uccSceneSkuSubscribeMapper;
    @Autowired
    private UccExtSkuMapper uccExtSkuMapper;
    private Sequence sequence = Sequence.getInstance();

    public UccBatchImportSceneBusiRspBO dealSceneImport(UccBatchImportSceneBusiReqBO reqBo) {
        UccBatchImportSceneBusiRspBO rspBo = new UccBatchImportSceneBusiRspBO();
        this.dealInsert(reqBo.getInsertList(), reqBo.getUsername());
        List<Long> comIds = this.dealUpdate(reqBo.getUpdateList(), reqBo.getUsername());
        Map<Long, List<Long>> commodityList = this.getSyncEsCommodityIdList(reqBo.getUpdateList(), comIds);
        rspBo.setCommodityList(commodityList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealInsert(List<UccSceneBO> insertList, String username) {
        if (!CollectionUtils.isEmpty(insertList)) {
            ArrayList<UccScenePO> scenePoList = new ArrayList<UccScenePO>();
            ArrayList<UccSceneLogPO> sceneLogPoList = new ArrayList<UccSceneLogPO>();
            insertList.forEach(sceneBo -> {
                long sceneId = this.sequence.nextId();
                UccScenePO scenePo = new UccScenePO();
                scenePo.setSceneId(sceneId);
                scenePo.setSceneCode(sceneBo.getSceneCode());
                scenePo.setCreateOperId(username);
                scenePo.setCreateTime(new Date());
                scenePo.setSceneName(sceneBo.getSceneName());
                scenePo.setSceneStatus(1L);
                scenePo.setRemark(UccConstants.YesOrNo.NO.toString());
                scenePoList.add(scenePo);
                UccSceneLogPO uccSceneLogPo = new UccSceneLogPO();
                uccSceneLogPo.setLogId(this.sequence.nextId());
                uccSceneLogPo.setSceneId(sceneId);
                uccSceneLogPo.setOldSceneCode(sceneBo.getSceneCode());
                uccSceneLogPo.setOldSceneName(sceneBo.getSceneName());
                uccSceneLogPo.setNewSceneCode(sceneBo.getSceneCode());
                uccSceneLogPo.setNewSceneName(sceneBo.getSceneName());
                uccSceneLogPo.setOperId(username);
                uccSceneLogPo.setOperTime(new Date());
                uccSceneLogPo.setOperRemark("\u5916\u90e8\u5bfc\u5165,\u65b0\u589e\u573a\u666f");
                sceneLogPoList.add(uccSceneLogPo);
            });
            if (!CollectionUtils.isEmpty(scenePoList)) {
                this.uccSceneMapper.insertBatch(scenePoList);
            }
            if (!CollectionUtils.isEmpty(sceneLogPoList)) {
                this.uccSceneLogMapper.insertBatch(sceneLogPoList);
            }
        }
    }

    private List<Long> dealUpdate(List<UccSceneBO> updateList, String username) {
        if (!CollectionUtils.isEmpty(updateList)) {
            ArrayList<UccScenePO> scenePoList = new ArrayList<UccScenePO>();
            ArrayList<UccSceneLogPO> sceneLogPoList = new ArrayList<UccSceneLogPO>();
            updateList.forEach(sceneBo -> {
                UccScenePO scenePo = new UccScenePO();
                scenePo.setSceneId(sceneBo.getSceneId());
                scenePo.setSceneCode(sceneBo.getSceneCode());
                scenePo.setSceneName(sceneBo.getSceneName());
                scenePoList.add(scenePo);
                UccSceneLogPO uccSceneLogPo = new UccSceneLogPO();
                uccSceneLogPo.setLogId(this.sequence.nextId());
                uccSceneLogPo.setSceneId(sceneBo.getSceneId());
                uccSceneLogPo.setOldSceneCode(sceneBo.getOldSceneCode());
                uccSceneLogPo.setOldSceneName(sceneBo.getOldSceneName());
                uccSceneLogPo.setNewSceneCode(sceneBo.getSceneCode());
                uccSceneLogPo.setNewSceneName(sceneBo.getSceneName());
                uccSceneLogPo.setOperId(username);
                uccSceneLogPo.setOperTime(new Date());
                uccSceneLogPo.setOperRemark("\u5916\u90e8\u5bfc\u5165,\u5df2\u5b58\u5728\u7684\u573a\u666f,\u66f4\u65b0\u573a\u666f");
                sceneLogPoList.add(uccSceneLogPo);
            });
            if (!CollectionUtils.isEmpty(scenePoList)) {
                this.uccSceneMapper.batchUpdateBy(scenePoList, username, UccConstants.YesOrNo.NO.toString());
            }
            if (!CollectionUtils.isEmpty(sceneLogPoList)) {
                this.uccSceneLogMapper.insertBatch(sceneLogPoList);
            }
            return this.dealRepeatData(username);
        }
        return new ArrayList<Long>();
    }

    private List<Long> dealRepeatData(String username) {
        List<Long> deletedComIds;
        Map<String, List<UccScenePO>> collectByName;
        List<UccScenePO> repeatWithName;
        List<Long> deletedComIds2;
        Map<String, List<UccScenePO>> collectByCode;
        ArrayList<Long> comIds = new ArrayList<Long>();
        List<UccScenePO> repeatWithCode = this.uccSceneMapper.getRepeatWithCode();
        if (!(CollectionUtils.isEmpty(repeatWithCode) || CollectionUtils.isEmpty(collectByCode = repeatWithCode.stream().collect(Collectors.groupingBy(UccScenePO::getSceneCode))) || CollectionUtils.isEmpty(deletedComIds2 = this.deleteRepeatData(collectByCode, username)))) {
            comIds.addAll(deletedComIds2);
        }
        if (!(CollectionUtils.isEmpty(repeatWithName = this.uccSceneMapper.getRepeatWithName()) || CollectionUtils.isEmpty(collectByName = repeatWithName.stream().collect(Collectors.groupingBy(UccScenePO::getSceneName))) || CollectionUtils.isEmpty(deletedComIds = this.deleteRepeatData(collectByName, username)))) {
            comIds.addAll(deletedComIds);
        }
        return comIds;
    }

    private List<Long> deleteRepeatData(Map<String, List<UccScenePO>> collectMap, String username) {
        Date now = new Date();
        ArrayList<Long> comIds = new ArrayList<Long>();
        ArrayList<UccSceneLogPO> uccSceneLogPoList = new ArrayList<UccSceneLogPO>();
        ArrayList<SceneRelUpdatePO> sceneRelUpdatePoList = new ArrayList<SceneRelUpdatePO>();
        collectMap.forEach((key, list) -> {
            if (!CollectionUtils.isEmpty((Collection)list)) {
                UccScenePO removePo = (UccScenePO)list.remove(0);
                list.forEach(uccScenePo -> {
                    UccSceneLogPO uccSceneLogPo = new UccSceneLogPO();
                    uccSceneLogPo.setLogId(this.sequence.nextId());
                    uccSceneLogPo.setSceneId(uccScenePo.getSceneId());
                    uccSceneLogPo.setOldSceneCode(uccScenePo.getSceneCode());
                    uccSceneLogPo.setOldSceneName(uccScenePo.getSceneName());
                    uccSceneLogPo.setNewSceneCode("");
                    uccSceneLogPo.setNewSceneName("");
                    uccSceneLogPo.setOperId(username);
                    uccSceneLogPo.setOperTime(now);
                    uccSceneLogPo.setOperRemark("\u5916\u90e8\u5bfc\u5165,\u66f4\u65b0\u540e\u6570\u636e\u91cd\u590d,\u5220\u9664\u573a\u666f");
                    uccSceneLogPoList.add(uccSceneLogPo);
                    SceneRelUpdatePO sceneRelUpdatePo = new SceneRelUpdatePO();
                    sceneRelUpdatePo.setOldSceneId(uccScenePo.getSceneId());
                    sceneRelUpdatePo.setNewSceneId(removePo.getSceneId());
                    sceneRelUpdatePoList.add(sceneRelUpdatePo);
                });
            }
        });
        if (!CollectionUtils.isEmpty(uccSceneLogPoList)) {
            List<Long> sceneIds = uccSceneLogPoList.stream().map(UccSceneLogPO::getSceneId).distinct().collect(Collectors.toList());
            this.uccSceneMapper.batchDeleteByIds(sceneIds);
            this.uccSceneLogMapper.insertBatch(uccSceneLogPoList);
            List<UccSceneSkuRelPO> listBySceneIds = this.uccSceneSkuSubscribeMapper.getListBySceneIds(sceneIds);
            if (!CollectionUtils.isEmpty(listBySceneIds)) {
                comIds.addAll(listBySceneIds.stream().map(UccSceneSkuRelPO::getCommodityId).distinct().collect(Collectors.toList()));
                if (!CollectionUtils.isEmpty(sceneRelUpdatePoList)) {
                    this.uccSceneSkuSubscribeMapper.batchUpdateSceneId(sceneRelUpdatePoList);
                }
            }
        }
        return comIds;
    }

    private Map<Long, List<Long>> getSyncEsCommodityIdList(List<UccSceneBO> updateList, List<Long> comIds) {
        List<UccSkuPo> skuPos;
        HashMap<Long, List<Long>> syncEsMap = new HashMap<Long, List<Long>>(2);
        List<Long> sceneIdList = updateList.stream().map(UccSceneBO::getSceneId).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(sceneIdList) && !CollectionUtils.isEmpty(skuPos = this.uccExtSkuMapper.getListByRelScenes(sceneIdList))) {
            Map<Long, List<UccSkuPo>> collect = skuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            collect.forEach((supplierShopId, skuList) -> {
                if (!CollectionUtils.isEmpty((Collection)skuList)) {
                    syncEsMap.put((Long)supplierShopId, skuList.stream().map(UccSkuPo::getCommodityId).distinct().collect(Collectors.toList()));
                }
            });
        }
        if (!CollectionUtils.isEmpty(comIds)) {
            if (syncEsMap.containsKey(UccConstants.ATOUR_SUPPLIER_SHOP_ID)) {
                List list = (List)syncEsMap.get(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
                list.addAll(comIds);
                syncEsMap.put(UccConstants.ATOUR_SUPPLIER_SHOP_ID, list);
            } else {
                syncEsMap.put(UccConstants.ATOUR_SUPPLIER_SHOP_ID, comIds);
            }
        }
        return syncEsMap;
    }
}

