/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.uccext.bo.CommodityIdBO;
import com.tydic.uccext.bo.SpecialBannerBO;
import com.tydic.uccext.bo.UccCatalogRecommendAddReqBO;
import com.tydic.uccext.bo.UccCatalogRecommendAddRspBO;
import com.tydic.uccext.dao.UccCatalogRecommendAddMapper;
import com.tydic.uccext.dao.UccSupplierMapper;
import com.tydic.uccext.dao.po.SupplierPO;
import com.tydic.uccext.dao.po.UccCatalogRecommendAddPO;
import com.tydic.uccext.service.UccCatalogRecommendAddBusiService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccCatalogRecommendAddBusiService"})
public class UccCatalogRecommendAddBusiServiceImpl
implements UccCatalogRecommendAddBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogRecommendAddBusiServiceImpl.class);
    @Autowired
    private UccCatalogRecommendAddMapper catalogRecommendAddMapper;
    @Autowired
    private UccSupplierMapper uccSupplierMapper;

    @PostMapping(value={"addCatalogRecommend"})
    public UccCatalogRecommendAddRspBO addCatalogRecommend(@RequestBody UccCatalogRecommendAddReqBO reqBO) {
        UccCatalogRecommendAddRspBO rspBO = new UccCatalogRecommendAddRspBO();
        UccCatalogRecommendAddPO recommendAddPO = null;
        ArrayList uccCatalogRecommendAddPOList = Lists.newArrayList();
        for (SpecialBannerBO specialBannerBO : reqBO.getSpecialBanners()) {
            for (CommodityIdBO commodityIdBO : specialBannerBO.getItemIdList()) {
                ArrayList supplierPOS = Lists.newArrayList();
                SupplierPO supplierPO = new SupplierPO();
                supplierPO.setCommodityId(commodityIdBO.getCommodityId());
                supplierPOS.add(supplierPO);
                recommendAddPO = new UccCatalogRecommendAddPO();
                recommendAddPO.setSkuId(commodityIdBO.getCommodityId().toString());
                recommendAddPO.setSkuLocation(specialBannerBO.getCatalogId());
                recommendAddPO.setColumnCode(specialBannerBO.getSpecialId().toString());
                List<SupplierPO> supplierPOList = this.uccSupplierMapper.querySupplierByCommodityId(supplierPOS);
                if (CollectionUtils.isEmpty(supplierPOList)) {
                    LOGGER.error("\u5546\u54c1\u7c7b\u76ee\u63a8\u8350\u5546\u54c1\u65b0\u589e\uff0c\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728,commodityId:" + commodityIdBO.getCommodityId());
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u65b0\u589e\u5f02\u5e38");
                    return rspBO;
                }
                recommendAddPO.setSupplierId(supplierPOList.get(0).getSupplierId());
                recommendAddPO.setSkuIndex(commodityIdBO.getSkuIndex());
                uccCatalogRecommendAddPOList.add(recommendAddPO);
            }
        }
        this.catalogRecommendAddMapper.addCatalogRecommend(uccCatalogRecommendAddPOList);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("8888");
        return rspBO;
    }
}

